/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import com.sun.jimi.core.Jimi;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.BevelBorder;

public class ImageFilePreviewer
extends JComponent
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File f = null;

    public ImageFilePreviewer(JFileChooser fc) {
        this.setPreferredSize(new Dimension(100, 50));
        fc.addPropertyChangeListener(this);
        this.setBorder(new BevelBorder(1));
        this.loadImage();
    }

    public void loadImage() {
        if (this.f != null) {
            try {
                ImageIcon tmpIcon = new ImageIcon(Jimi.getImage((String)this.f.getPath()));
                this.thumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop == "SelectedFileChangedProperty") {
            this.f = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }
}

