/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.DateChooserPanel;
import DE.siemens.ad.logo.dialog.comp.TimeInputPanel;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.util.CalendarListener;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DateParameterJPanel
extends BorderJPanel
implements ActionListener {
    private JLabel ivjLabelDate = null;
    private TimeInputPanel ivjTimeInputPanel = null;
    private Months fParameterObj = null;
    private JButton ivjCalendar = null;

    public DateParameterJPanel() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getCalendar()) {
            this.connEtoM1(e);
        }
    }

    public boolean checkChanged() {
        return this.getTimeInputPanel().checkChanged(this.fParameterObj);
    }

    public boolean checkFieldContents() {
        return this.getTimeInputPanel().checkFieldContents();
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.showDateChooser();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getCalendar() {
        if (this.ivjCalendar == null) {
            try {
                this.ivjCalendar = new JButton();
                this.ivjCalendar.setName("Calendar");
                this.ivjCalendar.setToolTipText(Language.getString("dialog.calendar.calendar", "Calendar"));
                this.ivjCalendar.setText("");
                this.ivjCalendar.setHorizontalTextPosition(0);
                this.ivjCalendar.setSelected(false);
                this.ivjCalendar.setIcon(Global.getIcon("DatePickerIcon.gif"));
                this.ivjCalendar.setBounds(144, 42, 25, 23);
                this.ivjCalendar.setMargin(new Insets(2, 2, 2, 2));
            }
            catch (Throwable ivjExc) {
                Log.error((Exception)ivjExc, "Error creating CalendarButton");
                this.handleException(ivjExc);
            }
        }
        return this.ivjCalendar;
    }

    public int getDay() {
        return this.getTimeInputPanel().getLowValue();
    }

    public void setDayEnabled(boolean state) {
        this.getTimeInputPanel().setLowEnabled(state);
    }

    public void setMonthEnabled(boolean state) {
        this.getTimeInputPanel().setHighEnabled(state);
    }

    private JLabel getLabelDate() {
        if (this.ivjLabelDate == null) {
            try {
                this.ivjLabelDate = new JLabel();
                this.ivjLabelDate.setName("LabelDate");
                this.ivjLabelDate.setText(Language.getString("dialog.parameter.yearClock.monatTag", "Month.Day"));
                this.ivjLabelDate.setBounds(9, 16, 100, 24);
                this.ivjLabelDate.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelDate;
    }

    public int getMonth() {
        return this.getTimeInputPanel().getHighValue();
    }

    private TimeInputPanel getTimeInputPanel() {
        if (this.ivjTimeInputPanel == null) {
            try {
                this.ivjTimeInputPanel = new TimeInputPanel();
                this.ivjTimeInputPanel.setName("TimeInputPanel");
                this.ivjTimeInputPanel.setLocation(9, 42);
                this.ivjTimeInputPanel.loadFieldContents(new Months());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTimeInputPanel;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.getCalendar().addActionListener(this);
    }

    private void initialize() {
        this.setName("DateParameterJPanel");
        this.setTitleColor(Color.black);
        this.setTitle("Datumsparameter");
        this.add((Component)this.getTimeInputPanel(), this.getTimeInputPanel().getName());
        this.add((Component)this.getCalendar(), this.getCalendar().getName());
        this.add((Component)this.getLabelDate(), this.getLabelDate().getName());
        this.initConnections();
        this.getTimeInputPanel().setSeparator(".");
    }

    public Dimension getPreferredSize() {
        return new Dimension(180, 75);
    }

    public void loadFieldContents() {
        this.getTimeInputPanel().loadFieldContents(this.fParameterObj);
    }

    public static void main(String[] args) {
        try {
            Frame frame;
            try {
                Class<?> aFrameClass = Class.forName("com.ibm.uvm.abt.edit.TestFrame");
                frame = (Frame)aFrameClass.newInstance();
            }
            catch (Throwable ivjExc) {
                frame = new Frame();
            }
            DateParameterJPanel aDateParameterJPanel = new DateParameterJPanel();
            frame.add("Center", aDateParameterJPanel);
            frame.setSize(aDateParameterJPanel.getSize());
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of DE.siemens.ad.logo.dialog.comp.BorderJPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void setDateValue(int month, int day) {
        this.ivjTimeInputPanel.setHighValue(month);
        this.ivjTimeInputPanel.setLowValue(day);
    }

    public void setParameter(Months paramObj) {
        this.fParameterObj = paramObj;
    }

    public void setParameterReference(Months paramObj) {
        this.fParameterObj = paramObj;
    }

    protected void showDateChooser() {
        DateChooserPanel dcp = new DateChooserPanel();
        dcp.setYearVisible(false);
        dcp.setYear(2000);
        try {
            dcp.setMonth(this.ivjTimeInputPanel.getHighValue());
            dcp.setDay(this.ivjTimeInputPanel.getLowValue());
        }
        catch (Exception e) {
            System.out.println("DateParameterJPanel: Tried to set wrong date or month");
        }
        SplittedDlg dialog = null;
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.getLabelDate());
        dialog = window instanceof JDialog ? SplittedDlg.create(window, dcp, 3) : SplittedDlg.create((JDialog)window, dcp, 3);
        final JButton okButton = dialog.getControlPanel().getControlButton(1);
        dcp.addCalendarListener(new CalendarListener(){

            public void invalidDate(DateChooserPanel dcp) {
                okButton.setEnabled(false);
            }

            public void validDate(DateChooserPanel dcp) {
                okButton.setEnabled(true);
            }
        });
        dialog.show();
        if (dialog.getControlPanel().getResult() == 1) {
            int month = dcp.getMonth();
            int day = dcp.getDay();
            this.setDateValue(month, day);
        }
    }

    public void storeFieldContents() {
        if (this.fParameterObj != null) {
            this.getTimeInputPanel().storeFieldContents(this.fParameterObj);
        }
    }
}

