/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.PropertiesIfc;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AnalogOutputTypePanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox fType1;
    private JComboBox fType2;
    private JLabel flblType1;
    private JLabel flblType2;
    private PropertiesIfc fModel;

    public AnalogOutputTypePanel(PropertiesIfc model) {
        this.fModel = model;
        this.initialize();
    }

    public boolean checkChanged() {
        return true;
    }

    public void loadFieldContents() {
        this.fType1.setSelectedIndex(this.fModel.getAQType1());
        this.fType2.setSelectedIndex(this.fModel.getAQType2());
    }

    public void storeFieldContents() {
        this.fModel.setAQType1(this.fType1.getSelectedIndex());
        this.fModel.setAQType2(this.fType2.getSelectedIndex());
    }

    public String getTitle() {
        return Language.getString("AnalogOutputTypePanel.title", "Analog Output Range");
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridBagLayout());
        this.add((Component)inputPanel, "Center");
        this.flblType1 = new JLabel();
        this.flblType1.setText(Language.getString("AnalogOutputTypePanel.rangeLabel1", "AQ1 type"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 15, 5, 5);
        inputPanel.add((Component)this.flblType1, gbc);
        this.fType1 = new JComboBox();
        this.fillComboBox(this.fType1);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        inputPanel.add((Component)this.fType1, gbc);
        this.flblType2 = new JLabel();
        this.flblType2.setText(Language.getString("AnalogOutputTypePanel.rangeLabel2", "AQ2 type"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 15, 5, 5);
        inputPanel.add((Component)this.flblType2, gbc);
        this.fType2 = new JComboBox();
        this.fillComboBox(this.fType2);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        inputPanel.add((Component)this.fType2, gbc);
    }

    public void setLabels() {
        this.setName(this.getTitle());
    }

    private void fillComboBox(JComboBox cob) {
        cob.addItem(Language.getString("AnalogOutputTypePanel.rangeType1", "Normal"));
        cob.addItem(Language.getString("AnalogOutputTypePanel.rangeType2", "4-20mA"));
        cob.setSelectedIndex(0);
    }
}

