/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.ZoomIfc;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ZoomPanel
extends DataInputPanel {
    ZoomIfc app;
    boolean fComponentsAdjusted = false;
    BorderJPanel zoomPanel;
    JRadioButton rb400percent;
    JRadioButton rb200percent;
    JRadioButton rb100percent;
    JRadioButton rb50percent;
    JRadioButton rb25percent;
    JLabel lPercent;
    EditableNumericSpinner nsPercent;

    public ZoomPanel(ZoomIfc obtainZoom) {
        this.app = obtainZoom;
        this.setSize(200, 300);
        this.setLayout(new BorderLayout());
        this.zoomPanel = new BorderJPanel();
        this.zoomPanel.setTitle(Language.getString("dialog.zoom.zoomPanel.label", "Zoom-Modus"));
        this.zoomPanel.setLayout(new BoxLayout(this.zoomPanel, 1));
        this.rb400percent = new JRadioButton();
        this.rb400percent.setText("400 %");
        this.zoomPanel.add(this.rb400percent);
        this.rb200percent = new JRadioButton();
        this.rb200percent.setText("200 %");
        this.zoomPanel.add(this.rb200percent);
        this.rb100percent = new JRadioButton();
        this.rb100percent.setText("100 %");
        this.zoomPanel.add(this.rb100percent);
        this.rb50percent = new JRadioButton();
        this.rb50percent.setText("50 %");
        this.zoomPanel.add(this.rb50percent);
        this.rb25percent = new JRadioButton();
        this.rb25percent.setText("25 %");
        this.zoomPanel.add(this.rb25percent);
        JPanel manualInput = new JPanel();
        manualInput.setLayout(new FlowLayout());
        this.lPercent = new JLabel();
        this.lPercent.setText(Language.getString("dialog.zoom.zoomPanel.percent", "Percent"));
        manualInput.add(this.lPercent);
        this.nsPercent = new EditableNumericSpinner();
        this.nsPercent.setColumns(4);
        manualInput.add(this.nsPercent);
        this.zoomPanel.add(manualInput);
        this.nsPercent.setMin(25);
        this.nsPercent.setMax(400);
        this.add(this.zoomPanel);
        SymNumericSpinner lSymNumericSpinner = new SymNumericSpinner();
        this.nsPercent.addNumericSpinnerListener(lSymNumericSpinner);
        SymAction lSymAction = new SymAction();
        this.rb25percent.addActionListener(lSymAction);
        this.rb50percent.addActionListener(lSymAction);
        this.rb100percent.addActionListener(lSymAction);
        this.rb200percent.addActionListener(lSymAction);
        this.rb400percent.addActionListener(lSymAction);
    }

    void checkPercent() {
        int value = this.nsPercent.getValue();
        this.rb400percent.setSelected(false);
        this.rb200percent.setSelected(false);
        this.rb100percent.setSelected(false);
        this.rb50percent.setSelected(false);
        this.rb25percent.setSelected(false);
        switch (value) {
            case 25: {
                this.rb25percent.setSelected(true);
                break;
            }
            case 50: {
                this.rb50percent.setSelected(true);
                break;
            }
            case 100: {
                this.rb100percent.setSelected(true);
                break;
            }
            case 200: {
                this.rb200percent.setSelected(true);
                break;
            }
            case 400: {
                this.rb400percent.setSelected(true);
                break;
            }
            default: {
                this.rb400percent.setSelected(false);
                this.rb200percent.setSelected(false);
                this.rb100percent.setSelected(false);
                this.rb50percent.setSelected(false);
                this.rb25percent.setSelected(false);
            }
        }
    }

    public String getTitle() {
        return Language.getString("dialog.zoom.title", "Zoom");
    }

    public void loadFieldContents() {
        this.nsPercent.setValue(this.app.getZoom());
        this.checkPercent();
    }

    void nsPercent_spinnerChanged(SpinnerChangedEvent event) {
        this.checkPercent();
    }

    void rb100percent_ItemStateChanged(ActionEvent event) {
        this.nsPercent.setValue(100);
    }

    void rb200percent_ItemStateChanged(ActionEvent event) {
        this.nsPercent.setValue(200);
    }

    void rb25percent_ItemStateChanged(ActionEvent event) {
        this.nsPercent.setValue(25);
    }

    void rb400percent_ItemStateChanged(ActionEvent event) {
        this.nsPercent.setValue(400);
    }

    void rb50percent_ItemStateChanged(ActionEvent event) {
        this.nsPercent.setValue(50);
    }

    public void setLabels() {
        this.zoomPanel.setTitle(Language.getString("dialog.zoom.zoomPanel.label", "Zoom mode"));
        this.lPercent.setText(Language.getString("dialog.zoom.zoomPanel.percent", "Percent"));
        this.nsPercent.setError(this.nsPercent.createDefaultError());
    }

    public void storeFieldContents() {
        this.app.setZoom(this.nsPercent.getValue());
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ZoomPanel.this.rb25percent) {
                ZoomPanel.this.rb25percent_ItemStateChanged(event);
            } else if (object == ZoomPanel.this.rb50percent) {
                ZoomPanel.this.rb50percent_ItemStateChanged(event);
            } else if (object == ZoomPanel.this.rb100percent) {
                ZoomPanel.this.rb100percent_ItemStateChanged(event);
            } else if (object == ZoomPanel.this.rb200percent) {
                ZoomPanel.this.rb200percent_ItemStateChanged(event);
            } else if (object == ZoomPanel.this.rb400percent) {
                ZoomPanel.this.rb400percent_ItemStateChanged(event);
            }
        }
    }

    class SymNumericSpinner
    implements NumericSpinnerListener {
        SymNumericSpinner() {
        }

        public void spinnerChanged(SpinnerChangedEvent event) {
            Object object = event.getSource();
            if (object == ZoomPanel.this.nsPercent) {
                ZoomPanel.this.nsPercent_spinnerChanged(event);
            }
        }
    }
}

