/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.dialog.AbstractTrendModel;
import DE.siemens.ad.logo.dialog.GroupTrendModel;
import DE.siemens.ad.logo.dialog.TrendModel;
import DE.siemens.ad.logo.dialog.TrendPanelModel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TrendViewPanel
extends JPanel {
    public static final int DFT_GRID_WIDTH = 4;
    public static final int DFT_GRID_HEIGHT = 20;
    public static final int MIN_GRID_WIDTH = 2;
    public static final int MIN_GRID_HEIGHT = 5;
    public static final String LEFT_SIDE = "left_side";
    public static final String RIGHT_SIDE = "right_side";
    private static final long serialVersionUID = 1L;
    private int columnUnits;
    private int width = 0;
    private int height = 0;
    private int gridWidth;
    private int gridHeight;
    private int sideMargin = 40;
    private int topMargin = 30;
    private int bottomMargin = 70;
    private Point2D leftBottom;
    private Point2D leftTop;
    private Point2D rightBottom;
    private Line2D timeAxis;
    private Line2D leftAxis;
    private Line2D rightAxis;
    private String panelName;
    private String[] timers = null;
    private TrendPanelModel panelModel;
    private HashMap allModel = new HashMap();
    private short[] signal = new short[0];
    private int cyclesToRepaint = 1;

    public TrendViewPanel(TrendPanelModel model, String title, int width, int height) {
        this.panelModel = model;
        this.panelName = title;
        this.columnUnits = model.getSampleNum() / this.panelModel.getTrendColumn();
        this.width = width;
        this.height = height;
        this.timers = new String[this.panelModel.getTrendColumn() + 1];
        this.caculateUIParams();
        for (int i = 0; i < this.timers.length; ++i) {
            this.timers[i] = "";
        }
        this.setPreferredSize(new Dimension(this.width, this.height));
        this.setBackground(Color.white);
        this.leftBottom = new Point2D.Double(this.sideMargin, this.topMargin + this.gridHeight * this.panelModel.getTrendRow());
        this.leftTop = new Point2D.Double(this.leftBottom.getX(), this.topMargin);
        this.rightBottom = new Point2D.Double(this.leftBottom.getX() + (double)(this.panelModel.getTrendColumn() * this.columnUnits * this.gridWidth), this.leftBottom.getY());
        this.timeAxis = new Line2D.Double(this.leftBottom, this.rightBottom);
        this.leftAxis = new Line2D.Double(this.leftBottom, this.leftTop);
        this.rightAxis = new Line2D.Double(this.rightBottom.getX(), this.rightBottom.getY(), this.rightBottom.getX(), this.leftTop.getY());
    }

    public TrendViewPanel(TrendPanelModel model, String title) {
        this(model, title, 0, 0);
    }

    public TrendViewPanel(TrendPanelModel model) {
        this(model, "", 0, 0);
    }

    public void setTrendModelAt(String side, AbstractTrendModel tModel) {
        if (side.equals(LEFT_SIDE) || side.equals(RIGHT_SIDE)) {
            this.allModel.put(side, tModel);
        }
    }

    public AbstractTrendModel getTrendModelAt(String side) {
        return (AbstractTrendModel)this.allModel.get(side);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(1.2f));
        g2.setPaint(Color.BLACK);
        g2.setStroke(new BasicStroke(1.0f));
        g2.draw(this.timeAxis);
        g2.draw(this.leftAxis);
        g2.draw(this.rightAxis);
        int row = this.panelModel.getTrendRow();
        int col = this.panelModel.getTrendColumn();
        g2.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{12.0f}, 0.0f));
        for (int i2 = 0; i2 <= row; ++i2) {
            g2.draw(new Line2D.Double(this.leftBottom.getX() - 3.0, this.leftBottom.getY() - (double)(i2 * this.gridHeight), this.leftBottom.getX() + 3.0, this.leftBottom.getY() - (double)(i2 * this.gridHeight)));
            g2.draw(new Line2D.Double(this.rightBottom.getX() - 3.0, this.leftBottom.getY() - (double)(i2 * this.gridHeight), this.rightBottom.getX() + 3.0, this.leftBottom.getY() - (double)(i2 * this.gridHeight)));
        }
        g2.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 2.0f, 2.0f, 2.0f}, 0.0f));
        Color c = g2.getColor();
        g2.setColor(new Color(0xCCCCCC));
        for (i = 1; i <= row; ++i) {
            Line2D.Double scaleVer = new Line2D.Double(this.leftBottom.getX() + 3.0, this.leftBottom.getY() - (double)(i * this.gridHeight), this.rightBottom.getX() - 3.0, this.leftBottom.getY() - (double)(i * this.gridHeight));
            g2.draw(scaleVer);
        }
        g2.setColor(c);
        for (i = 0; i < this.columnUnits * col + 1; ++i) {
            float[] fArray;
            if (i % this.columnUnits == 0) {
                float[] fArray2 = new float[1];
                fArray = fArray2;
                fArray2[0] = 6.0f;
            } else {
                float[] fArray3 = new float[1];
                fArray = fArray3;
                fArray3[0] = 4.0f;
            }
            g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f));
            Line2D.Double cycleTicker = new Line2D.Double(this.leftBottom.getX() + (double)(i * this.gridWidth), this.leftBottom.getY(), this.leftBottom.getX() + (double)(i * this.gridWidth), this.leftBottom.getY() + (double)(i % this.columnUnits == 0 ? 6 : 3));
            g2.draw(cycleTicker);
        }
        g2.setStroke(new BasicStroke(1.0f));
        Rectangle2D bound = g2.getFont().getStringBounds(this.timers[0], g2.getFontRenderContext());
        double xOffset = bound.getWidth() / 2.0 * Math.cos(Math.toRadians(315.0));
        for (int i3 = 0; i3 < this.timers.length; ++i3) {
            AffineTransform oldTransform = g2.getTransform();
            g2.transform(AffineTransform.getRotateInstance(Math.toRadians(315.0), this.rightBottom.getX() - (double)(i3 * this.columnUnits * this.gridWidth) - xOffset, this.leftBottom.getY() + bound.getWidth()));
            g.drawString(this.timers[this.timers.length - i3 - 1], (int)(this.rightBottom.getX() - (double)(i3 * this.columnUnits * this.gridWidth) - xOffset), (int)(this.leftBottom.getY() + bound.getWidth()));
            g2.setTransform(oldTransform);
        }
        short[] sArray = this.signal;
        synchronized (this.signal) {
            this.paintTrend(g);
            // ** MonitorExit[var9_12] (shouldn't be in output)
            return;
        }
    }

    private void paintTrend(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        ArrayList<TrendModel> visibleTrends = new ArrayList<TrendModel>();
        FontRenderContext context = g2.getFontRenderContext();
        Font f = g2.getFont();
        for (Object whichSide : this.allModel.keySet()) {
            Iterator iter;
            AbstractTrendModel model = (AbstractTrendModel)this.allModel.get(whichSide);
            if (model == null || !model.isVisible()) continue;
            if (model instanceof TrendModel) {
                ArrayList<AbstractTrendModel> list = new ArrayList<AbstractTrendModel>();
                list.add(model);
                iter = list.iterator();
            } else {
                iter = ((GroupTrendModel)model).getTrendModelIter();
            }
            int boundOffset = 0;
            while (iter.hasNext()) {
                TrendModel trendModel = (TrendModel)iter.next();
                if (!trendModel.isVisible()) continue;
                visibleTrends.add(trendModel);
                g2.setPaint(trendModel.getColor());
                double[] valueTicker = model.getValueTickers();
                for (int i = 0; i < valueTicker.length; ++i) {
                    Rectangle2D bounds = f.getStringBounds((int)valueTicker[i] + "", context);
                    if (whichSide.equals(LEFT_SIDE)) {
                        g2.drawString((int)valueTicker[i] + "", (int)(this.leftBottom.getX() - bounds.getWidth() - 8.0), (int)(this.leftBottom.getY() - (double)(i * this.gridHeight) + 5.0));
                        continue;
                    }
                    g2.drawString((int)valueTicker[i] + "", (int)(this.rightBottom.getX() + 8.0), (int)(this.leftBottom.getY() - (double)(i * this.gridHeight) + 5.0));
                }
                int yOffset = (int)this.leftTop.getY() - 10;
                Rectangle2D bound = g2.getFont().getStringBounds(trendModel.getName(), g2.getFontRenderContext());
                if (whichSide.equals(LEFT_SIDE)) {
                    g.drawString(trendModel.getName(), (int)this.leftBottom.getX() + boundOffset, yOffset);
                } else {
                    g.drawString(trendModel.getName(), (int)(this.leftBottom.getX() + (double)(this.columnUnits * this.panelModel.getTrendColumn() * this.gridWidth) - bound.getWidth() - (double)boundOffset), yOffset);
                }
                boundOffset = (int)((double)boundOffset + (bound.getWidth() + 5.0));
            }
        }
        this.paintTrendContent(g2, visibleTrends);
    }

    private void paintTrendContent(Graphics2D g, List visibleTrendsList) {
        int visibleTrendsNum = visibleTrendsList.size();
        int totalSamplesToDraw = 0;
        if (visibleTrendsNum > 0 && (totalSamplesToDraw = visibleTrendsNum * (((TrendModel)visibleTrendsList.get(0)).getValidSampleNum() - 1)) == 0) {
            return;
        }
        int[] trendSelector = new int[visibleTrendsNum * visibleTrendsNum];
        int fillIdx = 0;
        boolean ascend = true;
        for (int i = 0; i < visibleTrendsNum; ++i) {
            trendSelector[fillIdx++] = i;
            for (int j = 0; j < visibleTrendsNum; ++j) {
                if (j == i) continue;
                trendSelector[fillIdx++] = j;
            }
            if (!ascend) {
                int startPos = fillIdx - visibleTrendsNum + 1;
                for (int m = 0; m < (visibleTrendsNum - 1) / 2; ++m) {
                    int swap = trendSelector[startPos + m];
                    trendSelector[startPos + m] = trendSelector[fillIdx - 1 - m];
                    trendSelector[fillIdx - 1 - m] = swap;
                }
            }
            ascend = !ascend;
        }
        for (int drawIdx = 0; drawIdx < totalSamplesToDraw; ++drawIdx) {
            int currSampleIdx = drawIdx / visibleTrendsNum;
            TrendModel trend = (TrendModel)visibleTrendsList.get(trendSelector[drawIdx % trendSelector.length]);
            g.setColor(trend.getColor());
            g.draw(new Line2D.Double(this.getActualX(currSampleIdx), this.leftBottom.getY() - (this.leftBottom.getY() - this.leftTop.getY()) * trend.getRelYOffset(currSampleIdx), this.getActualX(currSampleIdx + 1), this.leftBottom.getY() - (this.leftBottom.getY() - this.leftTop.getY()) * trend.getRelYOffset(currSampleIdx + 1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextCycle() {
        short[] sArray = this.signal;
        synchronized (this.signal) {
            for (Object m : this.allModel.values()) {
                if ((AbstractTrendModel)m == null) continue;
                ((AbstractTrendModel)m).flushOneSample();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.cyclesToRepaint++ % this.panelModel.getSampleProd() == 0) {
                this.resetTimeStrings();
                this.repaint();
                if (this.cyclesToRepaint > this.panelModel.getSampleProd()) {
                    this.cyclesToRepaint -= this.panelModel.getSampleProd();
                }
            }
            return;
        }
    }

    private void resetTimeStrings() {
        GregorianCalendar now = new GregorianCalendar();
        for (int i = this.timers.length - 1; i >= 0; --i) {
            this.timers[i] = this.getTimeString(now);
            now.add(13, -1 * this.columnUnits * this.panelModel.getSampleProd());
        }
    }

    private String getTimeString(GregorianCalendar now) {
        int hour = now.get(11);
        int minute = now.get(12);
        int second = now.get(13);
        return (hour > 9 ? "" + hour : "0" + hour) + ":" + (minute > 9 ? "" + minute : "0" + minute) + ":" + (second > 9 ? "" + second : "0" + second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSampleProd(int sampleProd) {
        short[] sArray = this.signal;
        synchronized (this.signal) {
            this.panelModel.setSampleProd(sampleProd);
            this.resetTimeStrings();
            this.repaint();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int getSampleProd() {
        return this.panelModel.getSampleProd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(String trendName, boolean visible) {
        short[] sArray = this.signal;
        synchronized (this.signal) {
            for (AbstractTrendModel m : this.allModel.values()) {
                if (m instanceof TrendModel) {
                    if (!((TrendModel)m).getName().equals(trendName)) continue;
                    ((TrendModel)m).setVisible(visible);
                    break;
                }
                ((GroupTrendModel)m).setVisible(trendName, visible);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.repaint();
            return;
        }
    }

    public String getPanelName() {
        return this.panelName;
    }

    public void setPanelName(String title) {
        this.panelName = title;
    }

    private double getActualX(int index) {
        return this.rightBottom.getX() - (double)(index * this.gridWidth);
    }

    private void caculateUIParams() {
        int col = this.panelModel.getTrendColumn();
        int row = this.panelModel.getTrendRow();
        if (this.width == 0) {
            this.gridWidth = 4;
            this.width = this.sideMargin * 2 + this.columnUnits * col * this.gridWidth;
        } else {
            this.gridWidth = Math.round((this.width - this.sideMargin * 2) / (this.columnUnits * col));
            if (this.gridWidth < 2) {
                this.gridWidth = 2;
                this.width = this.sideMargin * 2 + this.columnUnits * col * this.gridWidth;
                System.err.println("width too small, changed to " + this.width);
            }
        }
        if (this.height == 0) {
            this.gridHeight = 20;
            this.height = this.topMargin + this.bottomMargin + row * this.gridHeight;
        } else {
            this.gridHeight = Math.round((this.height - this.topMargin - this.bottomMargin) / row);
            if (this.gridHeight < 5) {
                this.gridHeight = 5;
                this.height = this.topMargin + this.bottomMargin + row * this.gridHeight;
            }
        }
    }

    public void clearHistory() {
        for (Object obj : this.allModel.values()) {
            ((AbstractTrendModel)obj).clear();
        }
    }

    public static void main(String[] args) {
        final TrendPanelModel gmodel = new TrendPanelModel(10, 12, 8);
        final TrendModel t1 = new TrendModel(gmodel, new CosineSampler(), "T1", Color.blue);
        TrendModel t2 = new TrendModel(gmodel, new SineSampler(), "T2", Color.darkGray);
        TrendModel t3 = new TrendModel(gmodel, new SquareWaveSampler(), "T3", Color.magenta);
        TrendModel t4 = new TrendModel(gmodel, new ConstSampler(), "T4", Color.red);
        TrendModel t5 = new TrendModel(gmodel, new ConstSampler(), "T5", Color.green);
        TrendModel t6 = new TrendModel(gmodel, new ConstSampler(), "T6", Color.blue);
        final TrendModel[] trends = new TrendModel[]{t1, t2, t3, t4, t5, t6};
        GroupTrendModel trendModel1 = new GroupTrendModel(gmodel);
        trendModel1.addTrendModel(t1);
        trendModel1.addTrendModel(t2);
        trendModel1.addTrendModel(t3);
        GroupTrendModel trendModel2 = new GroupTrendModel(gmodel);
        trendModel2.addTrendModel(t4);
        trendModel2.addTrendModel(t5);
        trendModel2.addTrendModel(t6);
        final TrendViewPanel panel = new TrendViewPanel(gmodel);
        panel.setTrendModelAt(LEFT_SIDE, trendModel1);
        panel.setTrendModelAt(RIGHT_SIDE, trendModel2);
        panel.setFocusable(true);
        panel.addKeyListener(new KeyAdapter(){
            TrendModel at;
            {
                this.at = t1;
            }

            public void keyPressed(KeyEvent e) {
                char ch = Character.toLowerCase(e.getKeyChar());
                if (ch >= '1' && ch < 49 + trends.length) {
                    this.at = trends[ch - 49];
                } else if (ch == 'v') {
                    panel.setVisible("T" + this.at.getName().charAt(1), !this.at.visible);
                } else if (ch == '+') {
                    panel.setSampleProd(gmodel.getSampleProd() + 1);
                } else if (ch == '-' && gmodel.getSampleProd() > 1) {
                    panel.setSampleProd(gmodel.getSampleProd() - 1);
                }
            }
        });
        JFrame f = new JFrame();
        Container pane = f.getContentPane();
        panel.setLayout(new BorderLayout());
        pane.add((Component)panel, "Center");
        f.pack();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        f.setVisible(true);
        new Timer().schedule(new TimerTask(){

            public void run() {
                System.out.print(".");
                panel.nextCycle();
            }
        }, 500L, 100L);
    }

    private static class ConstSampler
    implements TrendModel.SampleStrategy {
        private ConstSampler() {
        }

        public double getOneSample() {
            return 7.0;
        }
    }

    private static class SquareWaveSampler
    implements TrendModel.SampleStrategy {
        int period = 10;
        int topValue = 25;
        int botValue = -19;
        long i = 0L;

        private SquareWaveSampler() {
        }

        public double getOneSample() {
            if (++this.i / 10L % 2L == 0L) {
                return this.botValue;
            }
            return this.topValue;
        }
    }

    private static class CosineSampler
    implements TrendModel.SampleStrategy {
        long i = 0L;

        private CosineSampler() {
        }

        public double getOneSample() {
            return Math.cos((double)this.i++ * Math.PI / 20.0) * 20.0;
        }
    }

    private static class SineSampler
    implements TrendModel.SampleStrategy {
        long i = 0L;

        private SineSampler() {
        }

        public double getOneSample() {
            return Math.sin((double)this.i++ * Math.PI / 10.0) * 5.0;
        }
    }
}

