/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TrendPanelModel {
    public static final int DFT_TREND_ROW = 6;
    public static final int DFT_COLUMN_UNIT = 5;
    public static final int DFT_TREND_COLUMN = 20;
    public static final double DEFAULT_RANGE_FACTOR = 0.9;
    private int trendRow;
    private int trendColumn;
    private int sampleProd;
    private int sampleNum;
    protected double trendRangeFactor = 0.9;
    private List listeners = null;

    public int getTrendRow() {
        return this.trendRow;
    }

    public int getTrendColumn() {
        return this.trendColumn;
    }

    public int getSampleNum() {
        return this.sampleNum;
    }

    TrendPanelModel(int columnUnit, int trendColumn, int trendRow, int sampleProd) {
        this.trendColumn = trendColumn;
        this.sampleNum = columnUnit * trendColumn + 1;
        this.trendRow = trendRow;
        this.sampleProd = sampleProd;
    }

    TrendPanelModel(int columnUnit, int trendColumn, int trendRow) {
        this(columnUnit, trendColumn, trendRow, 1);
    }

    TrendPanelModel() {
        this(5, 20, 6, 1);
    }

    public int getSampleProd() {
        return this.sampleProd;
    }

    public void setSampleProd(int sampleFreq) {
        this.fireTrendModelChangeEvent(new TrendModelChangEvent(this, TrendModelChangEvent.PROP_SAMPLE_FREQ, new Integer(this.sampleProd), new Integer(sampleFreq)));
        this.sampleProd = sampleFreq;
    }

    public void addTrendModelChangeListener(TrendModelChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void fireTrendModelChangeEvent(TrendModelChangEvent evt) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((TrendModelChangedListener)iter.next()).trendModelChanged(evt);
        }
    }

    public static class TrendModelChangEvent
    extends PropertyChangeEvent {
        public static String PROP_SAMPLE_FREQ = "sample period";

        public TrendModelChangEvent(Object source, String propertyName, Object oldValue, Object newValue) {
            super(source, propertyName, oldValue, newValue);
        }
    }

    public static interface TrendModelChangedListener {
        public void trendModelChanged(TrendModelChangEvent var1);
    }
}

