/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.dialog.AbstractTrendModel;
import DE.siemens.ad.logo.dialog.TrendPanelModel;
import java.awt.Color;

public class TrendModel
extends AbstractTrendModel {
    private double[] secSamples = null;
    private double[] unitSamples = null;
    private int secSampleIndex = 0;
    private int unitSampleIndex = 0;
    private int idxFromLastRepaint = 0;
    private String name;
    private SampleStrategy sampleStrategy;
    private Color color = Color.black;
    protected int validSecSampleNum = 0;
    protected int validUnitSampleNum = 0;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public TrendModel(TrendPanelModel panelModel, SampleStrategy sampleStrategy, String name) {
        super(panelModel);
        this.sampleStrategy = sampleStrategy;
        this.name = name;
        this.secSamples = new double[panelModel.getSampleNum()];
        this.unitSamples = new double[panelModel.getSampleNum()];
    }

    public TrendModel(TrendPanelModel panelModel, SampleStrategy sampleStrategy, String name, Color color) {
        this(panelModel, sampleStrategy, name);
        this.color = color;
    }

    public void flushOneSample() {
        int sampleNum = this.globalModel.getSampleNum();
        if (this.secSampleIndex == sampleNum) {
            this.secSampleIndex = 0;
        }
        if (this.unitSampleIndex == sampleNum) {
            this.unitSampleIndex = 0;
        }
        double currSampleValue = this.sampleStrategy.getOneSample();
        this.secSamples[this.secSampleIndex++] = currSampleValue;
        if (this.validSecSampleNum < sampleNum) {
            ++this.validSecSampleNum;
        }
        boolean isViewRepaint = false;
        if (this.idxFromLastRepaint++ % this.localSampleFreq == 0) {
            isViewRepaint = true;
            if (this.idxFromLastRepaint > this.localSampleFreq) {
                this.idxFromLastRepaint -= this.localSampleFreq;
            }
        }
        if (isViewRepaint) {
            if (this.validUnitSampleNum > 0) {
                double oldMax = this.maxSampleValue;
                double oldMin = this.minSampleValue;
                if (this.validUnitSampleNum == sampleNum) {
                    if ((this.unitSamples[this.unitSampleIndex] == this.minSampleValue || this.unitSamples[this.unitSampleIndex] == this.maxSampleValue) && this.minSampleValue != this.maxSampleValue) {
                        this.scanPoleValues(true);
                    }
                } else {
                    ++this.validUnitSampleNum;
                }
                if (currSampleValue > this.maxSampleValue) {
                    this.maxSampleValue = currSampleValue;
                } else if (currSampleValue < this.minSampleValue) {
                    this.minSampleValue = currSampleValue;
                }
                if (this.maxSampleValue != oldMax || this.minSampleValue != oldMin) {
                    this.extremumChanged();
                }
            } else {
                ++this.validUnitSampleNum;
                this.maxSampleValue = this.minSampleValue = currSampleValue;
                this.extremumChanged();
            }
            this.unitSamples[this.unitSampleIndex++] = currSampleValue;
        }
    }

    public String getName() {
        return this.name;
    }

    private void scanPoleValues(boolean isValueCasted) {
        int endIdx = this.validUnitSampleNum;
        if (isValueCasted) {
            double oldMinValue = this.minSampleValue;
            double oldMaxValue = this.maxSampleValue;
            double castedValue = this.getUnitValueAt(this.globalModel.getSampleNum() - 1);
            double nearValue = this.getUnitValueAt(this.globalModel.getSampleNum() - 2);
            if (castedValue == oldMinValue && oldMinValue == nearValue || castedValue == oldMaxValue && oldMaxValue == nearValue) {
                return;
            }
            --endIdx;
        }
        this.maxSampleValue = this.minSampleValue = this.getUnitValueAt(0);
        for (int i = 1; i < endIdx; ++i) {
            double currValue = this.getUnitValueAt(i);
            if (currValue > this.maxSampleValue) {
                this.maxSampleValue = currValue;
            }
            if (!(currValue < this.minSampleValue)) continue;
            this.minSampleValue = currValue;
        }
    }

    public void extremumChanged() {
        this.updateRangeValue();
        if (this.isVisible()) {
            this.setChanged();
            this.notifyObservers(EXTREMUM_ATTR);
        }
    }

    public double getUnitValueAt(int pos) {
        return this.unitSamples[(this.unitSampleIndex - 1 - pos + this.globalModel.getSampleNum()) % this.globalModel.getSampleNum()];
    }

    protected double getSampleValueAt(int pos) {
        return this.secSamples[(this.secSampleIndex - 1 - pos + this.globalModel.getSampleNum()) % this.globalModel.getSampleNum()];
    }

    public double getRelYOffset(int pos) {
        double v = this.getUnitValueAt(pos);
        if (v > this.maxTickValue || v < this.minTickValue) {
            System.err.println("Max: " + this.maxTickValue + ", Min: " + this.minTickValue + ". Value: " + v);
        }
        return (v - this.minTickValue) / (this.maxTickValue - this.minTickValue);
    }

    public int getValidSampleNum() {
        return this.validUnitSampleNum;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            if (visible) {
                this.scanPoleValues(false);
                this.updateRangeValue();
            }
            this.visible = visible;
            this.setChanged();
            this.notifyObservers(VISIBLITY_ATTR);
        }
    }

    public String toString() {
        return this.name;
    }

    public void setSampleProd(int newSampleFreq) {
        if (newSampleFreq != this.localSampleFreq) {
            this.validUnitSampleNum = this.validSecSampleNum / newSampleFreq;
            if (this.validSecSampleNum % newSampleFreq != 0) {
                ++this.validUnitSampleNum;
            }
            for (int startPos = 0; startPos < this.validUnitSampleNum; ++startPos) {
                this.unitSamples[this.globalModel.getSampleNum() - 1 - startPos] = this.getSampleValueAt(startPos * newSampleFreq);
            }
            this.unitSampleIndex = 0;
            if (this.validUnitSampleNum > 0) {
                this.scanPoleValues(false);
                this.updateRangeValue();
            }
            this.localSampleFreq = newSampleFreq;
        }
    }

    public void clear() {
        this.secSampleIndex = 0;
        this.unitSampleIndex = 0;
        this.idxFromLastRepaint = 0;
        this.validSecSampleNum = 0;
        this.validUnitSampleNum = 0;
    }

    public static interface SampleStrategy {
        public double getOneSample();
    }
}

