/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Version;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SplashPanel
extends DataInputPanel {
    protected JPanel javaPanel;
    protected JLabel applicationNameLbl;
    protected JLabel versionLbl;
    protected JLabel additionalLbl;
    protected JLabel copyrightLbl;
    protected JLabel imageLbl;
    protected JLabel companyLogo;
    protected JLabel buildTimeLbl;

    public SplashPanel() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        JPanel textPanel = new JPanel(new GridBagLayout());
        textPanel.setBackground(new Color(200, 216, 232, 172));
        this.applicationNameLbl = new JLabel("LOGO!Soft-Comfort");
        this.applicationNameLbl.setFont(new Font("dialog", 1, 18));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        textPanel.add((Component)this.applicationNameLbl, gbc);
        Box versionPanel = new Box(0);
        this.versionLbl = new JLabel("Beta V0.0.0");
        this.versionLbl.setFont(new Font("dialog", 1, 14));
        versionPanel.add(this.versionLbl);
        this.buildTimeLbl = new JLabel();
        this.buildTimeLbl.setFont(new Font("dialog", 1, 14));
        versionPanel.add(this.buildTimeLbl);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        textPanel.add((Component)versionPanel, gbc);
        this.additionalLbl = new JLabel("Beta");
        this.additionalLbl.setFont(new Font("dialog", 1, 14));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        textPanel.add((Component)this.additionalLbl, gbc);
        this.copyrightLbl = new JLabel("\u00a9 Siemens AG 2000");
        this.copyrightLbl.setFont(new Font("dialog", 2, 12));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 4;
        textPanel.add((Component)this.copyrightLbl, gbc);
        this.companyLogo = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.anchor = 13;
        this.add((Component)this.companyLogo, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        this.add((Component)textPanel, gbc);
        gbc = new GridBagConstraints();
        this.imageLbl = new JLabel();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.imageLbl, gbc);
    }

    public final void setLabels() {
        Version version = Version.getCurrentVersion();
        this.versionLbl.setText(version.toString());
        String buildTime = version.getBuildTime();
        this.buildTimeLbl.setVerifyInputWhenFocusTarget(buildTime != null);
        if (buildTime != null) {
            this.buildTimeLbl.setText(" (" + buildTime + ")");
        }
        this.additionalLbl.setText(version.getVersionAddon());
        this.companyLogo.setIcon(Global.getIcon(Language.getString("app.companyLogo", "Empty.gif"), "Empty.gif"));
        this.applicationNameLbl.setText(Application.getName());
        File file = new File("./lib/classes.jar");
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(new Date(file.lastModified()));
        String year = Language.getString("copyright.year", date.get(1) + "");
        StringBuffer copyright = new StringBuffer(40);
        copyright.append("\u00a9 ").append(Language.getString("app.companyName.long", "")).append(" ").append(year);
        this.copyrightLbl.setText(copyright.toString());
        try {
            ImageIcon imageIcon = Global.getIcon(Language.getString("app.aboutPicture", "Empty.gif"), "Empty.gif");
            this.imageLbl.setIcon(imageIcon);
        }
        catch (Exception ex) {
            return;
        }
    }

    public void setShowCopyright(boolean newValue) {
        this.copyrightLbl.setVisible(newValue);
    }
}

