/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.OptionsIfc;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class SimulationOptionsPanel
extends DataInputPanel {
    private JCheckBox fStartSimulationAutomatically;
    private JCheckBox fShowParameterValues;
    private JCheckBox fShowStates;
    private JCheckBox fResetInputs;
    private JCheckBox fShowTDSimPanel;
    private OptionsIfc fOptions;
    public static String SIMULATION_RESET = "simulation.resetFlag";
    public static String SIMULATION_TD_MSG = "simulation.showTDMsg";

    public SimulationOptionsPanel(OptionsIfc options) {
        this.fOptions = options;
        this.initComponents();
    }

    public String getTitle() {
        return Language.getString("dialog.options.simulationTab.label", "Simulation");
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.fStartSimulationAutomatically = new JCheckBox("Start simulation when entering simulatio mode");
        this.fShowParameterValues = new JCheckBox("Show parameter values");
        this.fShowStates = new JCheckBox("Show states");
        this.fResetInputs = new JCheckBox("Reset (Analog) Inputs");
        this.add(this.fStartSimulationAutomatically);
        this.add(Box.createVerticalStrut(10));
        this.add(this.fShowParameterValues);
        this.add(this.fShowStates);
        this.fShowTDSimPanel = new JCheckBox("TD Message Simulation");
        this.add(this.fShowTDSimPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(this.fResetInputs);
    }

    public void loadFieldContents() {
        this.fStartSimulationAutomatically.setSelected(LogoProperties.instance().getBooleanProperty("simulation.startAutomatically", false));
        this.fShowParameterValues.setSelected(this.fOptions.getShowParameterValuesDuringSimulation());
        this.fShowStates.setSelected(this.fOptions.getShowStatesDuringSimulation());
        this.fResetInputs.setSelected(LogoProperties.instance().getBooleanProperty(SIMULATION_RESET, false));
        this.fShowTDSimPanel.setSelected(LogoProperties.instance().getBooleanProperty(SIMULATION_TD_MSG, true));
    }

    public void setLabels() {
        this.fStartSimulationAutomatically.setText(Language.getString("dialog.options.simulationTab.automaticallyStartSimulation", "Start simulation when entering simuulation mode."));
        this.fShowStates.setText(Language.getString("dialog.options.simulationTab.showStatesDuringSimulation", "Show states"));
        this.fShowParameterValues.setText(Language.getString("dialog.options.simulationTab.showParameterValuesDuringSimulation", "Show parameter values"));
        this.fResetInputs.setText(Language.getString("dialog.options.simulationTab.resetInputs", "Reset Signal State When Start Simulation"));
        this.fShowTDSimPanel.setText(Language.getString("dialog.options.simulationTab.showTDMsg", "Show separated TD Window for Message text"));
    }

    public void storeFieldContents() {
        LogoProperties.instance().setBooleanProperty("simulation.startAutomatically", this.fStartSimulationAutomatically.isSelected());
        this.fOptions.setShowParameterValuesDuringSimulation(this.fShowParameterValues.isSelected());
        this.fOptions.setShowStatesDuringSimulation(this.fShowStates.isSelected());
        LogoProperties.instance().setBooleanProperty(SIMULATION_RESET, this.fResetInputs.isSelected());
        LogoProperties.instance().setBooleanProperty(SIMULATION_TD_MSG, this.fShowTDSimPanel.isSelected());
    }

    public Icon getIcon() {
        return Global.getIcon("Simulation.gif");
    }
}

