/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ReadmePanel
extends DataInputPanel {
    protected JCheckBox dontShowMessageAgain;
    protected JTextArea messageTextArea = new JTextArea();
    private static String KOP_README_NAME = "Readme LadderDiagram.txt";

    public ReadmePanel() {
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.dontShowMessageAgain = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.add((Component)this.dontShowMessageAgain, "South");
        this.add((Component)new JScrollPane(this.messageTextArea), "Center");
    }

    public String getTitle() {
        return Language.getString("dialog.readme.ladderDiagramReadme.title", "Readme ladder diagram");
    }

    public void loadFieldContents() {
        try {
            File readme = new File(this.getClass().getResource("/" + KOP_README_NAME).getFile());
            BufferedReader reader = new BufferedReader(new FileReader(readme));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.messageTextArea.append(line + "\n");
            }
        }
        catch (Exception e) {
            this.messageTextArea.setText(e.toString());
        }
    }

    public void setLabels() {
        super.setLabels();
        this.dontShowMessageAgain.setText(Language.getString("dialog.readme.dontShowMessageAgain", "Do not show this message again."));
    }

    public void storeFieldContents() {
        if (this.dontShowMessageAgain.isSelected()) {
            LogoProperties.instance().setProperty("dialog.dontShowLadderDiagramReadme", Boolean.TRUE.toString());
        }
    }
}

