/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.GroupTrendModel;
import DE.siemens.ad.logo.dialog.TrendModel;
import DE.siemens.ad.logo.dialog.TrendPanelModel;
import DE.siemens.ad.logo.dialog.TrendViewPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockOnlineObserveEvent;
import DE.siemens.ad.logo.model.BlockOnlineObserveListener;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PIControllerWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane ivjJTabbedPane = null;
    protected boolean currentVisibility = false;
    private Editor fEditor;
    private boolean fIsOnlineTest = false;
    private ArrayList fHidenWindows = null;
    private PIControllerWindow fPVDialog;
    private Timer getValueTimer;
    private HashMap trendViewAndBlock = new HashMap();

    protected PIControllerWindow(JFrame parent) {
        super(parent);
        this.initialize();
    }

    protected PIControllerWindow(JDialog parent) {
        super(parent);
        this.initialize();
    }

    public static PIControllerWindow createPIControllerWindow(Editor editor) {
        PIControllerWindow piControllerWindow = null;
        Window parentWindow = editor.getApplicationSurface().getWindow();
        if (parentWindow instanceof JDialog) {
            piControllerWindow = new PIControllerWindow((JDialog)parentWindow);
        } else if (parentWindow instanceof JFrame) {
            piControllerWindow = new PIControllerWindow((JFrame)parentWindow);
        } else {
            throw new IllegalArgumentException("Parent of a PIControllerWindow must be a JDialog or JFrame.");
        }
        piControllerWindow.setEditor(editor);
        piControllerWindow.setTitle(Language.getString("block.PIController.title", "PI Trend View"));
        return piControllerWindow;
    }

    public boolean isOnlineTest() {
        return this.fIsOnlineTest;
    }

    public void setOnlineTest(boolean isOnlineTest) {
        this.fIsOnlineTest = isOnlineTest;
    }

    protected void clearTabbedPane() {
        this.getJTabbedPane().removeAll();
    }

    protected void updateTabbedPane() {
        LogoTrendViewPanel viewPanel;
        int i;
        for (int i2 = 0; i2 < this.getHidenWindows().size(); ++i2) {
            LogoTrendViewPanel viewPanel2 = (LogoTrendViewPanel)this.getHidenWindows().get(i2);
            if (!this.isBlockInfoAvailable(viewPanel2)) continue;
            this.getJTabbedPane().add(this.getPIBlockNumberString((Block)this.trendViewAndBlock.get(viewPanel2)), viewPanel2);
            this.getHidenWindows().remove(i2);
            this.setVisible(true);
        }
        int tabCount = this.getJTabbedPane().getComponentCount();
        for (i = 0; i < tabCount; ++i) {
            viewPanel = (LogoTrendViewPanel)this.getJTabbedPane().getComponentAt(i);
            if (!this.isBlockInfoAvailable(viewPanel)) continue;
            viewPanel.getBaseTrendViewPanel().nextCycle();
        }
        for (i = 0; i < tabCount; ++i) {
            viewPanel = (LogoTrendViewPanel)this.getJTabbedPane().getComponentAt(i);
            if (this.isBlockInfoAvailable(viewPanel)) continue;
            this.getJTabbedPane().remove(viewPanel);
            viewPanel.getBaseTrendViewPanel().clearHistory();
            this.getHidenWindows().add(viewPanel);
            this.setVisible(this.getJTabbedPane().getTabCount() > 0);
            --i;
            --tabCount;
        }
        if (!this.isVisible()) {
            this.setVisible(tabCount > 0);
        }
    }

    public void endSimulation() {
        this.clearTabbedPane();
        this.cancelTimer();
    }

    protected void fillTabbedPane() {
        JTabbedPane tabPane = this.getJTabbedPane();
        tabPane.removeAll();
        WiringDiagram wiringDiagram = ((LogoDrawing)((LogoComfort)this.fEditor).drawing()).getWiringDiagram();
        if (this.fHidenWindows != null) {
            this.fHidenWindows.clear();
        } else {
            this.fHidenWindows = new ArrayList(16);
        }
        Enumeration blocks = wiringDiagram.getBlocks().elements();
        Block aBlock = null;
        int piBlocknumber = 0;
        while (blocks.hasMoreElements()) {
            aBlock = (Block)blocks.nextElement();
            if (!(aBlock instanceof PIDBlock)) continue;
            if (!this.isOnlineTest() || ((PIDBlock)aBlock).isOnlineTestObserved()) {
                tabPane.addTab(this.getPIBlockNumberString(aBlock), null, this.getTrendViewPanel(aBlock), aBlock.getNumberString());
                ++piBlocknumber;
                continue;
            }
            this.getHidenWindows().add(this.getTrendViewPanel(aBlock));
        }
        this.setSize(490, (int)(310.0 + (double)(piBlocknumber - 1) * 1.46));
        this.invalidate();
        this.add(tabPane);
    }

    private String getPIBlockNumberString(Block pi) {
        StringBuffer buffer = new StringBuffer(pi.getNumberPrefix());
        if (pi.getNumber() > 0) {
            String string = "00" + Integer.toString(pi.getNumber());
            if (pi.getHardware() != null) {
                int maxBlocks = pi.getHardware().getMaxResource(0);
                buffer.append(string.substring(string.length() - Integer.toString(maxBlocks).length()));
            } else {
                buffer.append(string.substring(2));
            }
        }
        return buffer.toString();
    }

    protected ArrayList getHidenWindows() {
        if (this.fHidenWindows == null) {
            this.fHidenWindows = new ArrayList(16);
        }
        return this.fHidenWindows;
    }

    private LogoTrendViewPanel getTrendViewPanel(Block aBlock) {
        TrendPanelModel panelModel = new TrendPanelModel(10, 10, 6);
        TrendModel pvTrend = new TrendModel(panelModel, new PISampler(aBlock, "PV", this.fIsOnlineTest), "PV", Color.blue);
        TrendModel spTrend = new TrendModel(panelModel, new PISampler(aBlock, "SP", this.fIsOnlineTest), "SP", Color.green);
        TrendModel aqTrend = new TrendModel(panelModel, new PISampler(aBlock, "AQ", this.fIsOnlineTest), "AQ", Color.red);
        GroupTrendModel pvSpTrend = new GroupTrendModel(panelModel);
        pvSpTrend.addTrendModel(pvTrend);
        pvSpTrend.addTrendModel(spTrend);
        TrendViewPanel panel = new TrendViewPanel(panelModel);
        panel.setTrendModelAt("left_side", aqTrend);
        panel.setTrendModelAt("right_side", pvSpTrend);
        LogoTrendViewPanel viewPanel = new LogoTrendViewPanel((PIDBlock)aBlock, panel);
        this.trendViewAndBlock.put(viewPanel, aBlock);
        return viewPanel;
    }

    protected JTabbedPane getJTabbedPane() {
        if (this.ivjJTabbedPane == null) {
            this.ivjJTabbedPane = new JTabbedPane();
            this.ivjJTabbedPane.setName("JTabbedPane");
        }
        return this.ivjJTabbedPane;
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 150, 485, 340);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PIControllerWindow.this.cancelTimer();
                PIControllerWindow.this.clearTabbedPane();
                if (PIControllerWindow.this.fPVDialog != null) {
                    PIControllerWindow.this.fPVDialog.clearTabbedPane();
                    PIControllerWindow.this.fPVDialog.dispose();
                    PIControllerWindow.this.fPVDialog = null;
                }
            }
        });
        this.setModal(false);
        this.setResizable(false);
    }

    public void setEditorActivated(boolean editorActivated) {
        super.setVisible(editorActivated && this.currentVisibility);
    }

    public void setVisible(boolean visibility) {
        boolean actVisible = visibility;
        if (this.getJTabbedPane().getTabCount() <= 0) {
            actVisible = false;
        }
        super.setVisible(actVisible && this.fEditor.isActivated());
        this.currentVisibility = actVisible;
    }

    public void dispose() {
        this.currentVisibility = false;
        super.dispose();
    }

    public void startSimulation() {
        this.fillTabbedPane();
        if (this.getJTabbedPane().getComponentCount() + this.getHidenWindows().size() > 0) {
            this.initTimer();
        }
    }

    protected Editor getEditor() {
        return this.fEditor;
    }

    protected void setEditor(Editor editor) {
        this.fEditor = editor;
    }

    private void initTimer() {
        if (this.getValueTimer != null) {
            this.getValueTimer.cancel();
        }
        this.getValueTimer = new Timer();
        this.getValueTimer.schedule(new TimerTask(){

            public void run() {
                try {
                    PIControllerWindow.this.updateTabbedPane();
                    if (PIControllerWindow.this.fPVDialog != null) {
                        PIControllerWindow.this.fPVDialog.updateTabbedPane();
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Trendview panel error");
                }
            }
        }, 500L, 1000L);
    }

    private void cancelTimer() {
        if (this.getValueTimer != null) {
            this.getValueTimer.cancel();
            this.getValueTimer = null;
        }
    }

    private boolean isBlockInfoAvailable(LogoTrendViewPanel panel) {
        return !this.fIsOnlineTest || ((PIDBlock)this.trendViewAndBlock.get(panel)).isOnlineTestObserved();
    }

    private class LogoTrendViewPanel
    extends JPanel {
        private JButton jbSetRate = null;
        private JCheckBox jcbPV = new JCheckBox("PV");
        private JCheckBox jcbSP = new JCheckBox("SP");
        private JCheckBox jcbAQ = new JCheckBox("AQ");
        private EditableNumericSpinner rateSpinner = null;
        private TrendViewPanel viewPanel;
        private PIDBlock block;

        public LogoTrendViewPanel(PIDBlock block, TrendViewPanel viewPanel) {
            this.block = block;
            this.viewPanel = viewPanel;
            this.setLayout(new BoxLayout(this, 1));
            this.add(viewPanel);
            this.add(this.getTimeBasePanel());
            this.jcbPV.setSelected(true);
            this.jcbSP.setSelected(true);
            this.jcbAQ.setSelected(true);
            LegendButtonListener listener = new LegendButtonListener();
            this.jcbPV.addActionListener(listener);
            this.jcbSP.addActionListener(listener);
            this.jcbAQ.addActionListener(listener);
            if (PIControllerWindow.this.fIsOnlineTest) {
                View view;
                this.jcbSP.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PIDBlock piBlock;
                        if (e.getSource() == LogoTrendViewPanel.this.jcbSP && LogoTrendViewPanel.this.jcbSP.isSelected() && !(piBlock = LogoTrendViewPanel.this.block).isSPAvailable(PIControllerWindow.this.fIsOnlineTest)) {
                            try {
                                LogoDrawingView view = LogoTrendViewPanel.this.getLogoDrawingView();
                                if (view != null && view.getModel() instanceof LogoDrawing) {
                                    Block block = LogoTrendViewPanel.this.getSPReferencedBlock();
                                    BlockFigure blockFigure = ((LogoDrawing)view.getModel()).getBlockFigure(block);
                                    ((OnlineTestTool)view.tool()).addWatchedBlockFigure(blockFigure);
                                    LogoTrendViewPanel.this.jcbSP.setSelected(piBlock.isSPAvailable(PIControllerWindow.this.fIsOnlineTest));
                                }
                            }
                            catch (Exception ex) {
                                LogoTrendViewPanel.this.jcbSP.setSelected(false);
                            }
                        }
                    }
                });
                if (((PIDParameter)block.getParameter()).getSetpoint().isReference() && (view = Application.getInstance().getMdiManager().getActiveTopLevelView()) instanceof LogoDrawingView) {
                    ((OnlineTestTool)((LogoDrawingView)view).tool()).addOnlineObserveStateListener(new PIDRefOnlineObserveListener());
                }
                if (!block.isSPAvailable(PIControllerWindow.this.fIsOnlineTest)) {
                    viewPanel.setVisible("SP", false);
                    this.jcbSP.setSelected(false);
                }
            }
        }

        private LogoDrawingView getLogoDrawingView() {
            View view = Application.getInstance().getMdiManager().getActiveTopLevelView();
            if (view instanceof LogoDrawingView) {
                return (LogoDrawingView)view;
            }
            return null;
        }

        private Block getSPReferencedBlock() {
            if (((PIDParameter)this.block.getParameter()).getSetpoint().isReference()) {
                return ((PIDParameter)this.block.getParameter()).getSetpoint().getReferenceToBlock();
            }
            return null;
        }

        private JPanel getTimeBasePanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            panel.setBorder(BorderFactory.createEmptyBorder(0, 25, 0, 25));
            BorderJPanel timeBasePanel = new BorderJPanel();
            timeBasePanel.setTitle(Language.getString("dialog.PITrendView.samplePeriod", "Sample Period(Second)"));
            timeBasePanel.setLayout(new BoxLayout(timeBasePanel, 0));
            this.rateSpinner = new EditableNumericSpinner();
            this.rateSpinner.setMin(1);
            this.rateSpinner.setMax(300);
            this.rateSpinner.setError(this.rateSpinner.createDefaultError());
            timeBasePanel.add(this.rateSpinner);
            timeBasePanel.add(Box.createHorizontalStrut(10));
            this.jbSetRate = new JButton(Language.getString("dialog.PITrendView.setPeriod", "Set Period"));
            this.jbSetRate.setMnemonic('S');
            this.jbSetRate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!LogoTrendViewPanel.this.rateSpinner.checkValue(true)) {
                        return;
                    }
                    LogoTrendViewPanel.this.rateSpinner.checkChanged();
                    int newSampleProd = LogoTrendViewPanel.this.rateSpinner.getValue();
                    if (LogoTrendViewPanel.this.viewPanel.getSampleProd() != newSampleProd) {
                        LogoTrendViewPanel.this.viewPanel.setSampleProd(newSampleProd);
                    }
                }
            });
            timeBasePanel.add(this.jbSetRate);
            panel.add(timeBasePanel);
            panel.add(Box.createHorizontalStrut(50));
            BorderJPanel legendPanel = new BorderJPanel();
            panel.add(legendPanel);
            legendPanel.setTitle(Language.getString("dialog.PITrendView.legend", "Legend"));
            legendPanel.setLayout(new BoxLayout(legendPanel, 0));
            legendPanel.add(this.jcbPV);
            legendPanel.add(Box.createHorizontalStrut(20));
            legendPanel.add(this.jcbSP);
            legendPanel.add(Box.createHorizontalStrut(20));
            legendPanel.add(this.jcbAQ);
            return panel;
        }

        public TrendViewPanel getBaseTrendViewPanel() {
            return this.viewPanel;
        }

        private class PIDRefOnlineObserveListener
        implements BlockOnlineObserveListener {
            private final String spTrend = "SP";

            private PIDRefOnlineObserveListener() {
            }

            public void blockObserveStateUpdate(BlockOnlineObserveEvent evt) {
                if (((PIDParameter)LogoTrendViewPanel.this.block.getParameter()).getSetpoint().isReference() && evt.getBlock() == ((PIDParameter)LogoTrendViewPanel.this.block.getParameter()).getSetpoint().getReferenceToBlock() && !evt.isBlockObserved()) {
                    LogoTrendViewPanel.this.viewPanel.setVisible("SP", false);
                    LogoTrendViewPanel.this.jcbSP.setSelected(false);
                }
            }
        }

        private class LegendButtonListener
        implements ActionListener {
            private LegendButtonListener() {
            }

            public void actionPerformed(ActionEvent e) {
                JCheckBox src = (JCheckBox)e.getSource();
                String legendName = e.getActionCommand();
                if (src.isSelected()) {
                    LogoTrendViewPanel.this.viewPanel.setVisible(legendName, true);
                } else {
                    LogoTrendViewPanel.this.viewPanel.setVisible(legendName, false);
                }
            }
        }
    }

    private class PISampler
    implements TrendModel.SampleStrategy {
        private String trendName;
        private PIDBlock block;
        private boolean isOnlineTest;

        public PISampler(Block block, String trendName, boolean isOnlineTest) {
            this.block = (PIDBlock)block;
            this.trendName = trendName;
            this.isOnlineTest = isOnlineTest;
        }

        public double getOneSample() {
            double v = 0.0;
            if (this.trendName.equalsIgnoreCase("AQ")) {
                v = this.block.getTrendviewAQ(this.isOnlineTest);
            } else if (this.trendName.equalsIgnoreCase("PV")) {
                v = this.block.getTrendviewPV(this.isOnlineTest);
            } else if (this.trendName.equalsIgnoreCase("SP")) {
                v = this.block.getTrendviewSP(this.isOnlineTest);
            }
            return v;
        }
    }
}

