/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.InputNamesIfc;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class InputNamesPanel
extends DataInputPanel {
    protected InputNamesIfc inputNamesIfc;
    protected JLabel lblInputsHeader;
    public JLabel lblOutputsHeader;
    protected Vector inputLabels;
    protected Vector inputTextFields;
    protected Vector outputLabels;
    protected Vector outputTextFields;
    protected String[] inputNames;
    protected String[] outputNames;

    public InputNamesPanel(InputNamesIfc inputNamesIfc) {
        this.inputNamesIfc = inputNamesIfc;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.lblInputsHeader = new JLabel("Inputs");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.lblInputsHeader, gbc);
        JPanel pInputNames = new JPanel(new GridBagLayout());
        JScrollPane spInputNames = new JScrollPane(pInputNames);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)spInputNames, gbc);
        this.inputNames = inputNamesIfc.getInputNames();
        this.inputLabels = new Vector(this.inputNames.length);
        this.inputTextFields = new Vector(this.inputNames.length);
        int i = 0;
        while (i < this.inputNames.length) {
            JLabel label = new JLabel(this.inputNames[i]);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = i;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(2, 5, 2, 5);
            this.inputLabels.add(label);
            pInputNames.add((Component)label, gbc);
            JTextField textField = new JTextField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = i++;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 3);
            this.inputTextFields.addElement(textField);
            pInputNames.add((Component)textField, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        pInputNames.add((Component)new JPanel(), gbc);
        this.lblOutputsHeader = new JLabel("Outputs");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        this.add((Component)this.lblOutputsHeader, gbc);
        JPanel pOutputNames = new JPanel(new GridBagLayout());
        JScrollPane spOutputNames = new JScrollPane(pOutputNames);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)spOutputNames, gbc);
        this.outputNames = inputNamesIfc.getOutputNames();
        this.outputLabels = new Vector(this.outputNames.length);
        this.outputTextFields = new Vector(this.outputNames.length);
        int i2 = 0;
        while (i2 < this.outputNames.length) {
            JLabel label = new JLabel(this.outputNames[i2]);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = i2;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(2, 5, 2, 5);
            this.outputLabels.add(label);
            pOutputNames.add((Component)label, gbc);
            JTextField textField = new JTextField();
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = i2++;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 3);
            this.outputTextFields.add(textField);
            pOutputNames.add((Component)textField, gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 100;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        pOutputNames.add((Component)new JPanel(), gbc);
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.width = Math.max(400, preferredSize.width);
        preferredSize.height -= 80;
        return preferredSize;
    }

    public String getTitle() {
        return Language.getString("dialog.comments.title", "Comments");
    }

    public void loadFieldContents() {
        String content;
        int i;
        for (i = 0; i < this.inputNames.length; ++i) {
            content = this.inputNamesIfc.getInputName(this.inputNames[i]);
            ((JTextField)this.inputTextFields.elementAt(i)).setText(content);
        }
        for (i = 0; i < this.outputNames.length; ++i) {
            content = this.inputNamesIfc.getInputName(this.outputNames[i]);
            ((JTextField)this.outputTextFields.elementAt(i)).setText(content);
        }
    }

    public void setLabels() {
        this.lblInputsHeader.setText(Language.getString("dialog.comments.inputCommentsPanel.label", "Inputs"));
        this.lblOutputsHeader.setText(Language.getString("dialog.comments.outputCommentsPanel.label", "Outputs"));
    }

    public void storeFieldContents() {
        String content;
        int i;
        for (i = 0; i < this.inputNames.length; ++i) {
            content = ((JTextField)this.inputTextFields.elementAt(i)).getText();
            this.inputNamesIfc.setInputName(this.inputNames[i], content);
        }
        for (i = 0; i < this.outputNames.length; ++i) {
            content = ((JTextField)this.outputTextFields.elementAt(i)).getText();
            this.inputNamesIfc.setInputName(this.outputNames[i], content);
        }
        LogoDrawing drawing = this.inputNamesIfc.getDrawing();
        drawing.updateInputNames();
        drawing.forceUpdate();
        drawing.setModified(true);
    }

    public boolean checkChanged() {
        String modelContent;
        String guiContent;
        int i;
        for (i = 0; i < this.inputNames.length; ++i) {
            guiContent = ((JTextField)this.inputTextFields.elementAt(i)).getText();
            if (guiContent.equals(modelContent = this.inputNamesIfc.getInputName(this.inputNames[i]))) continue;
            return true;
        }
        for (i = 0; i < this.outputNames.length; ++i) {
            guiContent = ((JTextField)this.outputTextFields.elementAt(i)).getText();
            if (guiContent.equals(modelContent = this.inputNamesIfc.getInputName(this.outputNames[i]))) continue;
            return true;
        }
        return false;
    }
}

