/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.LogoHardwareFactory;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.hardware.Unknown;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HardwarePanel
extends DataInputPanel {
    private BorderJPanel ivjHardwareTreePanel = null;
    private JScrollPane ivjJScrollPane1 = null;
    private BorderJPanel ivjResourcePanel = null;
    private JScrollPane ivjJScrollPane2 = null;
    private JTextArea ivjResourceText = null;
    private boolean fShowAllHardware = true;
    private JTree ivjHardwareTree = null;
    protected WiringDiagram fWiringDiagram;
    private Hashtable fHardwareNodeDict = new Hashtable();
    private List fSuitableHardware;
    private ArrayList fErrorList;
    private JTextField fErrorTextField;
    JPanel fErrorPanel;

    public HardwarePanel() {
        this.initialize();
    }

    public HardwarePanel(WiringDiagram wd) {
        this.fWiringDiagram = wd;
        this.initialize();
    }

    public boolean checkChanged() {
        DefaultMutableTreeNode selectedNode;
        boolean result = false;
        TreePath selectionPath = this.getHardwareTree().getSelectionPath();
        if (selectionPath != null && (selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof Hardware) {
            result = this.fWiringDiagram.getHardware() != (Hardware)selectedNode.getUserObject();
        }
        return result;
    }

    public boolean checkFieldContents() {
        DefaultMutableTreeNode lastNode;
        TreePath selectedPath = this.getHardwareTree().getSelectionPath();
        if (selectedPath != null && (lastNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent()).getUserObject() instanceof Hardware && !this.fSuitableHardware.contains(lastNode.getUserObject())) {
            JOptionPane.showMessageDialog(this, "Der aktuelle Schaltplan pa\u00dft nicht in die ausgew\u00e4hlte Hardware!", this.getTitle(), 1);
            return false;
        }
        return true;
    }

    private JTree getHardwareTree() {
        if (this.ivjHardwareTree == null) {
            try {
                this.ivjHardwareTree = new JTree();
                this.ivjHardwareTree.setName("HardwareTree");
                this.ivjHardwareTree.setBounds(0, 0, 78, 72);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHardwareTree;
    }

    private BorderJPanel getHardwareTreePanel() {
        if (this.ivjHardwareTreePanel == null) {
            try {
                this.ivjHardwareTreePanel = new BorderJPanel();
                this.ivjHardwareTreePanel.setName("HardwareTreePanel");
                this.ivjHardwareTreePanel.setLayout(new BorderLayout());
                this.ivjHardwareTreePanel.setTitle("Hardware");
                this.getHardwareTreePanel().add((Component)this.getJScrollPane1(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjHardwareTreePanel;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.getJScrollPane1().setViewportView(this.getHardwareTree());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.ivjJScrollPane2 == null) {
            try {
                this.ivjJScrollPane2 = new JScrollPane();
                this.ivjJScrollPane2.setName("JScrollPane2");
                this.getJScrollPane2().setViewportView(this.getResourceText());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane2;
    }

    public DefaultMutableTreeNode getNodeForHardwareString(String hardwareString) {
        if (!this.fHardwareNodeDict.containsKey(hardwareString)) {
            this.fHardwareNodeDict.put(hardwareString, new DefaultMutableTreeNode(hardwareString));
        }
        return (DefaultMutableTreeNode)this.fHardwareNodeDict.get(hardwareString);
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 530);
    }

    private BorderJPanel getResourcePanel() {
        if (this.ivjResourcePanel == null) {
            try {
                this.ivjResourcePanel = new BorderJPanel();
                this.ivjResourcePanel.setName("ResourcePanel");
                this.ivjResourcePanel.setLayout(new BorderLayout());
                this.ivjResourcePanel.setTitle("Resourcen");
                this.getResourcePanel().add((Component)this.getJScrollPane2(), "Center");
                this.fErrorPanel = new JPanel(new BorderLayout());
                this.ivjResourcePanel.add((Component)this.fErrorPanel, "North");
                JPanel panel = new JPanel();
                JLabel label = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
                panel.add(label);
                this.fErrorPanel.add((Component)panel, "West");
                this.fErrorTextField = new JTextField();
                this.fErrorTextField.setEditable(false);
                this.fErrorTextField.setForeground(Color.RED);
                this.fErrorTextField.setBackground(new JToolTip().getBackground());
                this.fErrorTextField.setHorizontalAlignment(0);
                JScrollPane sPane = new JScrollPane(this.fErrorTextField);
                this.fErrorPanel.add((Component)sPane, "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResourcePanel;
    }

    private JTextArea getResourceText() {
        if (this.ivjResourceText == null) {
            try {
                this.ivjResourceText = new JTextArea();
                this.ivjResourceText.setName("ResourceText");
                this.ivjResourceText.setFont(new Font("dialoginput", 0, 12));
                this.ivjResourceText.setBackground(SystemColor.inactiveCaptionText);
                this.ivjResourceText.setBounds(0, 0, 160, 120);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResourceText;
    }

    public String getTitle() {
        return Language.getStringNoTilde("extra.selectLogo", "Select Hardware");
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("HardwarePanel");
            this.setLayout(new GridBagLayout());
            this.setSize(550, 480);
            GridBagConstraints constraintsHardwareTreePanel = new GridBagConstraints();
            constraintsHardwareTreePanel.gridx = 0;
            constraintsHardwareTreePanel.gridy = 0;
            constraintsHardwareTreePanel.fill = 1;
            constraintsHardwareTreePanel.weightx = 1.0;
            constraintsHardwareTreePanel.weighty = 1.0;
            constraintsHardwareTreePanel.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getHardwareTreePanel(), constraintsHardwareTreePanel);
            GridBagConstraints constraintsResourcePanel = new GridBagConstraints();
            constraintsResourcePanel.gridx = 1;
            constraintsResourcePanel.gridy = 0;
            constraintsResourcePanel.fill = 1;
            constraintsResourcePanel.weightx = 2.0;
            constraintsResourcePanel.weighty = 1.0;
            constraintsResourcePanel.insets = new Insets(4, 4, 4, 4);
            this.add((Component)this.getResourcePanel(), constraintsResourcePanel);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getResourceText().setBackground(UIManager.getColor("Panel.background"));
    }

    public void loadFieldContents() {
        this.setLabels();
        this.loadTree();
        Hardware currentHardware = this.fWiringDiagram.getHardware();
        DefaultMutableTreeNode currentHardwareNode = (DefaultMutableTreeNode)this.fHardwareNodeDict.get(currentHardware.getName());
        if (currentHardwareNode != null) {
            TreePath pathToCurrentHardware = new TreePath(currentHardwareNode.getPath());
            this.getHardwareTree().expandPath(pathToCurrentHardware);
            this.getHardwareTree().setSelectionPath(pathToCurrentHardware);
        }
        this.expandTree();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.ivjHardwareTree != null) {
            Rectangle rect1 = new Rectangle(0, this.ivjHardwareTree.getSize().height - 1, 1, 1);
            this.ivjHardwareTree.scrollRectToVisible(rect1);
        }
    }

    private void loadTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Language.getString("hardware.family.name", ""));
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.getHardwareTree().setModel(treeModel);
        this.getHardwareTree().setCellRenderer(new HardwareTreeCellRenderer());
        this.getHardwareTree().setRowHeight(0);
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.getHardwareTree().setSelectionModel(treeSelectionModel);
        this.getHardwareTree().addTreeSelectionListener(new HardwareSelectionHandler());
        this.fErrorList = new ArrayList();
        Hardware[] suitableHardware = this.fWiringDiagram.getSuitableHardware(this.fErrorList);
        if (this.fErrorList.size() > 0) {
            Log.printStartSequence("msg.selectLogo", "Select device");
            Log.println("msg.devicesNotSuitable", "Devices not suitable:");
            for (ErrorInfo entry : this.fErrorList) {
                ArrayList list = entry.getAdditionalInfo();
                StringBuffer leading = new StringBuffer(40);
                if (list.size() > 0) {
                    if (list.get(0) instanceof Hardware) {
                        leading.append(((Hardware)list.get(0)).getLocalizedName(true));
                    } else {
                        System.err.println("wiringDiagram.isBlockAvailable(Block,Hardware): Unknown additional Parameter");
                    }
                }
                leading.append("                       ");
                Log.println(leading.substring(0, 20) + ":\t" + entry.getSource().getLocalizedName(true) + " " + entry.getMessage());
            }
        }
        Hardware[] availableHardware = null;
        availableHardware = this.fShowAllHardware ? LogoHardwareFactory.getInstance().getAvailableHardware() : suitableHardware;
        if (suitableHardware == null) {
            suitableHardware = new Hardware[]{};
        }
        this.fSuitableHardware = Arrays.asList(suitableHardware);
        if (availableHardware != null) {
            availableHardware = LogoHardwareFactory.getInstance().sort(availableHardware);
            int max = availableHardware.length;
            if (availableHardware[availableHardware.length - 1].getClass() == Unknown.class) {
                max = availableHardware.length - 1;
            }
            for (int i = 0; i < max; ++i) {
                String[] path = Util.asStringArray(availableHardware[i].getLocalizedPath(), ".");
                DefaultMutableTreeNode prevNode = root;
                for (int j = 0; j < path.length; ++j) {
                    DefaultMutableTreeNode node = this.getNodeForHardwareString(path[j]);
                    prevNode.add(node);
                    prevNode = node;
                }
                DefaultMutableTreeNode hardwareNode = new DefaultMutableTreeNode(availableHardware[i]);
                this.fHardwareNodeDict.put(availableHardware[i].getName(), hardwareNode);
                prevNode.add(hardwareNode);
            }
        }
        this.getHardwareTree().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                JDialog dialog;
                if (HardwarePanel.this.getHardwareTree().getSelectionPath() != null && !((TreeNode)HardwarePanel.this.getHardwareTree().getSelectionPath().getLastPathComponent()).isLeaf()) {
                    return;
                }
                if (me.getClickCount() == 2 && (dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, HardwarePanel.this.getHardwareTree())) != null) {
                    dialog.getRootPane().getDefaultButton().doClick();
                }
            }
        });
    }

    public void setLabels() {
        this.getHardwareTreePanel().setTitle(Language.getString("dialog.selectLogo.hardwareBorder", "Choose hardware:"));
        this.getResourcePanel().setTitle(Language.getString("global.Resourcen", "Resources"));
    }

    public void storeFieldContents() {
        DefaultMutableTreeNode selectedNode;
        TreePath selectionPath = this.getHardwareTree().getSelectionPath();
        if (selectionPath != null && (selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject() instanceof Hardware) {
            ArrayList list;
            Hardware hw = (Hardware)selectedNode.getUserObject();
            WiringDiagram wd = new WiringDiagram(hw);
            HashMap dict = new HashMap();
            wd.insert(this.fWiringDiagram.getCopyOfBlocks(), dict);
            if (dict.get("err") != null) {
                String error = (String)dict.get("err");
                System.out.println("ERROR in HardwarePanel.storeFieldContents():" + error);
            }
            if ((list = (ArrayList)dict.get("propChanged")) != null) {
                System.out.println("ERROR in HardwarePanel.storeFieldContents(): PROPERTY_CHANGED");
                System.out.println(list);
            }
            this.fWiringDiagram.setHardware(hw);
            LogoProperties.instance().setProperty("hardware", ((Hardware)selectedNode.getUserObject()).getName());
        }
    }

    public String getHardwareInfoString(Hardware hardware) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Language.getString("dialog.hardware.knownBlocks", "Known blocks:"));
        buffer.append("\n");
        Vector[] allBlocks = hardware.getAvailableBlocks();
        for (int i = 0; i < allBlocks.length; ++i) {
            Enumeration enumeration = allBlocks[i].elements();
            buffer.append(((Block)enumeration.nextElement()).getLocalizedName(false)).append(":\t");
            while (enumeration.hasMoreElements()) {
                buffer.append(((Block)enumeration.nextElement()).getLocalizedName(false)).append(",");
            }
            buffer.setLength(buffer.length() - 1);
            buffer.append("\n");
        }
        buffer.append("\n");
        buffer.append(Language.getString("dialog.hardware.maxResources", "Max. Resources:"));
        buffer.append("\n");
        int[] iArr = (int[])hardware.getProperty("maxValues");
        String[] resNames = HardwareFactory.getInstance().getResourceNames();
        for (int idx = 0; idx < iArr.length; ++idx) {
            if (iArr[idx] == 0 || iArr[idx] == Integer.MAX_VALUE) continue;
            String resName = resNames[idx];
            buffer.append(this.getResourceLine(resName, iArr[idx]));
            if (idx != 12 || !hardware.supports("supportAsiaLanguage")) continue;
            buffer.append(this.getResourceLine("CharacterContents", 50));
        }
        if (hardware.supports("supportAsiaLanguage")) {
            buffer.append("\n");
            buffer.append(Language.getString("dialog.parameter.message.charSetText", "Character set")).append(":");
            buffer.append("\n");
            MessageGlobalInfo msgInfo = new MessageGlobalInfo();
            msgInfo.setSupportJapaneseSJIS(hardware.supports("SupportJapaneseLanguage"));
            for (int i = 0; i < msgInfo.getCharSetListAvailable().length; ++i) {
                buffer.append(msgInfo.getCharSetListAvailable()[i]).append(",");
            }
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    private StringBuffer getResourceLine(String resName, int max) {
        StringBuffer buf = new StringBuffer();
        buf.append(Language.getString("hardware." + resName, resName));
        buf.append("                                           ").setLength(30);
        buf.append(max).append("\n");
        return buf;
    }

    protected void expandTree() {
        JTree tree = this.getHardwareTree();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> nodes = root.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            TreePath pathToNode = new TreePath(node.getPath());
            tree.expandPath(pathToNode);
        }
    }

    public boolean isShowAllHardware() {
        return this.fShowAllHardware;
    }

    public void setShowAllHardware(boolean showAllHardware) {
        this.fShowAllHardware = showAllHardware;
    }

    private class HardwareTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Dimension getPreferredSize() {
            Dimension x = super.getMinimumSize();
            x.height = (int)(x.getHeight() + 2.0);
            return x;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof Hardware) {
                this.setText(((Hardware)userObject).getLocalizedName());
                try {
                    this.setIcon(((Hardware)userObject).getIcon());
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.setEnabled(HardwarePanel.this.fSuitableHardware.contains(userObject));
            }
            return this;
        }
    }

    public class HardwareSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent tse) {
            if (tse.getNewLeadSelectionPath() != null) {
                HardwarePanel.this.fErrorPanel.setVisible(false);
                DefaultMutableTreeNode lastNode = (DefaultMutableTreeNode)tse.getNewLeadSelectionPath().getLastPathComponent();
                if (lastNode.getUserObject() instanceof Hardware) {
                    Hardware hardware = (Hardware)lastNode.getUserObject();
                    HardwarePanel.this.getResourceText().setText(HardwarePanel.this.getHardwareInfoString(hardware));
                    if (HardwarePanel.this.fSuitableHardware.contains(hardware)) {
                        HardwarePanel.this.getOkButton().setEnabled(true);
                    } else {
                        HardwarePanel.this.getOkButton().setEnabled(false);
                        for (int i = 0; i < HardwarePanel.this.fErrorList.size(); ++i) {
                            ErrorInfo error = (ErrorInfo)HardwarePanel.this.fErrorList.get(i);
                            ArrayList list = error.getAdditionalInfo();
                            if (list.get(0).getClass() != hardware.getClass()) continue;
                            StringBuffer buffer = new StringBuffer(error.getSource().getLocalizedName(true));
                            buffer.append(": ").append(error.getMessage());
                            HardwarePanel.this.fErrorTextField.setText(buffer.toString());
                            HardwarePanel.this.fErrorPanel.setVisible(true);
                            break;
                        }
                    }
                } else {
                    HardwarePanel.this.getResourceText().setText("");
                }
                HardwarePanel.this.validate();
            }
        }
    }
}

