/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.model.OptionsIfc;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class DisplayOptionsPanel
extends DataInputPanel {
    private JCheckBox fAntialiasing;
    protected OptionsIfc fModel;
    private JCheckBox fComment;
    private JCheckBox fConnectorNames;
    private JCheckBox fParameter;
    private JCheckBox fDialogBounds;
    private JCheckBox fSaveWorkspace;
    private JCheckBox fMarkerLabels;

    public DisplayOptionsPanel() {
        this.initComponents();
    }

    public DisplayOptionsPanel(OptionsIfc options) {
        this.fModel = options;
        this.initComponents();
    }

    public boolean checkChanged() {
        LogoProperties logoProperties = LogoProperties.instance();
        boolean displayConnectorNames = logoProperties.getBooleanProperty("drawing.displayConnectorNames", true);
        boolean displayComments = logoProperties.getBooleanProperty("drawing.displayComments", true);
        boolean displayParameters = logoProperties.getBooleanProperty("drawing.displayParameters", true);
        boolean dialogBounds = logoProperties.getBooleanProperty("app.rememberDialogBounds", true);
        boolean antialiasing = logoProperties.getBooleanProperty("drawing.antialiasing", false);
        boolean markerLabels = logoProperties.getBooleanProperty("marker.showLabel", true);
        boolean saveWorkspace = logoProperties.getBooleanProperty("app.saveWorkspace", true);
        return this.fComment.isSelected() != displayComments || this.fConnectorNames.isSelected() != displayConnectorNames || this.fParameter.isSelected() != displayParameters || this.fDialogBounds.isSelected() != dialogBounds || this.fAntialiasing.isSelected() != antialiasing || this.fMarkerLabels.isSelected() != markerLabels || this.fSaveWorkspace.isSelected() != saveWorkspace;
    }

    public String getTitle() {
        return Language.getString("dialog.options.displayTab.label", "Display");
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.fComment = new JCheckBox("Comment");
        this.fConnectorNames = new JCheckBox("ConnectorNames");
        this.fParameter = new JCheckBox("Parameter");
        this.fDialogBounds = new JCheckBox("Dialog");
        this.fAntialiasing = new JCheckBox("Antialiasing");
        this.fMarkerLabels = new JCheckBox("MarkerLabels");
        this.fSaveWorkspace = new JCheckBox("SaveWorkspace");
        this.add(this.fComment);
        this.add(this.fConnectorNames);
        this.add(this.fParameter);
        this.add(Box.createVerticalStrut(10));
        this.add(this.fAntialiasing);
        this.add(this.fMarkerLabels);
        this.add(Box.createVerticalStrut(10));
        this.add(this.fDialogBounds);
        this.add(this.fSaveWorkspace);
    }

    public void loadFieldContents() {
        LogoProperties logoProperties = LogoProperties.instance();
        this.fConnectorNames.setSelected(logoProperties.getBooleanProperty("drawing.displayConnectorNames", true));
        this.fComment.setSelected(logoProperties.getBooleanProperty("drawing.displayComments", true));
        this.fParameter.setSelected(logoProperties.getBooleanProperty("drawing.displayParameters", true));
        this.fDialogBounds.setSelected(logoProperties.getBooleanProperty("app.rememberDialogBounds", true));
        this.fAntialiasing.setSelected(logoProperties.getBooleanProperty("drawing.antialiasing", false));
        this.fMarkerLabels.setSelected(logoProperties.getBooleanProperty("marker.showLabel", true));
        this.fSaveWorkspace.setSelected(logoProperties.getBooleanProperty("app.saveWorkspace", true));
    }

    public void setLabels() {
        this.fComment.setText(Language.getString("dialog.options.displayTab.displayPanel.comments", "Comments"));
        this.fConnectorNames.setText(Language.getString("dialog.options.displayTab.displayPanel.connectornames", "Connectornames"));
        this.fParameter.setText(Language.getString("dialog.options.displayTab.displayPanel.commentlines", "Commentlines"));
        this.fDialogBounds.setText(Language.getString("dialog.options.displayTab.dialogBounds", "Save size and position of dialogs"));
        this.fDialogBounds.setToolTipText(Language.getString("dialog.options.displayTab.dialogBounds.tooltip", ""));
        this.fAntialiasing.setText(Language.getString("dialog.options.displayTab.antialiasing", "Use antialiasing"));
        this.fAntialiasing.setToolTipText(Language.getString("dialog.options.displayTab.antialiasing.tooltip", "Antialiasing"));
        this.fMarkerLabels.setText(Language.getString("dialog.options.displayTab.markerLabels", "Display Marker with labels"));
        this.fMarkerLabels.setToolTipText(Language.getString("dialog.options.displayTab.markerLabels.tooltip", "Marker tool shows labels"));
        this.fSaveWorkspace.setText(Language.getString("dialog.options.displayTab.saveWorkspace", "Save workspace"));
        this.fSaveWorkspace.setToolTipText(Language.getString("dialog.options.displayTab.saveWorkspace.tooltip", "Open last opened files on startup"));
    }

    public void storeFieldContents() {
        LogoProperties logoProperties = LogoProperties.instance();
        logoProperties.setBooleanProperty("drawing.displayConnectorNames", this.fConnectorNames.isSelected());
        logoProperties.setBooleanProperty("drawing.displayComments", this.fComment.isSelected());
        logoProperties.setBooleanProperty("drawing.displayParameters", this.fParameter.isSelected());
        logoProperties.setBooleanProperty("drawing.antialiasing", this.fAntialiasing.isSelected());
        logoProperties.setBooleanProperty("marker.showLabel", this.fMarkerLabels.isSelected());
        logoProperties.setBooleanProperty("app.saveWorkspace", this.fSaveWorkspace.isSelected());
        boolean value = this.fDialogBounds.isSelected();
        logoProperties.setBooleanProperty("app.rememberDialogBounds", value);
        if (!value) {
            SplittedDlg.removeIniFile();
        }
    }

    public Icon getIcon() {
        return Global.getIcon("Display.gif");
    }
}

