/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.dialog;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.MDIManager;
import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class MDIManagerSelectionPanel
extends DataInputPanel {
    protected JComboBox fComboBox;
    protected Application fApplication;
    protected JPanel fPreviewPanel;
    protected BorderJPanel fPreviewBorderPanel;

    public MDIManagerSelectionPanel(Application application) {
        this.fApplication = application;
        this.initComponents();
    }

    public boolean checkChanged() {
        if (this.fComboBox.getSelectedItem() == null) {
            return false;
        }
        return !Application.getInstance().getMdiManager().getClass().getName().equals(this.fComboBox.getSelectedItem().getClass().getName());
    }

    public String getTitle() {
        return Language.getString("dialog.mdiManagerSelectionPanel.title", "MDI style");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.fComboBox = new JComboBox();
        this.add((Component)this.fComboBox, "North");
        this.fComboBox.setRenderer(new MDIManagerNameListCellRenderer());
        this.fPreviewBorderPanel = new BorderJPanel();
        this.fPreviewBorderPanel.setTitle("Preview");
        this.fPreviewBorderPanel.setLayout(new BorderLayout());
        this.fPreviewPanel = new JPanel(new BorderLayout());
        this.fPreviewPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.fPreviewPanel.setBackground(Color.gray);
        this.fPreviewBorderPanel.add(this.fPreviewPanel);
        this.add((Component)this.fPreviewBorderPanel, "Center");
        this.fComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                MDIManagerSelectionPanel.this.showPreview();
            }
        });
    }

    public void loadFieldContents() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        Object currentManager = null;
        for (String managerClassName : this.fApplication.getAvailableMDIManagers()) {
            try {
                Object manager = Class.forName(managerClassName).newInstance();
                if (manager.getClass().equals(this.fApplication.getMdiManager().getClass())) {
                    currentManager = manager;
                }
                model.addElement(manager);
            }
            catch (Exception e) {
                System.out.println("Could not create MDIManager: " + managerClassName + "; " + e);
            }
        }
        this.fComboBox.setModel(model);
        this.fComboBox.setSelectedItem(currentManager);
        this.showPreview();
    }

    public void setLabels() {
        this.fPreviewBorderPanel.setTitle(Language.getString("dialog.mdiManagerSelectionPanel.preview", "Preview"));
    }

    private void showPreview() {
        MDIManager mdiManager = (MDIManager)this.fComboBox.getSelectedItem();
        this.fPreviewPanel.removeAll();
        JComponent previewPanel = mdiManager.getPreviewPanel();
        if (previewPanel == null) {
            previewPanel = new JLabel("No preview available");
        }
        this.fPreviewPanel.add(mdiManager.getPreviewPanel());
        this.fPreviewPanel.revalidate();
        this.fPreviewPanel.repaint();
    }

    public void storeFieldContents() {
        MDIManager selectedMDIManager = (MDIManager)this.fComboBox.getSelectedItem();
        this.fApplication.setMdiManager(selectedMDIManager);
    }

    private class MDIManagerNameListCellRenderer
    extends DefaultListCellRenderer {
        private MDIManagerNameListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof MDIManager) {
                this.setText(((MDIManager)value).getName());
            }
            return this;
        }
    }
}

