/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class TypeAheadSelector
extends KeyAdapter
implements PropertyChangeListener {
    private JFileChooser chooser;
    private StringBuffer partialName = new StringBuffer();
    private Vector files;
    private boolean resetPartialName = true;

    public TypeAheadSelector(JFileChooser chooser) {
        this.chooser = chooser;
        Component comp = this.findJList(chooser);
        if (comp != null) {
            comp.addKeyListener(this);
            this.setListDataListener();
            chooser.addPropertyChangeListener(this);
        }
    }

    private Component findJList(Component comp) {
        if (comp.getClass() == JList.class) {
            return comp;
        }
        if (comp instanceof Container) {
            Component[] components = ((Container)comp).getComponents();
            for (int i = 0; i < components.length; ++i) {
                Component child = this.findJList(components[i]);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.getKeyChar() == '\n' && this.chooser.getSelectedFile().isFile()) {
            this.chooser.approveSelection();
        }
        if (ke.getKeyChar() == '\b') {
            if (this.partialName.length() > 0) {
                this.partialName.deleteCharAt(this.partialName.length() - 1);
            }
        } else {
            this.partialName.append(ke.getKeyChar());
        }
        String upperCasePartialName = this.partialName.toString().toUpperCase();
        for (int i = 0; i < this.files.size(); ++i) {
            File item = (File)this.files.get(i);
            String name = item.getName().toUpperCase();
            if (!name.startsWith(upperCasePartialName)) continue;
            this.resetPartialName = false;
            this.chooser.setSelectedFile(item);
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            if (this.resetPartialName) {
                this.partialName.setLength(0);
            }
            this.resetPartialName = true;
        }
    }

    private void setListDataListener() {
        final BasicDirectoryModel model = ((BasicFileChooserUI)this.chooser.getUI()).getModel();
        model.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent lde) {
                Vector<File> buffer = new Vector<File>();
                buffer.addAll(model.getDirectories());
                buffer.addAll(model.getFiles());
                if (buffer.size() > 0) {
                    TypeAheadSelector.this.files = buffer;
                }
            }

            public void intervalAdded(ListDataEvent lde) {
            }

            public void intervalRemoved(ListDataEvent lde) {
            }
        });
    }
}

