/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.FrameDialog;
import DE.siemens.ad.logo.app.comp.HideableToolBar;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class TitledToolBarUI
extends BasicToolBarUI {
    protected JFrame floatFrame;
    protected String floatTitle = "";
    protected ImageIcon fFloatImageIcon;
    protected LayoutManager dockedLayout;
    protected Window fOwnerWindow;
    public JComponent fToolBar;

    public TitledToolBarUI() {
    }

    public TitledToolBarUI(JComponent toolBar) {
        this.fToolBar = toolBar;
    }

    public boolean canDock(Component c, Point p) {
        boolean b = false;
        if (c.contains(p)) {
            int dockingSensitivity;
            int n = dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (p.y < dockingSensitivity) {
                b = true;
            }
            if (p.y > c.getSize().height - dockingSensitivity) {
                b = true;
            }
            if (p.x < dockingSensitivity) {
                b = true;
            }
            if (p.x > c.getSize().width - dockingSensitivity) {
                b = true;
            }
        }
        return b;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.fFloatImageIcon = imageIcon;
        if (this.floatFrame != null) {
            this.floatFrame.setIconImage(imageIcon.getImage());
        }
    }

    public JFrame createFloatingFrame(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        WindowListener wl = this.createFrameListener();
        HideableToolBar hidableToolBar = (HideableToolBar)toolbar;
        Window frame = this.getOwnerWindow();
        if (hidableToolBar.isAlwaysOnTop()) {
            this.floatFrame = new FrameDialog(frame);
            ((FrameDialog)this.floatFrame).setAutoResized(hidableToolBar.isFloatingFrameAutoResized());
        } else {
            this.floatFrame = new JFrame(toolbar.getName(), window != null ? window.getGraphicsConfiguration() : null);
        }
        this.floatFrame.addWindowListener(wl);
        this.floatFrame.setResizable(hidableToolBar.isFloatingFrameResizable());
        if (this.floatTitle != null) {
            this.floatFrame.setTitle(this.floatTitle);
        }
        if (this.fFloatImageIcon != null) {
            this.floatFrame.setIconImage(this.fFloatImageIcon.getImage());
        } else if (frame instanceof Frame) {
            this.floatFrame.setIconImage(((Frame)frame).getIconImage());
        }
        return this.floatFrame;
    }

    public static ComponentUI createUI(JComponent c) {
        TitledToolBarUI toolBarUI = new TitledToolBarUI();
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, c);
        toolBarUI.setOwnerWindow(frame);
        return toolBarUI;
    }

    public void dragTo(Point position, Point origin) {
        super.dragTo(position, origin);
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        return this.createFloatingFrame(toolbar);
    }

    public JFrame getFrame() {
        return this.floatFrame;
    }

    public Window getOwnerWindow() {
        if (this.fOwnerWindow == null) {
            this.fOwnerWindow = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.fToolBar);
        }
        if (this.fOwnerWindow == null) {
            this.fOwnerWindow = (Frame)Application.getInstance().getActiveApplicationSurface().getWindow();
        }
        return this.fOwnerWindow;
    }

    public void setFloating(boolean b, Point p) {
        if (b & p != null) {
            this.setFloatingLocation(p.x, p.y);
        }
        super.setFloating(b, p);
    }

    public void setFrame(JFrame newFrame) {
        this.floatFrame = newFrame;
    }

    public void setOwnerWindow(Window ownerWindow) {
        this.fOwnerWindow = ownerWindow;
    }

    public void setTitle(String title) {
        this.floatTitle = title;
        if (this.floatFrame != null) {
            this.floatFrame.setTitle(title);
        }
    }
}

