/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class RolloverToggleButton
extends JToggleButton {
    protected final Color SELECTED_BACKGROUND = UIManager.getColor("Button.background").brighter();
    protected final Color SELECTED_MOUSEOVER_BACKGROUND = UIManager.getColor("Button.background").darker();
    protected final Color UNSELECTED_BACKGROUND = UIManager.getColor("Button.background");

    public RolloverToggleButton() {
        this.init();
    }

    public RolloverToggleButton(String text) {
        super(text);
        this.init();
    }

    public RolloverToggleButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public RolloverToggleButton(Icon icon) {
        super(icon);
        this.init();
    }

    public void init() {
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        final RolloverToggleButton button = this;
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent me) {
                button.setBorderPainted(true);
                if (RolloverToggleButton.this.isSelected()) {
                    RolloverToggleButton.this.setBackground(RolloverToggleButton.this.SELECTED_MOUSEOVER_BACKGROUND);
                }
            }

            public void mouseExited(MouseEvent me) {
                if (!RolloverToggleButton.this.isSelected()) {
                    button.setBorderPainted(false);
                } else {
                    RolloverToggleButton.this.setBackground(RolloverToggleButton.this.SELECTED_BACKGROUND);
                }
            }
        });
    }

    public void setSelected(boolean value) {
        super.setSelected(value);
        if (value) {
            this.setBackground(this.SELECTED_BACKGROUND);
        } else {
            this.setBackground(this.UNSELECTED_BACKGROUND);
        }
        this.setBorderPainted(this.isSelected());
    }
}

