/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.action.ActionGroupEvent;
import DE.siemens.ad.logo.app.action.ActionGroupListener;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.DropdownButton;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.app.comp.RolloverToggleButton;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class RolloverButtonToolBar
extends JToolBar
implements ActionGroupListener {
    private Hashtable fReturnValueHashtable;
    List fActionGroups = new ArrayList(5);
    protected Hashtable listenerRegistry = new Hashtable();
    public static boolean bigButtons = false;
    protected LayoutManager fHorizontalLayout;
    protected WeakReference fActionGroupReference;
    protected LayoutManager fVerticalLayout;
    protected boolean fChangeOrientation = true;

    protected void createToolbar(ActionGroup actionGroup) {
        Iterator actionGroups = this.fActionGroups.iterator();
        while (actionGroups.hasNext()) {
            ((ActionGroup)actionGroups.next()).removeActionGroupListener(this);
        }
        this.unregisterToolbarItemsForActions();
        this.removeAll();
        Iterator i = actionGroup.getActions().iterator();
        LogoAction lastAction = null;
        LogoAction currentAction = null;
        int count = 1;
        while (i.hasNext()) {
            currentAction = (LogoAction)i.next();
            this.insertSeparatorIfNeeded(currentAction, lastAction);
            JButton rw = this.add(currentAction);
            if (actionGroup.isNumbered() && rw instanceof AbstractButton) {
                ((AbstractButton)rw).setText(count + " " + ((AbstractButton)rw).getText());
                ++count;
            }
            lastAction = currentAction;
        }
        actionGroup.addActionGroupListener(this);
    }

    public RolloverButtonToolBar() {
    }

    public RolloverButtonToolBar(ActionGroup actionGroup) {
        this.fActionGroupReference = new WeakReference<ActionGroup>(actionGroup);
        this.createToolbar(actionGroup);
    }

    public void actionAdded(ActionGroupEvent age) {
        if (this.getActionGroup() == null) {
            return;
        }
        this.createToolbar(this.getActionGroup());
    }

    public void actionRemoved(ActionGroupEvent age) {
        if (this.getActionGroup() == null) {
            return;
        }
        this.createToolbar(this.getActionGroup());
    }

    public RolloverButtonToolBar(int orientation) {
        this();
        this.setOrientation(orientation);
    }

    public JButton add(ActionGroup actionGroup) {
        if (!actionGroup.isFlatToolbar()) {
            LogoAction defaultAction = actionGroup.getDefaultAction();
            if (defaultAction == null) {
                JButton button = new JButton("No default set!");
                this.add(button);
                return button;
            }
            DropdownButton dropdownButton = new DropdownButton(actionGroup);
            JButton actionButton = dropdownButton.getActionButton();
            actionButton.setIcon((Icon)defaultAction.getValue("SmallIcon"));
            actionButton.setHorizontalTextPosition(0);
            actionButton.setVerticalTextPosition(3);
            dropdownButton.setEnabled(actionGroup.isEnabled());
            actionButton.addActionListener(defaultAction);
            String textKey = (String)defaultAction.getValue("textKey");
            String defaultText = (String)defaultAction.getValue("defaultText");
            this.setStrings((AbstractButton)actionButton, textKey, defaultText, defaultAction);
            CSH.setHelpIDString((Component)dropdownButton, (String)((String)defaultAction.getValue("textKey")));
            this.add(dropdownButton);
            PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(actionButton);
            if (this.listenerRegistry == null) {
                this.listenerRegistry = new Hashtable();
            }
            defaultAction.addPropertyChangeListener(actionPropertyChangeListener);
            dropdownButton.setAlignmentX(0.0f);
            return dropdownButton;
        }
        Iterator i = actionGroup.getActions().iterator();
        while (i.hasNext()) {
            this.add((Action)i.next());
        }
        actionGroup.addActionGroupListener(this);
        return null;
    }

    private void insertSeparatorIfNeeded(LogoAction currentAction, LogoAction lastAction) {
        if (lastAction instanceof ActionGroup && ((ActionGroup)lastAction).isFlatToolbar()) {
            JToolBar.Separator toolbarSeparator = new JToolBar.Separator();
            toolbarSeparator.setAlignmentX(0.0f);
            this.add(toolbarSeparator);
            return;
        }
        if (currentAction instanceof ActionGroup && lastAction != null && ((ActionGroup)currentAction).isFlatToolbar()) {
            JToolBar.Separator toolbarSeparator = new JToolBar.Separator();
            toolbarSeparator.setAlignmentX(0.0f);
            this.add(toolbarSeparator);
            return;
        }
    }

    public JToggleButton add(LogoToggleAction a) {
        RolloverToggleButton b = new RolloverToggleButton();
        b.setIcon((Icon)a.getValue("SmallIcon"));
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setEnabled(a.isEnabled());
        b.setSelected(a.isSelected());
        b.addActionListener(a);
        String textKey = (String)a.getValue("textKey");
        String defaultText = (String)a.getValue("defaultText");
        this.setStrings((AbstractButton)b, textKey, defaultText, a);
        CSH.setHelpIDString((Component)b, (String)((String)a.getValue("textKey")));
        this.add(b);
        PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(b);
        if (this.listenerRegistry == null) {
            this.listenerRegistry = new Hashtable();
        }
        this.listenerRegistry.put(b, actionPropertyChangeListener);
        this.listenerRegistry.put(actionPropertyChangeListener, a);
        a.addPropertyChangeListener(actionPropertyChangeListener);
        return b;
    }

    protected ActionGroup getActionGroup() {
        if (this.fActionGroupReference == null) {
            return null;
        }
        return (ActionGroup)this.fActionGroupReference.get();
    }

    public JButton add(Action a) {
        if (a instanceof LogoToggleAction) {
            this.add((LogoToggleAction)a);
            return null;
        }
        if (a instanceof ActionGroup) {
            return this.add((ActionGroup)a);
        }
        RolloverButton b = new RolloverButton();
        b.setIcon((Icon)a.getValue("SmallIcon"));
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        b.setEnabled(a.isEnabled());
        b.addActionListener(a);
        String textKey = (String)a.getValue("textKey");
        String defaultText = (String)a.getValue("defaultText");
        this.setStrings((AbstractButton)b, textKey, defaultText, a);
        CSH.setHelpIDString((Component)b, (String)((String)a.getValue("textKey")));
        this.add(b);
        PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(b);
        if (this.listenerRegistry == null) {
            this.listenerRegistry = new Hashtable();
        }
        a.addPropertyChangeListener(actionPropertyChangeListener);
        b.setAlignmentX(0.0f);
        return b;
    }

    public void clearListenerRegistry() {
        this.listenerRegistry.clear();
    }

    public PropertyChangeListener createActionChangeListener(JButton tb) {
        ActionChangedListener acl = new ActionChangedListener(tb);
        return acl;
    }

    public void unregisterToolbarItemsForActions() {
        if (this.listenerRegistry == null) {
            return;
        }
        Component[] c = this.getComponents();
        Component key = null;
        for (int i = 0; i < c.length; ++i) {
            PropertyChangeListener changeListener;
            key = c[i];
            if (key instanceof DropdownButton) {
                ((DropdownButton)key).getPopupMenu().unregisterMenuItemsForActions();
                continue;
            }
            if (!(key instanceof AbstractButton) || (changeListener = (PropertyChangeListener)this.listenerRegistry.get(key)) == null) continue;
            Action a = (Action)this.listenerRegistry.get(changeListener);
            a.removePropertyChangeListener(changeListener);
            this.listenerRegistry.remove(key);
            this.listenerRegistry.remove(changeListener);
        }
    }

    public PropertyChangeListener createActionChangeListener(JToggleButton tb) {
        ActionChangedListener acl = new ActionChangedListener(tb);
        return acl;
    }

    public LayoutManager getHorizontalLayout() {
        if (this.fHorizontalLayout == null) {
            this.fHorizontalLayout = new ToolBarLayout(3, 0, 2);
        }
        return this.fHorizontalLayout;
    }

    public boolean isChangeOrientation() {
        return this.fChangeOrientation;
    }

    public void setChangeOrientation(boolean newChangeOrientation) {
        this.fChangeOrientation = newChangeOrientation;
    }

    public void setHorizontalLayout(LayoutManager lm) {
        this.fHorizontalLayout = lm;
        if (this.getOrientation() == 0) {
            this.setLayout(lm);
        }
    }

    public void setOrientation(int o) {
        int old = this.getOrientation();
        super.setOrientation(o);
        if (!this.isChangeOrientation()) {
            return;
        }
        if (o == 1) {
            this.setLayout(this.getVerticalLayout());
        } else {
            this.setLayout(this.getHorizontalLayout());
        }
        this.revalidate();
        this.repaint();
    }

    protected void setStrings(AbstractButton button, String resourceKey, String defaultString) {
        Hashtable ht = this.getReturnValueHashtable();
        ht.clear();
        this.setStrings(button, resourceKey, defaultString, ht);
    }

    private void setStrings(AbstractButton button, String resourceKey, String defaultString, Hashtable ht) {
        if (defaultString == null) {
            defaultString = resourceKey;
        }
        String str = Language.getStringAndAccelerator(resourceKey, defaultString, ht);
        if (bigButtons) {
            button.setHorizontalTextPosition(0);
            button.setVerticalTextPosition(3);
            button.setText(str);
        } else {
            button.setToolTipText(str);
            button.setMargin(new Insets(1, 1, 1, 1));
        }
    }

    protected void setStrings(AbstractButton button, String resourceKey, String defaultString, Action a) {
        Hashtable ht = this.getReturnValueHashtable();
        ht.clear();
        this.setStrings(button, resourceKey, defaultString, ht);
        KeyStroke keyStroke = (KeyStroke)ht.get("KeyStroke");
        if (keyStroke != null) {
            button.getInputMap(2).put(keyStroke, keyStroke);
            button.getActionMap().put(keyStroke, a);
        }
    }

    private Hashtable getReturnValueHashtable() {
        if (this.fReturnValueHashtable == null) {
            this.fReturnValueHashtable = new Hashtable(10);
        }
        return this.fReturnValueHashtable;
    }

    public LayoutManager getVerticalLayout() {
        if (this.fVerticalLayout == null) {
            this.fVerticalLayout = new BoxLayout(this, 1);
        }
        return this.fVerticalLayout;
    }

    public void setVerticalLayout(LayoutManager verticalLayout) {
        this.fVerticalLayout = verticalLayout;
        if (this.getOrientation() == 1) {
            this.setLayout(verticalLayout);
        }
    }

    public static class ActionChangedListener
    implements PropertyChangeListener {
        WeakReference target;

        ActionChangedListener(AbstractButton b) {
            this.setTarget(b);
        }

        public void propertyChange(PropertyChangeEvent e) {
            LogoAction action = (LogoAction)e.getSource();
            String propertyName = e.getPropertyName();
            AbstractButton button = this.getButton();
            if (button == null) {
                action.removePropertyChangeListener(this);
                return;
            }
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                return;
            }
            if (e.getPropertyName().equals("ShortDescription")) {
                String text = (String)e.getNewValue();
                button.setToolTipText(text);
                return;
            }
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                button.setEnabled(enabledState);
                button.repaint();
                return;
            }
            if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                button.setIcon(icon);
                button.invalidate();
                button.repaint();
                return;
            }
            if (e.getPropertyName().equals("selected")) {
                Boolean selectedState = (Boolean)e.getNewValue();
                button.setSelected(selectedState);
                button.repaint();
                return;
            }
            if (e.getPropertyName().equals("textKey")) {
                this.setStrings(button, (String)e.getNewValue(), (String)action.getValue("defaultText"));
                return;
            }
        }

        public void setTarget(Object b) {
            this.target = new WeakReference<Object>(b);
        }

        public AbstractButton getButton() {
            return (AbstractButton)this.target.get();
        }

        protected void setStrings(AbstractButton b, String resourceKey, String defaultString) {
            Object ks = null;
            Hashtable ht = new Hashtable();
            String str = Language.getStringAndAccelerator(resourceKey, defaultString, ht);
            if (defaultString == null) {
                defaultString = resourceKey;
            }
            if (bigButtons) {
                b.setHorizontalTextPosition(0);
                b.setVerticalTextPosition(3);
                b.setText(str);
            } else {
                b.setToolTipText(str);
                b.setMargin(new Insets(1, 1, 1, 1));
            }
        }
    }
}

