/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OpenComboBox
extends JPanel
implements ListSelectionListener,
ActionListener {
    protected JList fList;
    protected JTextField fTextField;
    protected JLabel fTitleLabel;

    public OpenComboBox() {
        this.initComponents();
    }

    public void actionPerformed(ActionEvent e) {
        ListModel model = this.fList.getModel();
        String key = this.fTextField.getText().toLowerCase();
        boolean isNameCellRenderer = this.fList.getCellRenderer() instanceof NameListCellRenderer;
        for (int k = 0; k < model.getSize(); ++k) {
            String data = isNameCellRenderer ? ((NameListCellRenderer)this.fList.getCellRenderer()).getName(model.getElementAt(k)) : model.getElementAt(k).toString();
            if (!data.toLowerCase().startsWith(key)) continue;
            this.fList.setSelectedValue(data, true);
            break;
        }
    }

    public JList getList() {
        return this.fList;
    }

    public JTextField getTextField() {
        return this.fTextField;
    }

    public String getTitle() {
        return this.fTitleLabel.getText();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.fTitleLabel = new JLabel("Title");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.fTitleLabel, gbc);
        this.fTextField = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.fTextField, gbc);
        this.fList = new JList();
        this.fList.getSelectionModel().setSelectionMode(0);
        this.fList.setCellRenderer(new DefaultNameListCellRenderer());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        this.add((Component)new JScrollPane(this.fList), gbc);
        this.fList.addListSelectionListener(this);
        this.fTextField.addActionListener(this);
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this.getList().setCellRenderer(listCellRenderer);
    }

    public void setTitle(String newTitle) {
        this.fTitleLabel.setText(newTitle);
    }

    public void valueChanged(ListSelectionEvent e) {
        Object obj = this.fList.getSelectedValue();
        boolean isNameListCellRenderer = this.fList.getCellRenderer() instanceof NameListCellRenderer;
        if (obj != null) {
            if (isNameListCellRenderer) {
                this.fTextField.setText(((NameListCellRenderer)this.fList.getCellRenderer()).getName(obj));
            } else {
                this.fTextField.setText(obj.toString());
            }
        }
    }

    public static class DefaultNameListCellRenderer
    extends DefaultListCellRenderer {
        public String getName(Object value) {
            return value.toString();
        }
    }

    public static interface NameListCellRenderer
    extends ListCellRenderer {
        public String getName(Object var1);
    }
}

