/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.action.ActionGroupEvent;
import DE.siemens.ad.logo.app.action.ActionGroupListener;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.LogoJMenu;
import DE.siemens.ad.logo.util.Language;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LogoJPopupMenu
extends JPopupMenu
implements ActionGroupListener {
    protected Hashtable listenerRegistry;
    protected WeakReference fActionGroupReference;
    protected int fOpenDirection = 4;

    public LogoJPopupMenu() {
    }

    public LogoJPopupMenu(ActionGroup actionGroup) {
        this();
        this.fActionGroupReference = new WeakReference<ActionGroup>(actionGroup);
        this.createMenu(actionGroup);
        actionGroup.addActionGroupListener(this);
    }

    public LogoJPopupMenu(String label) {
        this();
        this.setLabel(label);
    }

    public void actionAdded(ActionGroupEvent age) {
        if (this.getActionGroup() != null) {
            this.createMenu(this.getActionGroup());
        }
    }

    public void actionRemoved(ActionGroupEvent age) {
        if (this.getActionGroup() != null) {
            this.createMenu(this.getActionGroup());
        }
    }

    public JMenuItem add(ActionGroup actionGroup) {
        if (!actionGroup.isFlatMenu()) {
            LogoJMenu logoMenu = new LogoJMenu(actionGroup);
            logoMenu.setEnabled(actionGroup.isEnabled());
            logoMenu.setIcon((Icon)actionGroup.getValue("SmallIcon"));
            super.add(logoMenu);
            String textKey = (String)actionGroup.getValue("textKey");
            String defaultText = (String)actionGroup.getValue("defaultText");
            if (textKey != null) {
                if (defaultText == null) {
                    defaultText = textKey;
                }
                this.setStringAndAccelerator(logoMenu, textKey, defaultText);
            }
            return logoMenu;
        }
        this.addSeparator();
        Iterator i = actionGroup.getActions().iterator();
        while (i.hasNext()) {
            this.add((Action)i.next());
        }
        actionGroup.addActionGroupListener(this);
        this.addSeparator();
        return null;
    }

    public JMenuItem add(LogoToggleAction a) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        mi.setSelected(a.isSelected());
        mi.setForeground((Color)a.getValue("foreground"));
        mi.addActionListener(a);
        this.add(mi);
        PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(mi);
        if (this.listenerRegistry == null) {
            this.listenerRegistry = new Hashtable();
        }
        this.listenerRegistry.put(mi, actionPropertyChangeListener);
        this.listenerRegistry.put(actionPropertyChangeListener, a);
        a.addPropertyChangeListener(actionPropertyChangeListener);
        String textKey = (String)a.getValue("textKey");
        if (textKey != null) {
            this.setStringAndAccelerator(mi, textKey, textKey);
        }
        return mi;
    }

    public JMenuItem add(Action a) {
        if (a instanceof LogoToggleAction) {
            return this.add((LogoToggleAction)a);
        }
        if (a instanceof ActionGroup) {
            return this.add((ActionGroup)a);
        }
        JMenuItem mi = super.add(a);
        String textKey = (String)a.getValue("textKey");
        if (textKey != null) {
            this.setStringAndAccelerator(mi, textKey, textKey);
        }
        if (a instanceof LogoAction) {
            mi.setForeground((Color)a.getValue("foreground"));
        }
        return mi;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem menuItem) {
        return new ActionChangedListener(menuItem);
    }

    protected void createMenu(ActionGroup actionGroup) {
        this.removeAll();
        Iterator i = actionGroup.getActions().iterator();
        while (i.hasNext()) {
            this.add((LogoAction)i.next());
        }
    }

    public ActionGroup getActionGroup() {
        if (this.fActionGroupReference == null) {
            return null;
        }
        return (ActionGroup)this.fActionGroupReference.get();
    }

    protected void setStringAndAccelerator(JMenuItem item, String resourceKey, String defaultString) {
        Object ks = null;
        Hashtable ht = new Hashtable();
        String str = Language.getStringAndAccelerator(resourceKey, defaultString, ht);
        str = Language.getStringNoTilde(resourceKey, defaultString);
        item.setText(str);
        KeyStroke keyStroke = (KeyStroke)ht.get("KeyStroke");
        if (keyStroke != null) {
            item.setAccelerator(keyStroke);
        }
    }

    public void show(Component invoker, int x, int y) {
        this.show(invoker, x, y, this.getOpenDirection(), false);
    }

    public void show(Component invoker, int x, int y, int openDirection, boolean skipInvoker) {
        Point popupLocation = new Point(x, y);
        SwingUtilities.convertPointToScreen(popupLocation, invoker);
        Dimension popupSize = this.getPreferredSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int dx = 0;
        int dy = 0;
        if (openDirection == 4) {
            if (popupLocation.x + popupSize.width > screenSize.width) {
                dx -= popupSize.width;
                if (skipInvoker) {
                    dx -= invoker.getWidth();
                }
            }
        } else {
            dx = -popupSize.width;
            if (popupLocation.x - popupSize.width < 0) {
                dx += popupSize.width;
                if (skipInvoker) {
                    dx += invoker.getWidth();
                }
            }
        }
        if (popupLocation.y + popupSize.height > screenSize.height) {
            dy = screenSize.height - (popupLocation.y + popupSize.height) - 50;
        }
        if (popupLocation.x + dx < 0) {
            dx -= popupLocation.x + dx;
        }
        if (popupLocation.y + dy < 0) {
            dy -= popupLocation.y + dy;
        }
        super.show(invoker, x + dx, y + dy);
    }

    public int getOpenDirection() {
        return this.fOpenDirection;
    }

    public void setOpenDirection(int openDirection) {
        this.fOpenDirection = openDirection;
    }

    public void showRelative(Component component, int placement) {
        Point popupPosition = null;
        int popupOpenDirection = 4;
        Rectangle componentBounds = component.getBounds();
        switch (placement) {
            case 3: {
                popupPosition = new Point(componentBounds.x + componentBounds.width, componentBounds.y);
                popupOpenDirection = 4;
                break;
            }
            case 7: {
                popupPosition = componentBounds.getLocation();
                popupOpenDirection = 2;
            }
        }
        this.show(component, popupPosition.x, popupPosition.y, popupOpenDirection, true);
    }

    public void unregisterMenuItemsForActions() {
        if (this.listenerRegistry == null) {
            return;
        }
        Component[] c = this.getComponents();
        Component key = null;
        for (int i = 0; i < c.length; ++i) {
            PropertyChangeListener changeListener;
            key = c[i];
            if (key instanceof LogoJMenu) {
                ((LogoJMenu)key).unregisterMenuItemsForActions();
                continue;
            }
            if (!(key instanceof JMenuItem) || (changeListener = (PropertyChangeListener)this.listenerRegistry.get(key)) == null) continue;
            Action a = (Action)this.listenerRegistry.get(changeListener);
            a.removePropertyChangeListener(changeListener);
            this.listenerRegistry.remove(key);
            this.listenerRegistry.remove(changeListener);
        }
    }

    public static class ActionChangedListener
    implements PropertyChangeListener {
        WeakReference target;

        ActionChangedListener(JMenuItem mi) {
            this.setTarget(mi);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            LogoAction action = (LogoAction)e.getSource();
            JMenuItem menuItem = this.getMenuItem();
            if (menuItem == null) {
                ((AbstractAction)e.getSource()).removePropertyChangeListener(this);
                return;
            }
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                return;
            }
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                menuItem.setEnabled(enabledState);
                return;
            }
            if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                menuItem.setIcon(icon);
                menuItem.invalidate();
                menuItem.repaint();
                return;
            }
            if (e.getPropertyName().equals("selected")) {
                if (menuItem instanceof JCheckBoxMenuItem) {
                    Boolean selectedState = (Boolean)e.getNewValue();
                    ((JCheckBoxMenuItem)menuItem).setState(selectedState);
                }
                return;
            }
            if (e.getPropertyName().equals("textKey")) {
                this.setStringAndAccelerator(menuItem, (String)e.getNewValue(), (String)action.getValue("defaultText"));
                return;
            }
        }

        public void setTarget(JMenuItem b) {
            this.target = new WeakReference<JMenuItem>(b);
        }

        protected void setStringAndAccelerator(JMenuItem item, String resourceKey, String defaultString) {
            KeyStroke keyStroke;
            Object ks = null;
            Hashtable ht = new Hashtable(10);
            if (defaultString == null) {
                defaultString = resourceKey;
            }
            String str = Language.getStringAndAccelerator(resourceKey, defaultString, ht);
            item.setText(str);
            Integer keyEvent = (Integer)ht.get("KeyEvent");
            if (keyEvent != null) {
                item.setMnemonic(keyEvent);
            }
            if ((keyStroke = (KeyStroke)ht.get("KeyStroke")) != null) {
                item.setAccelerator(keyStroke);
            }
        }

        private JMenuItem getMenuItem() {
            return (JMenuItem)this.target.get();
        }
    }
}

