/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.action.ActionGroupEvent;
import DE.siemens.ad.logo.app.action.ActionGroupListener;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.LogoJMenuItem;
import DE.siemens.ad.logo.util.Language;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class LogoJMenu
extends JMenu
implements ActionGroupListener {
    private Hashtable listenerRegistry;
    private KeyStroke accelerator;
    protected WeakReference fActionGroupReference;
    protected Vector fActionGroups = new Vector();
    private boolean fMenuUpToDate;

    public LogoJMenu() {
    }

    public LogoJMenu(ActionGroup actionGroup) {
        this.fActionGroupReference = new WeakReference<ActionGroup>(actionGroup);
        this.fMenuUpToDate = false;
        this.createMenu(actionGroup);
    }

    public LogoJMenu(String s) {
        super(s);
    }

    public void actionAdded(ActionGroupEvent age) {
        if (this.getActionGroup() == null) {
            return;
        }
        this.fMenuUpToDate = false;
    }

    public void actionRemoved(ActionGroupEvent age) {
        if (this.getActionGroup() == null) {
            return;
        }
        this.fMenuUpToDate = false;
        this.createMenu(this.getActionGroup());
    }

    public JMenuItem add(ActionGroup actionGroup) {
        if (!actionGroup.isFlatMenu()) {
            LogoJMenu logoMenu = new LogoJMenu(actionGroup);
            super.add(logoMenu);
            logoMenu.setIcon((Icon)actionGroup.getValue("SmallIcon"));
            LogoJMenu.setStringAndAccelerator(logoMenu, actionGroup);
            return logoMenu;
        }
        Iterator i = actionGroup.getActions().iterator();
        int count = 1;
        while (i.hasNext()) {
            JMenuItem rw = this.add((Action)i.next());
            if (actionGroup.isNumbered() && rw instanceof LogoJMenuItem) {
                ((LogoJMenuItem)rw).setNumber(count);
            }
            ++count;
        }
        actionGroup.addActionGroupListener(this);
        this.fActionGroups.add(actionGroup);
        return null;
    }

    public JMenuItem add(LogoToggleAction a) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        mi.setSelected(a.isSelected());
        mi.addActionListener(a);
        LogoJMenu.setStringAndAccelerator(mi, a);
        mi.setForeground((Color)a.getValue("foreground"));
        this.add(mi);
        PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(mi);
        if (this.listenerRegistry == null) {
            this.listenerRegistry = new Hashtable();
        }
        this.listenerRegistry.put(mi, actionPropertyChangeListener);
        this.listenerRegistry.put(actionPropertyChangeListener, a);
        a.addPropertyChangeListener(actionPropertyChangeListener);
        return mi;
    }

    public JMenuItem add(Action a) {
        if (a instanceof LogoToggleAction) {
            return this.add((LogoToggleAction)a);
        }
        if (a instanceof ActionGroup) {
            return this.add((ActionGroup)a);
        }
        LogoJMenuItem mi = new LogoJMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        mi.addActionListener(a);
        this.add(mi);
        this.registerMenuItemForAction(mi, a);
        if (a instanceof LogoAction) {
            LogoJMenu.setStringAndAccelerator(mi, (LogoAction)a);
            mi.setForeground((Color)a.getValue("foreground"));
        }
        return mi;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(b);
    }

    protected void createMenu(ActionGroup actionGroup) {
        Iterator actionGroups = this.fActionGroups.iterator();
        while (actionGroups.hasNext()) {
            ((ActionGroup)actionGroups.next()).removeActionGroupListener(this);
        }
        this.unregisterMenuItemsForActions();
        this.removeAll();
        Iterator i = actionGroup.getActions().iterator();
        LogoAction lastAction = null;
        LogoAction currentAction = null;
        int count = 1;
        while (i.hasNext()) {
            currentAction = (LogoAction)i.next();
            this.insertSeparatorIfNeeded(currentAction, lastAction);
            JMenuItem rw = this.add(currentAction);
            if (actionGroup.isNumbered() && rw instanceof AbstractButton) {
                ((AbstractButton)rw).setText(count + " " + ((AbstractButton)rw).getText());
                ++count;
            }
            lastAction = currentAction;
        }
        actionGroup.addActionGroupListener(this);
        this.fMenuUpToDate = true;
    }

    protected ActionGroup getActionGroup() {
        if (this.fActionGroupReference == null) {
            return null;
        }
        return (ActionGroup)this.fActionGroupReference.get();
    }

    private void insertSeparatorIfNeeded(LogoAction currentAction, LogoAction lastAction) {
        if (lastAction instanceof ActionGroup && ((ActionGroup)lastAction).isFlatMenu()) {
            this.addSeparator();
            return;
        }
        if (currentAction instanceof ActionGroup && lastAction != null && ((ActionGroup)currentAction).isFlatMenu()) {
            this.addSeparator();
            return;
        }
    }

    public void setAccelerator(KeyStroke keyStroke) {
        KeyStroke oldAccelerator = this.accelerator;
        this.accelerator = keyStroke;
        this.firePropertyChange("accelerator", oldAccelerator, this.accelerator);
    }

    private void registerMenuItemForAction(JMenuItem mi, Action a) {
        PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(mi);
        if (this.listenerRegistry == null) {
            this.listenerRegistry = new Hashtable();
        }
        if (this.listenerRegistry.get(mi) != null) {
            return;
        }
        this.listenerRegistry.put(mi, actionPropertyChangeListener);
        this.listenerRegistry.put(actionPropertyChangeListener, a);
        a.addPropertyChangeListener(actionPropertyChangeListener);
    }

    protected static void setStringAndAccelerator(JMenuItem item, LogoAction a) {
        KeyStroke keyStroke;
        String textKey = (String)a.getValue("textKey");
        String defaultText = (String)a.getValue("defaultText");
        if (textKey == null) {
            return;
        }
        Object ks = null;
        Hashtable ht = new Hashtable(10);
        if (defaultText == null) {
            defaultText = textKey;
        }
        String str = Language.getStringAndAccelerator(textKey, defaultText, ht);
        item.setText(str);
        Integer keyEvent = (Integer)ht.get("KeyEvent");
        if (keyEvent != null) {
            item.setMnemonic(keyEvent);
        }
        if ((keyStroke = (KeyStroke)ht.get("KeyStroke")) != null) {
            if (item instanceof JMenu) {
                item.registerKeyboardAction(a, keyStroke, 2);
                item.setAccelerator(keyStroke);
            } else {
                item.setAccelerator(keyStroke);
            }
        }
    }

    public void unregisterMenuItemsForActions() {
        if (this.listenerRegistry == null) {
            return;
        }
        Component[] c = this.getMenuComponents();
        Component key = null;
        for (int i = 0; i < c.length; ++i) {
            PropertyChangeListener changeListener;
            key = c[i];
            if (key instanceof LogoJMenu) {
                ((LogoJMenu)key).unregisterMenuItemsForActions();
                continue;
            }
            if (!(key instanceof JMenuItem) || (changeListener = (PropertyChangeListener)this.listenerRegistry.get(key)) == null) continue;
            Action a = (Action)this.listenerRegistry.get(changeListener);
            a.removePropertyChangeListener(changeListener);
            this.listenerRegistry.remove(key);
            this.listenerRegistry.remove(changeListener);
        }
    }

    public void setPopupMenuVisible(boolean b) {
        if (this.getActionGroup() != null && !this.fMenuUpToDate) {
            this.createMenu(this.getActionGroup());
        }
        super.setPopupMenuVisible(b);
    }

    public static class ActionChangedListener
    implements PropertyChangeListener {
        WeakReference target;

        ActionChangedListener(JMenuItem mi) {
            this.setTarget(mi);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            LogoAction action = (LogoAction)e.getSource();
            JMenuItem menuItem = this.getMenuItem();
            if (menuItem == null) {
                ((AbstractAction)e.getSource()).removePropertyChangeListener(this);
                return;
            }
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                if (!text.equals(menuItem.getText())) {
                    menuItem.setText(text);
                }
                return;
            }
            if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                menuItem.setEnabled(enabledState);
                return;
            }
            if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                menuItem.setIcon(icon);
                menuItem.invalidate();
                menuItem.repaint();
                return;
            }
            if (e.getPropertyName().equals("selected")) {
                if (menuItem instanceof JCheckBoxMenuItem) {
                    Boolean selectedState = (Boolean)e.getNewValue();
                    ((JCheckBoxMenuItem)menuItem).setState(selectedState);
                }
                return;
            }
            if (e.getPropertyName().equals("textKey")) {
                LogoJMenu.setStringAndAccelerator(menuItem, action);
                return;
            }
        }

        public void setTarget(JMenuItem b) {
            this.target = new WeakReference<JMenuItem>(b);
        }

        private JMenuItem getMenuItem() {
            return (JMenuItem)this.target.get();
        }
    }
}

