/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LengthRestrictedJTextField
extends JTextField {
    protected int maxLength;
    protected String initialValue;
    protected String prevValue;
    private boolean fWriteActive;
    public int fMask;
    public static int NONE = 0;
    public static int ASCII = 1;

    public LengthRestrictedJTextField() {
        this(60);
    }

    public LengthRestrictedJTextField(int nrOfColumns) {
        super(nrOfColumns);
        this.prevValue = this.initialValue = this.getDefaultInitialValue();
        this.fMask = NONE;
        this.maxLength = nrOfColumns;
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (!evt.isAltDown() || !evt.isShiftDown()) {
                    return;
                }
                LengthRestrictedJTextField.this.replaceSelection(String.valueOf(evt.getKeyChar()));
                evt.consume();
            }
        });
    }

    public boolean checkChanged() {
        return !this.initialValue.equals(this.getText());
    }

    protected Document createDefaultModel() {
        return new LengthRestrictedDocument();
    }

    public String getDefaultInitialValue() {
        return "";
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public int getMask() {
        return this.fMask;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getText() {
        if (this.fWriteActive) {
            return this.prevValue;
        }
        this.prevValue = super.getText();
        return this.prevValue;
    }

    public boolean isValidString(String str) {
        if (str.length() > this.maxLength) {
            return false;
        }
        if (this.getMask() == ASCII) {
            byte[] b = str.getBytes();
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 32 && b[i] <= 127) continue;
                return false;
            }
        }
        return true;
    }

    public void setInitialValue(String newValue) {
        this.initialValue = newValue;
        this.setText(this.initialValue);
    }

    public void setMask(int newMask) {
        this.fMask = newMask;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        this.setColumns(length);
    }

    public void setText(String newText) {
        this.prevValue = newText;
        this.fWriteActive = true;
        super.setText(newText);
        this.fWriteActive = false;
    }

    public class LengthRestrictedDocument
    extends PlainDocument {
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String currentString = this.getText(0, this.getLength());
            String tempString = currentString.substring(0, offs) + str + currentString.substring(offs);
            if (LengthRestrictedJTextField.this.isValidString(tempString)) {
                super.insertString(offs, str, a);
            } else {
                LengthRestrictedJTextField.this.getToolkit().beep();
            }
        }
    }
}

