/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class GradientBackgroundPanel
extends JPanel {
    protected Color fStartColor = Color.blue;
    protected Color fDestinationColor = Color.lightGray;
    protected int orientation = 0;

    public void paintComponent(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Dimension size = this.getSize();
        Point destinationPoint = null;
        Point startPoint = null;
        if (this.orientation == 0) {
            startPoint = new Point(0, 0);
            destinationPoint = new Point(size.width, 0);
        } else {
            startPoint = new Point(0, size.height);
            destinationPoint = new Point(0, 0);
        }
        GradientPaint paint = new GradientPaint(startPoint, this.fStartColor, destinationPoint, this.fDestinationColor);
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        g2d.setPaint(paint);
        g2d.fill(new Rectangle(0, 0, size.width, size.height));
        g2d.setPaint(oldPaint);
    }

    public GradientBackgroundPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public GradientBackgroundPanel(LayoutManager layout) {
        super(layout);
    }

    public GradientBackgroundPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public GradientBackgroundPanel() {
    }

    public Color getStartColor() {
        return this.fStartColor;
    }

    public void setStartColor(Color startColor) {
        this.fStartColor = startColor;
    }

    public Color getDestinationColor() {
        return this.fDestinationColor;
    }

    public void setDestinationColor(Color destinationColor) {
        this.fDestinationColor = destinationColor;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }
}

