/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

class FrameDialog
extends JFrame {
    protected JDialog dialog = new JDialog();
    protected JPanel newContentPane;
    protected boolean fAutoResized;

    public FrameDialog(Window owner) {
        if (owner instanceof Frame) {
            this.dialog = new JDialog((Frame)owner);
        } else if (owner instanceof Dialog) {
            this.dialog = new JDialog((Dialog)owner);
        } else {
            throw new IllegalArgumentException("Argument 'owner' must be an instance of either Dialog or Frame.");
        }
        this.dialog.setModal(false);
        this.newContentPane = new JPanel();
        this.newContentPane.setLayout(new BorderLayout());
        this.dialog.setContentPane(this.newContentPane);
        ComponentAdapter componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                if (FrameDialog.this.getContentPane().getComponentCount() == 0) {
                    return;
                }
                JComponent toolBar = (JComponent)FrameDialog.this.getContentPane().getComponent(0);
                FrameDialog.this.dialog.removeComponentListener(this);
                if (FrameDialog.this.fAutoResized) {
                    FrameDialog.this.pack();
                }
                FrameDialog.this.dialog.addComponentListener(this);
            }
        };
        this.dialog.addComponentListener(componentListener);
    }

    public FrameDialog(Frame owner, String title) {
        this((Window)owner);
        this.dialog.setTitle(title);
    }

    public Component add(Component comp) {
        this.dialog.add(comp);
        if (comp instanceof JToolBar) {
            ((JToolBar)comp).setLayout(new FlowLayout());
        }
        return comp;
    }

    public void addWindowListener(WindowListener wl) {
        this.dialog.addWindowListener(wl);
    }

    public Rectangle getBounds() {
        return this.dialog.getBounds();
    }

    public Container getContentPane() {
        return this.newContentPane;
    }

    public Point getLocation() {
        return this.dialog.getLocation();
    }

    public Dimension getSize() {
        return this.dialog.getSize();
    }

    public void hide() {
        this.dialog.setVisible(false);
    }

    public boolean isAutoResized() {
        return this.fAutoResized;
    }

    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    public void pack() {
        this.dialog.pack();
    }

    public void setAutoResized(boolean newAutoResized) {
        this.fAutoResized = newAutoResized;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.dialog.setBounds(x, y, width, height);
    }

    public void setLayout(LayoutManager manager) {
        super.setLayout(manager);
    }

    public void setLocation(int x, int y) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLocation(x, y);
    }

    public void setResizable() {
    }

    public void setResizable(boolean resizable) {
        this.dialog.setResizable(resizable);
    }

    public void setSize(int width, int height) {
        this.dialog.setSize(width, height);
        if (this.isAutoResized()) {
            this.dialog.pack();
        }
    }

    public void setSize(Dimension d) {
        this.dialog.setSize(d);
    }

    public synchronized void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
        if (b) {
            this.dialog.pack();
        }
    }

    public void show() {
        this.dialog.show();
        this.dialog.pack();
    }

    public void validate() {
        this.dialog.validate();
    }
}

