/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.FindFilter;
import DE.siemens.ad.logo.app.comp.FindFilterFactory;
import DE.siemens.ad.logo.app.comp.FindProgressCallback;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FindByContent
extends JPanel
implements FindFilterFactory {
    protected JTextField contentField = null;
    protected JCheckBox ignoreCaseCheck = null;

    FindByContent() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JLabel l = new JLabel("File contains...", 2);
        l.setForeground(Color.black);
        l.setFont(new Font("Helvetica", 0, 10));
        p.add(l);
        this.contentField = new JTextField();
        this.contentField.setForeground(Color.black);
        this.contentField.setFont(new Font("Helvetica", 0, 10));
        p.add(this.contentField);
        this.ignoreCaseCheck = new JCheckBox("ignore case", true);
        this.ignoreCaseCheck.setForeground(Color.black);
        this.ignoreCaseCheck.setFont(new Font("Helvetica", 0, 9));
        p.add(this.ignoreCaseCheck);
        this.add((Component)p, "North");
    }

    public FindFilter createFindFilter() {
        return new ContentFilter(this.contentField.getText(), this.ignoreCaseCheck.isSelected());
    }

    class ContentFilter
    implements FindFilter {
        protected String content = null;
        protected boolean ignoreCase = true;

        ContentFilter(String s, boolean ignore) {
            this.content = s;
            this.ignoreCase = ignore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(File f, FindProgressCallback callback) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return false;
            }
            if (this.content == null || this.content.length() == 0) {
                return true;
            }
            boolean result = false;
            BufferedInputStream in = null;
            try {
                long fileLength = f.length();
                in = new BufferedInputStream(new FileInputStream(f));
                byte[] contentBytes = null;
                contentBytes = this.ignoreCase ? this.content.toLowerCase().getBytes() : this.content.getBytes();
                LocatorStream locator = new LocatorStream(contentBytes);
                long counter = 0L;
                int callbackCounter = 20;
                int c = -1;
                while ((c = in.read()) != -1) {
                    ++counter;
                    int matchChar = c;
                    if (this.ignoreCase) {
                        matchChar = Character.toLowerCase((char)c);
                    }
                    locator.write(matchChar);
                    if (callback == null || --callbackCounter > 0) continue;
                    if (!callback.reportProgress(this, f, counter, fileLength)) {
                        boolean bl = false;
                        return bl;
                    }
                    callbackCounter = 20;
                }
            }
            catch (LocatedException e) {
                result = true;
            }
            catch (Throwable e) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {}
            }
            return result;
        }

        class LocatorStream
        extends OutputStream {
            protected byte[] locate = null;
            protected Vector matchMakers = new Vector();
            protected long mark = 0L;

            LocatorStream(byte[] b) {
                this.locate = b;
            }

            public void write(int b) throws IOException {
                if (this.locate == null) {
                    throw new IOException("NULL locator array");
                }
                if (this.locate.length == 0) {
                    throw new IOException("Empty locator array");
                }
                long foundAt = -1L;
                for (int i = this.matchMakers.size() - 1; i >= 0; --i) {
                    MatchStream m = (MatchStream)this.matchMakers.elementAt(i);
                    try {
                        m.write(b);
                        continue;
                    }
                    catch (MatchMadeException e) {
                        foundAt = m.getMark();
                        this.matchMakers.removeElementAt(i);
                        continue;
                    }
                    catch (IOException e) {
                        this.matchMakers.removeElementAt(i);
                    }
                }
                if (b == this.locate[0]) {
                    MatchStream m = new MatchStream(this.locate, this.mark);
                    m.write(b);
                    this.matchMakers.addElement(m);
                }
                ++this.mark;
                if (foundAt >= 0L) {
                    throw new LocatedException(foundAt);
                }
            }

            class MatchStream
            extends OutputStream {
                protected long mark = -1L;
                protected int pos = 0;
                protected byte[] match = null;
                protected boolean matchMade = false;

                MatchStream(byte[] b, long m) {
                    this.mark = m;
                    this.match = b;
                }

                public void write(int b) throws IOException {
                    if (this.matchMade) {
                        return;
                    }
                    if (this.match == null) {
                        throw new IOException("NULL match array");
                    }
                    if (this.match.length == 0) {
                        throw new IOException("Empty match array");
                    }
                    if (this.pos >= this.match.length) {
                        throw new IOException("No match");
                    }
                    if (b != this.match[this.pos]) {
                        throw new IOException("No match");
                    }
                    ++this.pos;
                    if (this.pos >= this.match.length) {
                        this.matchMade = true;
                        throw new MatchMadeException(this.mark);
                    }
                }

                public long getMark() {
                    return this.mark;
                }
            }

            class MatchMadeException
            extends IOException {
                public MatchMadeException(String msg) {
                    super(msg);
                }

                public MatchMadeException(long mark) {
                    super(String.valueOf(mark));
                }
            }
        }

        class LocatedException
        extends IOException {
            public LocatedException(String msg) {
                super(msg);
            }

            public LocatedException(long location) {
                super(String.valueOf(location));
            }
        }
    }
}

