/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app.comp;

import DE.siemens.ad.logo.app.comp.GradientBackgroundPanel;
import DE.siemens.ad.logo.app.comp.HideableToolBar;
import DE.siemens.ad.logo.app.comp.VerticalFlowLayout;
import DE.siemens.ad.logo.app.comp.VerticalJLabel;
import DE.siemens.ad.logo.util.Global;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class BorderPanelPane
extends JPanel
implements ContainerListener {
    public static final Object FLOATING = "floating";
    public static final Color BORDER_TITLE_COLOR = Color.blue;
    public static final Color DIVIDER_COLOR = Color.darkGray;
    public static final Dimension MINIMAL_DIVIDER_DIMENSION = new Dimension(5, 5);
    public static final Border DIVIDER_BORDER = new BevelBorder(0);
    private SplitterPanel fNorthSplitter;
    private SplitterPanel fSouthSplitter;
    private SplitterPanel fWestSplitter;
    private SplitterPanel fEastSplitter;
    private Hashtable fComponent2Constraint;
    private HideableToolBar fToolBar;
    private TitlePanel fTitlePanel;
    protected BorderPanel fResizablePanel;
    protected JPanel fViewPanel;
    private boolean fDragable = true;
    private boolean fBorderPanelVisible = true;
    private JPanel fSplitterPanel;
    private Object fBorderPanelPosition;
    private boolean fResizable = true;
    protected Object fBorderPanelPositionBeforeMaximize;
    protected Dimension fBorderPanelSizeBeforeMinimize;
    protected JComponent fBorderPanelToolbar;
    protected boolean fMaximized;
    protected boolean fMinimized;
    public JPanel fTitlePanelContainer;
    protected boolean fContinousLayout = false;
    protected String fTitle;

    public BorderPanelPane() {
        this("South");
    }

    public BorderPanelPane(Object position) {
        this.setLayout(new BorderLayout());
        this.addContainerListener(this);
        this.fSplitterPanel = new JPanel(new BorderLayout());
        this.fNorthSplitter = new SplitterPanel("North");
        this.fSouthSplitter = new SplitterPanel("South");
        this.fEastSplitter = new SplitterPanel("East");
        this.fWestSplitter = new SplitterPanel("West");
        this.fSplitterPanel.add((Component)this.fNorthSplitter, "North");
        this.fSplitterPanel.add((Component)this.fSouthSplitter, "South");
        this.fSplitterPanel.add((Component)this.fWestSplitter, "West");
        this.fSplitterPanel.add((Component)this.fEastSplitter, "East");
        this.fResizablePanel = new BorderPanel(this);
        this.fTitlePanel = new TitlePanel("North");
        this.fTitlePanelContainer = new JPanel(new BorderLayout());
        this.fTitlePanelContainer.add((Component)this.fTitlePanel, "North");
        this.fTitlePanelContainer.add(this.fResizablePanel);
        this.fSplitterPanel.add(this.fTitlePanelContainer);
        int orientation = 0;
        if (position.equals("East") || position.equals("West")) {
            orientation = 1;
        }
        this.fToolBar = new HideableToolBar(orientation);
        this.fToolBar.setChangeOrientation(false);
        this.fToolBar.setAlwaysOnTop(false);
        this.fToolBar.setFloatingFrameResizable(true);
        this.fToolBar.setLayout(new BorderLayout());
        this.fToolBar.add(this.fSplitterPanel);
        this.add((Component)this.fToolBar, position);
        this.fViewPanel = new JPanel(new BorderLayout());
        this.add((Component)this.fViewPanel, "Center");
        this.setResizable(true);
        this.setDragable(true);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (constraints == null) {
            return;
        }
        boolean borderPanelMoved = comp == this.fToolBar && this.getComponent2Constraint().get(this.fToolBar) != constraints;
        this.getComponent2Constraint().put(comp, constraints);
        super.addImpl(comp, constraints, index);
        if (borderPanelMoved) {
            this.getBorderPanel().fireBorderPanelEvent(3);
        }
    }

    public void closePanel() {
        this.unmaximizeBorderPanel();
        this.setBorderPanelVisible(false);
    }

    public void componentAdded(ContainerEvent ce) {
        Component comp = ce.getChild();
        if (comp == this.fToolBar || comp == this.fSplitterPanel) {
            this.setBorderPanelPosition(this.getConstraint(comp));
            if (this.fBorderPanelToolbar != null) {
                this.getTitlePanel().setToolbarPanel(this.fBorderPanelToolbar);
            }
        }
    }

    public void componentRemoved(ContainerEvent ce) {
        if (ce.getChild() == this.fToolBar) {
            this.setBorderPanelPosition(null);
            JComponent toolbarPanel = this.getTitlePanel().getToolbarPanel();
            if (toolbarPanel != null && this.fToolBar.getFloatingFrame() != null) {
                this.fToolBar.getFloatingFrame().getContentPane().add((Component)toolbarPanel, "North");
            }
        }
    }

    public BorderPanel getBorderPanel() {
        return this.fResizablePanel;
    }

    public Object getBorderPanelPosition() {
        if (this.fBorderPanelPosition == null) {
            return FLOATING;
        }
        return this.fBorderPanelPosition;
    }

    protected Hashtable getComponent2Constraint() {
        if (this.fComponent2Constraint == null) {
            this.fComponent2Constraint = new Hashtable();
        }
        return this.fComponent2Constraint;
    }

    public Object getConstraint(Component comp) {
        return this.getComponent2Constraint().get(comp);
    }

    public String getTitle() {
        return this.fTitle;
    }

    public JPanel getViewPanel() {
        return this.fViewPanel;
    }

    public boolean isBorderPanelVisible() {
        return this.fBorderPanelVisible;
    }

    public boolean isContinousLayout() {
        return this.fContinousLayout;
    }

    public boolean isDragable() {
        return this.fDragable;
    }

    public boolean isMaximized() {
        return this.fMaximized;
    }

    public boolean isMinimized() {
        return this.fMinimized;
    }

    public boolean isResizable() {
        return this.fResizable;
    }

    protected void maximizeBorderPanel() {
        this.fBorderPanelPositionBeforeMaximize = this.getBorderPanelPosition();
        this.removeAll();
        this.add((Component)this.fTitlePanelContainer, "Center");
        String iconButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        String restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        this.fTitlePanel.fMaxButton.setIcon(this.fTitlePanel.getMinimizeIcon());
        this.fTitlePanel.fMinButton.setIcon(this.fTitlePanel.getIconifyIcon());
        this.fTitlePanel.fMaxButton.setToolTipText(restoreButtonToolTip);
        this.fTitlePanel.fMinButton.setToolTipText(iconButtonToolTip);
        this.fTitlePanel.setVisible(true);
        this.fMaximized = true;
        this.validate();
    }

    protected void minimizeBorderPanel() {
        this.setMaximized(false);
        this.fBorderPanelSizeBeforeMinimize = this.fResizablePanel.getPreferredSize();
        this.fResizablePanel.setSize(new Dimension(0, 0));
        String restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        String maxButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
        this.fTitlePanel.fMinButton.setIcon(this.fTitlePanel.getMinimizeIcon());
        this.fTitlePanel.fMaxButton.setIcon(this.fTitlePanel.getMaximizeIcon());
        this.fTitlePanel.fMinButton.setToolTipText(restoreButtonToolTip);
        this.fTitlePanel.fMaxButton.setToolTipText(maxButtonToolTip);
        this.fResizablePanel.invalidate();
        this.validate();
    }

    public void setBorderPanelPosition(Object constraint) {
        this.fBorderPanelPosition = constraint;
        this.setSplitterVisible(constraint);
    }

    public void setBorderPanelVisible(boolean newBorderPanelVisible) {
        if (this.fBorderPanelVisible == newBorderPanelVisible) {
            return;
        }
        this.fBorderPanelVisible = newBorderPanelVisible;
        if (this.isDragable()) {
            this.fToolBar.setVisible(newBorderPanelVisible);
        } else {
            this.fSplitterPanel.setVisible(newBorderPanelVisible);
        }
    }

    public void setContinousLayout(boolean newFContinousLayout) {
        this.fContinousLayout = newFContinousLayout;
    }

    public void setDragable(boolean newDragable) {
        if (this.fDragable == newDragable) {
            return;
        }
        Object borderPanelPosition = this.getBorderPanelPosition();
        this.fDragable = newDragable;
        if (newDragable) {
            this.add((Component)this.fToolBar, borderPanelPosition);
            this.remove(this.fSplitterPanel);
            this.fToolBar.add(this.fSplitterPanel);
        } else {
            this.remove(this.fToolBar);
            this.add((Component)this.fSplitterPanel, borderPanelPosition);
        }
        this.invalidate();
        this.revalidate();
    }

    public void setMaximized(boolean newMaximized) {
        if (this.isMaximized() == newMaximized) {
            return;
        }
        if (newMaximized) {
            this.maximizeBorderPanel();
        } else {
            this.unmaximizeBorderPanel();
        }
    }

    public void setMinimized(boolean newMinimized) {
        if (this.isMinimized() == newMinimized) {
            return;
        }
        if (this.isMaximized()) {
            this.setMaximized(false);
        }
        if (newMinimized) {
            this.minimizeBorderPanel();
        } else {
            this.unminimizeBorderPanel();
        }
        this.fMinimized = newMinimized;
    }

    public void setResizable(boolean newResizeable) {
        this.fResizable = newResizeable;
        this.setSplitterVisible(this.getBorderPanelPosition());
    }

    public void setFloatingBorderPanelAutoResized(boolean autoResized) {
        this.fToolBar.setFloatingFrameAutoResized(autoResized);
    }

    protected void setSplitterVisible(Object constraint) {
        if (!this.fResizable || constraint == null) {
            constraint = "Center";
        }
        this.fNorthSplitter.setVisible(constraint.equals("South"));
        this.fEastSplitter.setVisible(constraint.equals("West"));
        this.fWestSplitter.setVisible(constraint.equals("East"));
        this.fSouthSplitter.setVisible(constraint.equals("North"));
        if (constraint.equals("West") || constraint.equals("East")) {
            this.fTitlePanelContainer.add((Component)this.fTitlePanel, "West");
            this.fTitlePanel.setTitlePosition("West");
        } else {
            this.fTitlePanelContainer.add((Component)this.fTitlePanel, "North");
            this.fTitlePanel.setTitlePosition("North");
        }
        this.fTitlePanel.setVisible(!constraint.equals("Center"));
    }

    public void setTitle(String newTitle) {
        this.fTitle = newTitle;
        this.fTitlePanel.setTitle(newTitle);
        this.fToolBar.setTitle(newTitle);
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.fTitlePanel.setImageIcon(imageIcon);
        this.fToolBar.setImageIcon(imageIcon);
    }

    public void unmaximizeBorderPanel() {
        if (!this.isMaximized()) {
            return;
        }
        this.fSplitterPanel.add((Component)this.fTitlePanelContainer, "Center");
        this.fToolBar.add(this.fSplitterPanel);
        this.removeAll();
        this.add((Component)this.fToolBar, this.fBorderPanelPositionBeforeMaximize);
        this.add((Component)this.fViewPanel, "Center");
        String maxButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
        this.fTitlePanel.fMaxButton.setIcon(this.fTitlePanel.getMaximizeIcon());
        this.fTitlePanel.fMaxButton.setToolTipText(maxButtonToolTip);
        this.fMaximized = false;
        this.validate();
        this.repaint();
    }

    public void setBorderPanelRestoreSize(Dimension d) {
        this.fBorderPanelSizeBeforeMinimize = d;
    }

    public void unminimizeBorderPanel() {
        if (this.fBorderPanelSizeBeforeMinimize == null) {
            return;
        }
        int width = (int)this.fBorderPanelSizeBeforeMinimize.getWidth();
        int height = (int)this.fBorderPanelSizeBeforeMinimize.getHeight();
        String iconButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        this.fMinimized = false;
        this.fResizablePanel.setSize(this.fBorderPanelSizeBeforeMinimize);
        this.fTitlePanel.fMinButton.setIcon(this.fTitlePanel.getIconifyIcon());
        this.fTitlePanel.fMinButton.setToolTipText(iconButtonToolTip);
        this.fResizablePanel.invalidate();
        this.validate();
    }

    public TitlePanel getTitlePanel() {
        return this.fTitlePanel;
    }

    public void setFloatingBorderPanelAlwaysOnTop(boolean alwaysOnTop) {
        if (this.fToolBar != null) {
            this.fToolBar.setAlwaysOnTop(alwaysOnTop);
        }
    }

    public static class BorderPanel
    extends JPanel {
        private boolean fNewlyCreated = true;
        private boolean fOpened = true;
        private int fWidth = 20;
        private int fHeight = 20;
        private int fTempWidth;
        private Vector fBorderPanelListeners;
        private int fTempHeight;
        private BorderPanelPane fBorderPanelPane;

        public BorderPanel(BorderPanelPane borderPanelPane) {
            this.fBorderPanelPane = borderPanelPane;
            this.setLayout(new BorderLayout());
        }

        public Vector getBorderPanelListener() {
            if (this.fBorderPanelListeners == null) {
                this.fBorderPanelListeners = new Vector();
            }
            return this.fBorderPanelListeners;
        }

        public BorderPanelPane getBorderPanelPane() {
            return this.fBorderPanelPane;
        }

        public void setMinimizable(boolean minimizable) {
            this.getTitlePanel().setMinimizable(minimizable);
        }

        public void setMaximizable(boolean maximizable) {
            this.getTitlePanel().setMaximizable(maximizable);
        }

        public void setClosable(boolean closable) {
            this.getTitlePanel().setClosable(closable);
        }

        public String getState() {
            if (this.fBorderPanelPane.isMinimized()) {
                return "minimized";
            }
            if (this.fBorderPanelPane.isMaximized()) {
                return "maximized";
            }
            if (!this.fBorderPanelPane.isBorderPanelVisible()) {
                return "closed";
            }
            return null;
        }

        public void setMaximized(boolean maximized) {
            this.getBorderPanelPane().setMaximized(maximized);
        }

        public void setMinimized(boolean minimized) {
            this.getBorderPanelPane().setMinimized(minimized);
        }

        public void setState(String newState) {
            if (newState.equals("minimized")) {
                this.fBorderPanelPane.setMinimized(true);
            }
            if (newState.equals("maximized")) {
                this.fBorderPanelPane.setMaximized(true);
            }
            if (newState.equals("closed")) {
                this.fBorderPanelPane.setBorderPanelVisible(true);
            }
        }

        public void setTitle(String title) {
            this.fBorderPanelPane.setTitle(title);
        }

        public void setImageIcon(ImageIcon imageIcon) {
            this.fBorderPanelPane.setImageIcon(imageIcon);
        }

        public void addBorderPanelListener(BorderPanelListener bpl) {
            if (!this.getBorderPanelListener().contains(bpl)) {
                this.getBorderPanelListener().add(bpl);
            }
        }

        public void removeBorderPanelListener(BorderPanelListener bpl) {
            this.getBorderPanelListener().remove(bpl);
        }

        private void fireBorderPanelEvent(int type) {
            Vector borderPanelListeners = (Vector)this.getBorderPanelListener().clone();
            Enumeration e = borderPanelListeners.elements();
            BorderPanelListener listener = null;
            while (e.hasMoreElements()) {
                listener = (BorderPanelListener)e.nextElement();
                switch (type) {
                    case 1: {
                        listener.borderPanelOpened(this);
                        break;
                    }
                    case 2: {
                        listener.borderPanelClosed(this);
                        break;
                    }
                    case 3: {
                        listener.borderPanelMoved(this);
                    }
                }
            }
        }

        public JComponent getToolbarPanel() {
            return this.getTitlePanel().getToolbarPanel();
        }

        public void setToolbarPanel(JComponent toolbarPanel) {
            this.getTitlePanel().setToolbarPanel(toolbarPanel);
        }

        public Dimension getPreferredSize() {
            if (this.fBorderPanelPane.isResizable()) {
                Dimension preferredSize = new Dimension(Math.max(0, this.fWidth + this.fTempWidth), Math.max(0, this.fHeight + this.fTempHeight));
                return preferredSize;
            }
            return super.getPreferredSize();
        }

        public void setResizable(boolean resizable) {
            this.fBorderPanelPane.setResizable(resizable);
        }

        public void setDragable(boolean dragable) {
            this.fBorderPanelPane.setDragable(dragable);
        }

        public void setSize(Dimension dim) {
            if (!this.fBorderPanelPane.isMinimized() && !this.fBorderPanelPane.isMaximized()) {
                this.fWidth = dim.width;
                this.fHeight = dim.height;
                this.invalidate();
                this.getParent().getParent().getParent().getParent().validate();
            } else {
                this.fBorderPanelPane.setBorderPanelRestoreSize(dim);
            }
        }

        public void setSize(int width, int height) {
            this.setSize(new Dimension(width, height));
        }

        public void setTemporarySize(Dimension dim) {
            this.setTemporarySize((int)dim.getWidth(), (int)dim.getHeight());
        }

        public void setTemporarySize(int width, int height) {
            this.fTempWidth = width;
            this.fTempHeight = height;
            this.invalidate();
            this.getParent().getParent().getParent().getParent().validate();
        }

        public void startDrag() {
            this.fTempWidth = 0;
            this.fTempHeight = 0;
        }

        public void endDrag() {
            this.fWidth = Math.max(0, this.fWidth + this.fTempWidth);
            this.fHeight = Math.max(0, this.fHeight + this.fTempHeight);
            this.fTempWidth = 0;
            this.fTempHeight = 0;
        }

        public void setVisible(boolean visibility) {
            this.fBorderPanelPane.setBorderPanelVisible(visibility && this.fOpened);
        }

        public void setOpened(boolean opened) {
            if (this.fOpened == opened) {
                return;
            }
            if (this.fBorderPanelPane.isMaximized()) {
                this.fBorderPanelPane.setMaximized(false);
            }
            this.fOpened = opened;
            this.fBorderPanelPane.setBorderPanelVisible(opened);
            int type = opened ? 1 : 2;
            this.fireBorderPanelEvent(type);
        }

        public boolean isOpened() {
            return this.fOpened;
        }

        public TitlePanel getTitlePanel() {
            return this.getBorderPanelPane().getTitlePanel();
        }

        public boolean isNewlyCreated() {
            return this.fNewlyCreated;
        }

        public void setNewlyCreated(boolean newlyCreated) {
            this.fNewlyCreated = newlyCreated;
        }
    }

    protected class SplitterPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        Point clickPoint;
        private Object fPosition;
        private JWindow fMoveWindow;

        public SplitterPanel(Object position) {
            this.fPosition = position;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            if (position.equals("South") || position.equals("North")) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(10));
            }
            if (DIVIDER_COLOR != null) {
                this.setBackground(DIVIDER_COLOR);
            }
            this.setBorder(DIVIDER_BORDER);
        }

        private JWindow getMoveWindow() {
            if (this.fMoveWindow == null) {
                this.fMoveWindow = new JWindow();
                this.fMoveWindow.getContentPane().setBackground(DIVIDER_COLOR);
                this.fMoveWindow.setBackground(DIVIDER_COLOR);
                this.fMoveWindow.setSize(this.getSize());
                this.fMoveWindow.show();
            }
            return this.fMoveWindow;
        }

        public Dimension getPreferredSize() {
            return MINIMAL_DIVIDER_DIMENSION;
        }

        public void mousePressed(MouseEvent me) {
            this.clickPoint = me.getPoint();
            SwingUtilities.convertPointToScreen(this.clickPoint, this);
            BorderPanelPane.this.fResizablePanel.startDrag();
        }

        public void mouseReleased(MouseEvent me) {
            BorderPanelPane.this.fResizablePanel.setTemporarySize(this.getTemporaryResizablePanelSize(me));
            BorderPanelPane.this.fResizablePanel.endDrag();
            this.getMoveWindow().setVisible(false);
            this.fMoveWindow = null;
        }

        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2) {
                BorderPanelPane.this.maximizeBorderPanel();
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public Dimension getMoveVector(MouseEvent me) {
            Point dragPoint = me.getPoint();
            SwingUtilities.convertPointToScreen(dragPoint, this);
            Dimension moveVector = null;
            if (this.fPosition.equals("North") || this.fPosition.equals("South")) {
                if (BorderPanelPane.this.isMinimized()) {
                    BorderPanelPane.this.setMinimized(false);
                    BorderPanelPane.this.fResizablePanel.setSize(new Dimension((int)BorderPanelPane.this.fResizablePanel.getPreferredSize().getWidth(), 0));
                }
                moveVector = new Dimension(0, dragPoint.y - this.clickPoint.y);
            } else {
                if (BorderPanelPane.this.isMinimized()) {
                    BorderPanelPane.this.setMinimized(false);
                    BorderPanelPane.this.fResizablePanel.setSize(new Dimension(0, (int)BorderPanelPane.this.fResizablePanel.getPreferredSize().getHeight()));
                }
                moveVector = new Dimension(dragPoint.x - this.clickPoint.x, 0);
            }
            Rectangle splitterRectangle = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), BorderPanelPane.this);
            moveVector = new Dimension((int)Math.max(Math.min(BorderPanelPane.this.getSize().getWidth() - splitterRectangle.getX() - splitterRectangle.getWidth(), moveVector.getWidth()), -splitterRectangle.getX()), (int)Math.max(Math.min(BorderPanelPane.this.getSize().getHeight() - splitterRectangle.getY() - splitterRectangle.getHeight(), moveVector.getHeight()), -splitterRectangle.getY()));
            return moveVector;
        }

        private Dimension getTemporaryResizablePanelSize(MouseEvent me) {
            int inverted = this.fPosition.equals("North") || this.fPosition.equals("West") ? -1 : 1;
            Dimension tempSize = this.getMoveVector(me);
            return new Dimension((int)tempSize.getWidth() * inverted, (int)tempSize.getHeight() * inverted);
        }

        public void mouseDragged(MouseEvent me) {
            if (BorderPanelPane.this.isContinousLayout()) {
                BorderPanelPane.this.fResizablePanel.setTemporarySize(this.getTemporaryResizablePanelSize(me));
            } else {
                Dimension moveVector = this.getMoveVector(me);
                Point upperLeft = new Point(0, 0);
                SwingUtilities.convertPointToScreen(upperLeft, this);
                this.getMoveWindow().setLocation((int)(upperLeft.getX() + moveVector.getWidth()), (int)(upperLeft.getY() + moveVector.getHeight()));
            }
        }

        public void mouseMoved(MouseEvent me) {
        }
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setVerticalAlignment(0);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return true;
        }

        public Dimension getSize() {
            return new Dimension(16, 15);
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 15);
        }

        public Rectangle getBounds() {
            return new Rectangle(this.getLocation().x, this.getLocation().y, this.getSize().width, this.getSize().height);
        }
    }

    protected class TitlePanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        protected JPanel fButtonPanel;
        protected JPanel fPrivateHeaderPanel;
        private JButton fMinButton;
        private JButton fMaxButton;
        private JButton fCloseButton;
        protected GradientBackgroundPanel fTitleAreaPanel;
        protected JPanel fIconPanel;
        protected JComponent fToolbarPanel;
        protected JLabel fIconLabel;
        protected VerticalJLabel fTitleLabel;
        private int fOrientation;

        public TitlePanel(Object titlePosition) {
            this.setLayout(new BorderLayout(0, 0));
            Color titleBackground = UIManager.getColor("InternalFrame.activeTitleBackground");
            this.setBackground(titleBackground);
            String iconButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
            String restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
            String maxButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
            String closeButtonToolTip = UIManager.getString("InternalFrame.closeButtonToolTip");
            this.fMinButton = new NoFocusButton();
            this.fMinButton.setIcon(this.getIconifyIcon());
            this.fMinButton.setToolTipText(iconButtonToolTip);
            this.fMinButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    BorderPanelPane.this.setMinimized(!BorderPanelPane.this.isMinimized());
                }
            });
            this.fMaxButton = new NoFocusButton();
            this.fMaxButton.setIcon(this.getMaximizeIcon());
            this.fMaxButton.setToolTipText(maxButtonToolTip);
            this.fMaxButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    BorderPanelPane.this.setMaximized(!BorderPanelPane.this.isMaximized());
                }
            });
            this.fCloseButton = new NoFocusButton();
            this.fCloseButton.setIcon(this.getCloseIcon());
            this.fCloseButton.setToolTipText(closeButtonToolTip);
            this.fCloseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    BorderPanelPane.this.fResizablePanel.setOpened(false);
                }
            });
            this.fButtonPanel = new JPanel();
            BoxLayout boxLayout = new BoxLayout(this.fButtonPanel, 0);
            this.fButtonPanel.setLayout(boxLayout);
            this.fButtonPanel.add(Box.createRigidArea(new Dimension(3, 3)));
            this.fButtonPanel.add(this.fMinButton);
            this.fButtonPanel.add(this.fMaxButton);
            this.fButtonPanel.add(Box.createRigidArea(new Dimension(3, 3)));
            this.fButtonPanel.add(this.fCloseButton);
            this.fButtonPanel.add(Box.createRigidArea(new Dimension(3, 3)));
            this.fIconPanel = new JPanel(new BorderLayout());
            this.fIconLabel = new JLabel();
            this.fIconPanel.add((Component)this.fIconLabel, "West");
            this.fIconPanel.setBackground(titleBackground);
            this.add((Component)this.fIconPanel, "West");
            this.fPrivateHeaderPanel = new JPanel(new BorderLayout());
            this.fPrivateHeaderPanel.setBackground(titleBackground);
            this.add((Component)this.fPrivateHeaderPanel, "Center");
            this.fTitleAreaPanel = new GradientBackgroundPanel(new FlowLayout(0, 0, 0));
            this.fTitleAreaPanel.setStartColor(titleBackground);
            this.fTitleAreaPanel.setDestinationColor(this.fButtonPanel.getBackground());
            this.fPrivateHeaderPanel.add((Component)this.fTitleAreaPanel, "Center");
            this.fTitleLabel = new VerticalJLabel();
            Font f = this.fTitleLabel.getFont();
            this.fTitleLabel.setIconTextGap(0);
            this.fTitleLabel.setFont(new Font(f.getName(), 1, 12));
            this.fTitleLabel.setForeground(Color.white);
            this.fTitleAreaPanel.add(this.fTitleLabel);
            this.fToolbarPanel = new JPanel();
            this.fToolbarPanel.setLayout(new BoxLayout(this.fToolbarPanel, 0));
            this.fPrivateHeaderPanel.add((Component)this.fToolbarPanel, "East");
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setTitlePosition(titlePosition);
        }

        private Icon getCloseIcon() {
            Icon closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
            return closeIcon != null ? closeIcon : Global.getIcon("CloseWindow.gif");
        }

        public Icon getMaximizeIcon() {
            Icon maximizedIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            maximizedIcon = Global.getIcon("MaximizeWindow.gif");
            return maximizedIcon;
        }

        public Icon getIconifyIcon() {
            Icon iconify = UIManager.getIcon("InternalFrame.iconifyIcon");
            if (iconify == null || iconify.getClass().getName().indexOf("EmptyFrameIcon") != -1) {
                iconify = Global.getIcon("MinimizeWindow.gif");
            }
            return iconify;
        }

        public Icon getMinimizeIcon() {
            Icon minimize = UIManager.getIcon("InternalFrame.minimizeIcon");
            return minimize != null ? minimize : Global.getIcon("RestoreWindow.gif");
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        public void setTitlePosition(Object titlePanelConstraint) {
            String buttonPanelConstraint = null;
            LayoutManager buttonPanelLayoutManager = null;
            if (titlePanelConstraint.equals("North")) {
                buttonPanelConstraint = "East";
                buttonPanelLayoutManager = new FlowLayout(0, 0, 2);
                this.setOrientation(0);
            } else {
                buttonPanelConstraint = "North";
                buttonPanelLayoutManager = new VerticalFlowLayout(2, 2, 0);
                this.setOrientation(1);
            }
            this.fButtonPanel.setLayout(buttonPanelLayoutManager);
            this.add((Component)this.fButtonPanel, buttonPanelConstraint);
        }

        public void setOrientation(int orientation) {
            this.fTitleAreaPanel.setOrientation(orientation);
            JComponent toolbarPanel = this.getToolbarPanel();
            if (orientation == 0) {
                this.fTitleAreaPanel.setLayout(new FlowLayout(0, 5, 0));
                this.fPrivateHeaderPanel.add((Component)this.fIconPanel, "West");
                this.fPrivateHeaderPanel.add((Component)toolbarPanel, "East");
                toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 0));
                this.fTitleLabel.setVertical(false);
            } else {
                this.fTitleAreaPanel.setLayout(new VerticalFlowLayout(2, 0, 5));
                this.fPrivateHeaderPanel.add((Component)this.fIconPanel, "South");
                this.fPrivateHeaderPanel.add((Component)toolbarPanel, "North");
                toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 1));
                this.fTitleLabel.setVertical(true);
            }
            this.fOrientation = orientation;
        }

        public void mousePressed(MouseEvent me) {
            if (!BorderPanelPane.this.isMaximized()) {
                BorderPanelPane.this.fToolBar.dispatchEvent(me);
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (!BorderPanelPane.this.isMaximized()) {
                BorderPanelPane.this.fToolBar.dispatchEvent(me);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2) {
                if (BorderPanelPane.this.isMaximized()) {
                    BorderPanelPane.this.setMaximized(false);
                } else if (BorderPanelPane.this.isMinimized()) {
                    BorderPanelPane.this.setMinimized(false);
                } else {
                    BorderPanelPane.this.setMaximized(true);
                }
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (!BorderPanelPane.this.isMaximized()) {
                BorderPanelPane.this.fToolBar.dispatchEvent(me);
            }
        }

        public void setMinimizable(boolean minimizable) {
            this.fMinButton.setVisible(minimizable);
        }

        public void setMaximizable(boolean maximizable) {
            this.fMaxButton.setVisible(maximizable);
        }

        public void setClosable(boolean closable) {
            this.fCloseButton.setVisible(closable);
        }

        public void mouseMoved(MouseEvent me) {
        }

        public void setTitle(String newTitle) {
            this.fTitleLabel.setText(newTitle);
        }

        public void setImageIcon(ImageIcon imageIcon) {
            this.fIconLabel.setIcon(imageIcon);
        }

        public int getOrientation() {
            return this.fOrientation;
        }

        public JComponent getToolbarPanel() {
            return this.fToolbarPanel;
        }

        public void setToolbarPanel(JComponent toolbarPanel) {
            if (this.fToolbarPanel == toolbarPanel) {
                return;
            }
            this.fPrivateHeaderPanel.remove(this.fToolbarPanel);
            this.fToolbarPanel = toolbarPanel;
            this.fPrivateHeaderPanel.add((Component)toolbarPanel, "East");
            this.setOrientation(this.getOrientation());
        }
    }

    public static interface BorderPanelListener
    extends EventListener {
        public static final int BORDER_PANEL_OPENED = 1;
        public static final int BORDER_PANEL_CLOSED = 2;
        public static final int BORDER_PANEL_MOVED = 3;

        public void borderPanelClosed(BorderPanel var1);

        public void borderPanelOpened(BorderPanel var1);

        public void borderPanelMoved(BorderPanel var1);
    }
}

