/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.comp.BorderPanelPane;
import DE.siemens.ad.logo.app.comp.ToolBarPanel;
import DE.siemens.ad.logo.util.LogoProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class WindowManager {
    protected JPanel fViewPanel;
    protected JPanel fDesktopPanel;
    protected JComponent fViewPanelContainer;
    protected Hashtable fWindowsDictionary;
    protected Vector fActiveWindows = new Vector(5);

    public WindowManager() {
        this.fDesktopPanel = new JPanel(new BorderLayout());
        this.fViewPanelContainer = this.fDesktopPanel;
        this.fViewPanel = new JPanel(new BorderLayout());
        this.fViewPanelContainer.add(this.fViewPanel);
        this.fWindowsDictionary = new Hashtable();
    }

    public void saveWindowStates() {
        LogoProperties properties = LogoProperties.instance();
        Enumeration e = this.fWindowsDictionary.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object window = this.fWindowsDictionary.get(key);
            Object position = null;
            if (window instanceof BorderPanelPane.BorderPanel) {
                BorderPanelPane.BorderPanel borderPanel = (BorderPanelPane.BorderPanel)window;
                position = borderPanel.getBorderPanelPane().getBorderPanelPosition();
                String state = borderPanel.getState();
                if (state != null) {
                    properties.setProperty("windowManager.state." + key, state);
                }
            }
            if (window instanceof ToolBarPanel) {
                position = ((ToolBarPanel)window).getToolBarPosition();
            }
            properties.setProperty("windowManager.position." + key, (String)position);
        }
    }

    protected Object getPositionFromPropertyFile(String windowId, Object defaultPosition) {
        if (!System.getProperty("java.version").startsWith("1.4")) {
            return defaultPosition;
        }
        return LogoProperties.instance().getProperty("windowManager.position." + windowId, (String)defaultPosition);
    }

    protected void restoreStateFromPropertyFile(String windowId, BorderPanelPane.BorderPanel borderPanel) {
        String state = LogoProperties.instance().getProperty("windowManager.state." + windowId);
        if (state != null) {
            borderPanel.setState(state);
        }
    }

    public void closeAllWindows() {
        Enumeration e = this.getActiveWindows().elements();
        while (e.hasMoreElements()) {
            ((JComponent)this.fWindowsDictionary.get(e.nextElement())).setVisible(false);
        }
        this.getActiveWindows().clear();
    }

    public Vector getActiveWindows() {
        if (this.fActiveWindows == null) {
            this.fActiveWindows = new Vector(5);
        }
        return this.fActiveWindows;
    }

    public BorderPanelPane.BorderPanel getBorderPanel(String id, Object position) {
        if (this.fWindowsDictionary.containsKey(id)) {
            this.fActiveWindows.add(id);
            BorderPanelPane.BorderPanel panel = (BorderPanelPane.BorderPanel)this.fWindowsDictionary.get(id);
            panel.setVisible(true);
            panel.setNewlyCreated(false);
            return panel;
        }
        if ((position = this.getPositionFromPropertyFile(id, position)).equals(BorderPanelPane.FLOATING)) {
            position = "North";
        }
        BorderPanelPane borderPanelPane = new BorderPanelPane(position);
        this.fViewPanelContainer.add((Component)borderPanelPane, "Center");
        this.fViewPanelContainer = borderPanelPane.getViewPanel();
        this.fViewPanelContainer.add(this.fViewPanel);
        this.fWindowsDictionary.put(id, borderPanelPane.getBorderPanel());
        this.getActiveWindows().add(id);
        this.restoreStateFromPropertyFile(id, borderPanelPane.getBorderPanel());
        borderPanelPane.setVisible(true);
        return borderPanelPane.getBorderPanel();
    }

    public boolean isWindowCreated(String id) {
        return this.fWindowsDictionary.containsKey(id);
    }

    public BorderPanelPane.BorderPanel getBorderPanel(String id, Object position, Dimension size) {
        BorderPanelPane.BorderPanel borderPanel = this.getBorderPanel(id, position);
        if (borderPanel.isNewlyCreated()) {
            borderPanel.setSize(size);
        }
        return borderPanel;
    }

    public JComponent getDesktopPanel() {
        return this.fDesktopPanel;
    }

    public JComponent getToolbarPanel(String id, Object position) {
        if (this.fWindowsDictionary.containsKey(id)) {
            this.fActiveWindows.add(id);
            JComponent toolbarPanel = (JComponent)this.fWindowsDictionary.get(id);
            toolbarPanel.setVisible(true);
            return toolbarPanel;
        }
        position = this.getPositionFromPropertyFile(id, position);
        ToolBarPanel toolBarPanel = new ToolBarPanel(position);
        this.fViewPanelContainer.add((Component)toolBarPanel, "Center");
        this.fViewPanelContainer = toolBarPanel;
        this.fViewPanelContainer.add((Component)this.fViewPanel, "Center");
        this.fWindowsDictionary.put(id, toolBarPanel);
        this.getActiveWindows().add(id);
        toolBarPanel.setVisible(true);
        return toolBarPanel;
    }

    public JComponent getViewPanel() {
        return this.fViewPanel;
    }
}

