/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.StatusLine;
import DE.siemens.ad.logo.app.WindowManager;
import DE.siemens.ad.logo.app.action.LogoJMenuBar;
import DE.siemens.ad.logo.comm.Modem;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.app.LogoHelp;
import DE.siemens.ad.pdraw.util.LogoComfortStatusLine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ApplicationSurface
extends JPanel {
    protected WindowManager fWindowManager;
    protected Editor fEditor;
    private DropTarget fDropTarget;
    protected Application fApplication;
    protected JFrame fWindow;
    protected StatusLine fStatusLine;

    protected ApplicationSurface() {
    }

    public ApplicationSurface(Application application, String title) {
        this.fWindow = new JFrame();
        this.fWindow.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(18, 8, false), "repaint");
        this.fWindow.setDefaultCloseOperation(0);
        Object dynamicLayoutSupported = Toolkit.getDefaultToolkit().getDesktopProperty("awt.dynamicLayoutSupported");
        if (dynamicLayoutSupported instanceof Boolean && ((Boolean)dynamicLayoutSupported).booleanValue()) {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
        }
        this.fWindow.setTitle(title);
        this.fWindow.setName(title);
        this.fWindow.setContentPane(this);
        DragAndDropHandler dragAndDropHandler = new DragAndDropHandler();
        this.fDropTarget = new DropTarget(this.fWindow, dragAndDropHandler);
        this.fDropTarget = new DropTarget(this, dragAndDropHandler);
        this.fApplication = application;
        this.fWindowManager = new WindowManager();
        this.setBackground(Global.BACKGROUND_COLOR_APP);
        this.setLayout(new BorderLayout());
        try {
            Map.ID homeID = LogoHelp.getHelpSet().getHomeID();
            if (homeID == null) {
                new LogoError(this, "Internal error in Helpfile. No homeID defined").display();
            } else {
                LogoHelp.getHelpBroker().enableHelpKey((Component)this.fWindow.getRootPane(), homeID.id, null);
            }
        }
        catch (ProgramException e) {
            e.display(null, null);
        }
    }

    public Window getWindow() {
        return this.fWindow;
    }

    public WindowManager getWindowManager() {
        return this.fWindowManager;
    }

    public void setEditor(Editor editor) {
        if (editor == this.fEditor && editor != null) {
            return;
        }
        if (this.fEditor != null) {
            this.fEditor.deactivate();
        }
        if (this.getJMenuBar() instanceof LogoJMenuBar) {
            ((LogoJMenuBar)this.getJMenuBar()).closeAllMenus();
        }
        this.setVisible(false);
        this.fEditor = editor;
        this.removeAll();
        if (editor != null) {
            this.fStatusLine = editor.getStatusLine();
            this.setJMenuBar(editor.getMenuManager().getMenuBar(null));
            this.fWindowManager.getViewPanel().removeAll();
            this.fWindowManager.getViewPanel().add(this.fApplication.getMdiManager().getMDIComponent(editor.getView()));
            this.fWindowManager.closeAllWindows();
            editor.activate(this);
            this.setVisible(true);
        } else {
            Editor defaultEditor = this.fApplication.getDefaultEditor();
            this.fStatusLine = new LogoComfortStatusLine();
            if (defaultEditor != null) {
                defaultEditor.setApplication(this.fApplication);
                defaultEditor.setApplicationSurface(this);
                defaultEditor.getMenuManager().getDefaultActionGroup(this.fApplication.getMenuManager().getMenuActionGroup(null));
                this.setJMenuBar(this.fApplication.getMenuManager().getMenuBar(null));
                this.fWindowManager.closeAllWindows();
                JComponent standardToolBarPanel = this.getWindowManager().getToolbarPanel("Standard", "North");
                standardToolBarPanel.add(defaultEditor.getMenuManager().getDefaultToolBar(this.fApplication.getToolbarActionGroup()));
            } else {
                this.fApplication.getMenuManager().getMenuActionGroup(null);
                this.setJMenuBar(this.fApplication.getMenuManager().getMenuBar(null));
                this.fWindowManager.closeAllWindows();
                JComponent standardToolBarPanel = this.getWindowManager().getToolbarPanel("Standard", "North");
                standardToolBarPanel.add(this.fApplication.getMenuManager().getToolBar(null));
            }
            this.fWindowManager.getViewPanel().removeAll();
            this.fWindowManager.getViewPanel().add(this.fApplication.getMdiManager().getMDIComponent(null));
        }
        if (this.fStatusLine != null) {
            this.add((Component)this.fStatusLine, "South");
            if (this.fStatusLine instanceof LogoComfortStatusLine) {
                ((LogoComfortStatusLine)this.fStatusLine).setModemStatus(Modem.getModemStatus());
            }
        }
        this.add(this.fWindowManager.getDesktopPanel());
        this.setVisible(true);
        this.validate();
        this.repaint();
    }

    public JMenuBar getJMenuBar() {
        return this.fWindow.getJMenuBar();
    }

    public void setJMenuBar(JMenuBar menuBar) {
        this.fWindow.setJMenuBar(menuBar);
    }

    public void setTitle(String title) {
        this.fWindow.setTitle(title);
    }

    public String getTitle() {
        return this.fWindow.getTitle();
    }

    public void setIconImage(Image iconImage) {
        this.fWindow.setIconImage(iconImage);
    }

    public Editor getEditor() {
        return this.fEditor;
    }

    public DropTarget getDropTarget() {
        return this.fDropTarget;
    }

    public StatusLine getStatusLine() {
        return this.fStatusLine;
    }

    protected class DragAndDropHandler
    implements DropTargetListener {
        protected DragAndDropHandler() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDragEvent.acceptDrag(3);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable tr = dropTargetDropEvent.getTransferable();
                if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                    if (!fileList.isEmpty()) {
                        ApplicationSurface.this.getWindow().toFront();
                    }
                    dropTargetDropEvent.dropComplete(true);
                    for (File file : fileList) {
                        ApplicationSurface.this.fApplication.loadDocument(file);
                    }
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

