/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import DE.siemens.ad.logo.app.ActionOwner;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.EditorInfo;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionGroup;
import DE.siemens.ad.logo.app.action.FileHistoryActionGroup;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.action.NewNamedEditorAction;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoHelp;
import java.util.Enumeration;
import java.util.Hashtable;

public class ApplicationMenuManager
extends MenuManager {
    public static final String HELP_GROUP = "help.group";
    public static final String HELP_TRACKING_ACTION = "help.tracking";
    public static final String FILE_HISTORY_GROUP = "filehistory.group";
    public static final String FILE_GROUP = "file.group";
    public static final String FILE_EXIT_GROUP = "file.exit.group";
    public static final String FILE_OPEN_GROUP = "file.open.group";
    public static final String FILE_DRAWING_GROUP = "file.drawing.group";
    protected FileHistoryActionGroup fFileHistoryGroup;

    public ApplicationMenuManager(ActionOwner actionOwner) {
        super(actionOwner);
    }

    public ActionGroup buildDefaultActionGroup(ActionGroup baseActionGroup) {
        return baseActionGroup;
    }

    protected ActionGroup buildDefaultToolBarActionGroup(ActionGroup actionGroup) {
        return actionGroup;
    }

    public ActionGroup buildMenuActionGroup(ActionGroup actionGroup) {
        ActionFactory actionFactory = this.getActionOwner().getActionFactory();
        ActionGroup menuGroup = new ActionGroup();
        ActionGroup fileGroup = new ActionGroup(FILE_GROUP);
        fileGroup.setFlatMenu(false);
        fileGroup.putValue("textKey", "file.base");
        ActionGroup newOpenGroup = new ActionGroup(FILE_OPEN_GROUP);
        newOpenGroup.setFlatMenu(true);
        newOpenGroup.addAction(this.getNewActionGroup());
        newOpenGroup.addAction(actionFactory.getAction("OpenAction"));
        fileGroup.addAction(newOpenGroup);
        fileGroup.addAction(this.getFileHistoryGroup());
        menuGroup.addAction(fileGroup);
        menuGroup.addAction(this.createHelpGroup());
        ActionGroup exitGroup = new ActionGroup(FILE_EXIT_GROUP);
        exitGroup.setFlatMenu(true);
        exitGroup.addAction(actionFactory.getAction("ExitAction"));
        fileGroup.addAction(exitGroup);
        return menuGroup;
    }

    public ActionGroup buildToolBarActionGroup(ActionGroup actionGroup) {
        ActionFactory actionFactory = this.getActionOwner().getActionManager().getActionFactory();
        ActionGroup toolBarGroup = new ActionGroup(FILE_OPEN_GROUP);
        toolBarGroup.setFlatToolbar(true);
        toolBarGroup.addAction(this.getNewActionGroup());
        toolBarGroup.addAction(this.getFileHistoryGroup());
        LogoAction showHelpTrackingAction = actionFactory.getAction("ShowHelpTrackingAction");
        toolBarGroup.addAction(showHelpTrackingAction);
        return toolBarGroup;
    }

    public ActionGroup getNewActionGroup() {
        ActionFactory actionFactory = this.getActionOwner().getActionFactory();
        ActionGroup newActionGroup = new ActionGroup();
        newActionGroup.setOwner(this.getActionOwner());
        newActionGroup.setFlatMenu(false);
        newActionGroup.setFlatToolbar(false);
        newActionGroup.setDefaultAction(actionFactory.getAction("NewAction"));
        newActionGroup.putValue("Name", "Neu");
        newActionGroup.putValue("textKey", "file.new");
        newActionGroup.putValue("SmallIcon", Global.getIcon("New.gif"));
        Application application = Application.getInstance();
        Enumeration editorInfos = application.getEditorInfos().elements();
        while (editorInfos.hasMoreElements()) {
            NewNamedEditorAction nnea = new NewNamedEditorAction();
            nnea.setOwner(this.getActionOwner());
            nnea.setEditorInfo((EditorInfo)editorInfos.nextElement());
            newActionGroup.addAction(nnea);
        }
        return newActionGroup;
    }

    public Hashtable createDefaultPopupMenuAllocation() {
        return new Hashtable();
    }

    protected ActionGroup createHelpGroup() {
        ActionFactory actionFactory = this.getActionOwner().getActionManager().getActionFactory();
        ActionGroup helpGroup = new ActionGroup(HELP_GROUP);
        helpGroup.setFlatMenu(false);
        helpGroup.putValue("textKey", "help.base");
        LogoAction action = actionFactory.getAction("ShowHelpContextAction", "Menue.ShowHelpContextAction");
        action.putValue("textKey", "help.content");
        action.setActivated(LogoHelp.isAvailable());
        helpGroup.addAction(action);
        action = actionFactory.getAction("ShowHelpTrackingAction");
        action.setActivated(LogoHelp.isAvailable());
        helpGroup.addAction(action);
        helpGroup.setActivated(LogoHelp.isAvailable());
        Boolean updateCenterAvailable = new Boolean(Language.getString("updateCenterAvailable", "false"));
        if (updateCenterAvailable.booleanValue()) {
            helpGroup.addAction(actionFactory.getAction("ShowUpdateWizardAction"));
        }
        ActionGroup aboutGroup = new ActionGroup();
        aboutGroup.setFlatMenu(true);
        aboutGroup.addAction(actionFactory.getAction("ShowHelpAboutAction"));
        helpGroup.addAction(aboutGroup);
        ActionGroup debugGroup = new ActionGroup();
        debugGroup.setFlatMenu(true);
        debugGroup.addAction(actionFactory.getAction("BeanshellAction"));
        return helpGroup;
    }

    public FileHistoryActionGroup getFileHistoryGroup() {
        if (this.fFileHistoryGroup == null) {
            ActionFactory actionFactory = this.getActionOwner().getActionFactory();
            this.fFileHistoryGroup = new FileHistoryActionGroup(FILE_HISTORY_GROUP);
            this.fFileHistoryGroup.setOwner(this.getActionOwner());
            this.fFileHistoryGroup.setFlatMenu(true);
            this.fFileHistoryGroup.setFlatToolbar(false);
            this.fFileHistoryGroup.setDefaultAction(actionFactory.getAction("OpenAction"));
            this.fFileHistoryGroup.loadHistory();
        }
        return this.fFileHistoryGroup;
    }

    public void setFileHistoryGroup(FileHistoryActionGroup newFileHistoryGroup) {
        this.fFileHistoryGroup = newFileHistoryGroup;
    }
}

