/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.panel;

import DE.siemens.ad.kop.app.LogoDrawingKOP;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.dialog.BlockSelectionPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.BlockParameterPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolTip;

public abstract class LadderDiagramPanel
extends BlockParameterPanel
implements BlockSelectionPanel.BlockSelectionListener {
    protected BlockSelectionPanel fBlockSelectionPanel;
    private JTextArea fNumberChangeHelpText;

    public LadderDiagramPanel() {
    }

    public LadderDiagramPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.setLayout(new BorderLayout());
        try {
            LogoDrawingKOP drawing = (LogoDrawingKOP)Application.getInstance().getMdiManager().getActiveTopLevelView().getModel();
            this.fBlockSelectionPanel = new BlockSelectionPanel(null, drawing);
        }
        catch (Exception e) {
            this.fBlockSelectionPanel = new BlockSelectionPanel();
        }
        this.add((Component)this.fBlockSelectionPanel, "Center");
    }

    public void selectionGained(Block selectedBlock) {
        String s = selectedBlock.getNumberString();
        this.getNumberChangeHelpText().setText(Language.getString("blockNumberChangePanel.blockChangeHelpText", "All changes refer to the original block.\nSee dialog title!", s));
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public void selectionLost(Block selectedBlock) throws PropertyVetoException {
    }

    public void setLabels() {
        this.fBlockSelectionPanel.setLabels();
    }

    public boolean checkFieldContents() {
        return this.fBlockSelectionPanel.checkFieldContents();
    }

    protected JTextArea getNumberChangeHelpText() {
        if (this.fNumberChangeHelpText == null) {
            this.fNumberChangeHelpText = new JTextArea();
            this.fNumberChangeHelpText.setText(Language.getString("blockNumberChangePanel.blockChangeHelpText", "All changes refer to the original block.\nSee dialog title!"));
            this.fNumberChangeHelpText.setLineWrap(true);
            this.fNumberChangeHelpText.setWrapStyleWord(true);
            this.fNumberChangeHelpText.setEditable(false);
            this.fNumberChangeHelpText.setBackground(new JToolTip().getBackground());
            JScrollPane fNumberChangeHelpPane = new JScrollPane(this.fNumberChangeHelpText);
            this.add((Component)fNumberChangeHelpPane, "South");
        }
        return this.fNumberChangeHelpText;
    }
}

