/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.NegativContactBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.kop.model.kopfupcompiler.OperatorNode;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.XorBlock;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class XorNode
extends OperatorNode {
    private Hashtable fKopBlocks = new Hashtable();

    public Block compileToFup(WiringDiagram wd, CompilerKopToFup compiler) {
        if (this.fFupBlock == null) {
            this.fFupBlock = new XorBlock(wd);
            wd.insert(this.fFupBlock);
            this.connectFupBlockWithChildren(this.fFupBlock, wd, compiler);
        }
        return this.fFupBlock;
    }

    public List compileToKop(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        String prevBlocksString = this.getPreviousBlocksString(prevBlocks);
        prevBlocksString = "egal";
        if (!this.fKopBlocks.containsKey(prevBlocksString)) {
            if (this.isInverted()) {
                throw new IllegalStateException("XOR-Node ist invertiert! Dies ist noch nicht implementiert!");
            }
            ArrayList<ContactBlock> result = prevBlocks;
            ArrayList<ContactBlock> xorContacts = new ArrayList<ContactBlock>(2);
            ArrayList xorNegContacts = new ArrayList(2);
            if (this.getChildCount() > 0) {
                Iterator children = this.children();
                BooleanExpressionNode child = null;
                while (children.hasNext()) {
                    child = (BooleanExpressionNode)children.next();
                    List blocks = child.getCompiledKopBlock(prevBlocks, this, wd, compiler);
                    blocks = this.handleNegation(blocks, wd, compiler);
                    CoilBlock coil = compiler.setInternMarkerCoil(wd, blocks);
                    xorContacts.add(new ContactBlock(wd, coil));
                }
            }
            if (xorContacts.size() == 2) {
                ContactBlock xorContact0 = (ContactBlock)xorContacts.get(0);
                ContactBlock xorContact1 = (ContactBlock)xorContacts.get(1);
                wd.insert(xorContact0);
                wd.insert(xorContact1);
                ContactBlock xorNegContact0 = this.getNegativContact(wd, xorContact0);
                ContactBlock xorNegContact1 = this.getNegativContact(wd, xorContact1);
                wd.insert(xorNegContact0);
                wd.insert(xorNegContact1);
                xorContact0.getOutConnector(0).connect(xorNegContact1.getInConnector(0));
                xorNegContact0.getOutConnector(0).connect(xorContact1.getInConnector(0));
                result = new ArrayList<ContactBlock>();
                result.add(xorNegContact1);
                result.add(xorContact1);
            }
            if (xorContacts.size() == 1) {
                result.clear();
                result.add((ContactBlock)xorContacts.get(0));
            }
            this.fKopBlocks.put(prevBlocksString, result);
        }
        return (List)this.fKopBlocks.get(prevBlocksString);
    }

    public ContactBlock getNegativContact(WiringDiagram wd, ContactBlock contact) {
        NegativContactBlock negContact = new NegativContactBlock(wd);
        negContact.connectToValueSource(contact.getReferencedOutConnector());
        return negContact;
    }

    public void addChildNode(BooleanExpressionNode child) {
        super.addChildNode(child);
        child.setInternMarkerForced(true);
    }
}

