/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.kop.model.kopfupcompiler.NotConnectedNode;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import java.util.ArrayList;
import java.util.List;

public class SpecialFunctionNode
extends BooleanExpressionNode {
    public SpecialFunctionNode() {
    }

    public SpecialFunctionNode(Block block) {
        this.fKopBlock = block;
    }

    public Block getKopBlock() {
        return this.fKopBlock;
    }

    public Block compileToFup(WiringDiagram wd, CompilerKopToFup compiler) {
        if (this.fFupBlock == null) {
            this.fFupBlock = wd.getBlockByNumber(this.fKopBlock.getNumberType(), this.fKopBlock.getNumber());
            this.connectFupBlockWithChildren(this.fFupBlock, wd, compiler);
            compiler.getBlockTranslationDict().put(this.fKopBlock, this.fFupBlock);
        }
        return this.fFupBlock;
    }

    public List compileToKop(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        ArrayList<ContactBlock> result = new ArrayList<ContactBlock>();
        if (!wd.contains(this.fKopBlock)) {
            this.fKopBlock.removeAllListener();
            wd.insert(this.fKopBlock);
            compiler.getBlockTranslationDict().put(this.fFupBlock, this.fKopBlock);
            InBlockConnector[] inConnectors = this.fKopBlock.getInConnectors();
            int nrOfChilds = this.getChildCount();
            ArrayList v = new ArrayList();
            for (int i = 0; i < nrOfChilds; ++i) {
                if (this.getChildAt(i) instanceof NotConnectedNode) continue;
                List blocks = this.getChildAt(i).getCompiledKopBlock(v, this, wd, compiler);
                inConnectors[i].disconnectAll();
                compiler.connect(inConnectors[i], blocks);
            }
        }
        ContactBlock contactBlock = new ContactBlock(wd, this.fKopBlock);
        wd.insert(contactBlock);
        compiler.connect(contactBlock.getInConnector(0), prevBlocks);
        result.add(contactBlock);
        return result;
    }

    public void setFupBlock(Block block) {
        super.setFupBlock(block);
        this.fKopBlock = this.fFupBlock.deepCopy();
        InBlockConnector[] inConnectors = this.fKopBlock.getInConnectors();
        for (int i = 0; i < inConnectors.length; ++i) {
            if (!inConnectors[i].isNegated()) continue;
            inConnectors[i].setNegated(false);
        }
    }

    public ContactBlock getContactBlock(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        prevBlocks = this.compileToKop(prevBlocks, this, wd, compiler);
        return (ContactBlock)prevBlocks.get(0);
    }
}

