/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.Compiler;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;
import java.util.ArrayList;
import java.util.List;

public class InputNode
extends BooleanExpressionNode
implements Cloneable {
    private InputBlock inputBlockTemplate = new InputBlock();
    private String descriptor;

    public InputNode() {
    }

    public InputNode(ContactBlock contactBlock) {
        this.setDescriptor(contactBlock.getNumberString());
        this.fKopBlock = contactBlock.getReferencedOutConnector().getOwner();
    }

    public boolean equals(Object o) {
        if (!(o instanceof InputNode)) {
            return false;
        }
        return ((InputNode)o).getDescriptor().equals(this.getDescriptor());
    }

    protected Block createKopBlock(Compiler compiler) {
        ContactBlock contactBlock = new ContactBlock();
        compiler.getBlockTranslationDict().put(this.fFupBlock, contactBlock);
        contactBlock.connectToValueSource(this.fFupBlock.getOutConnector(0));
        return contactBlock;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Block compileToFup(WiringDiagram wd, CompilerKopToFup compiler) {
        if (this.fFupBlock == null) {
            this.fFupBlock = this.fKopBlock.deepCopy();
            wd.insert(this.fFupBlock);
            compiler.getBlockTranslationDict().put(this.fKopBlock, this.fFupBlock);
        }
        return this.fFupBlock;
    }

    protected List compileToKop(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        ContactBlock contactBlock = (ContactBlock)this.createKopBlock(compiler);
        wd.insert(contactBlock);
        if (prevBlocks != null) {
            compiler.connect(contactBlock.getInConnector(0), prevBlocks);
        }
        ArrayList<ContactBlock> v = new ArrayList<ContactBlock>(1);
        v.add(contactBlock);
        return v;
    }

    public void setFupBlock(Block block) {
        super.setFupBlock(block);
        this.setDescriptor(block.getNumberString());
    }

    public void setDescriptor(String newDescriptor) {
        this.descriptor = newDescriptor;
    }

    public ContactBlock getContactBlock(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        prevBlocks = this.compileToKop(prevBlocks, this, wd, compiler);
        return (ContactBlock)prevBlocks.get(0);
    }
}

