/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.app.ConvertToFupAction;
import DE.siemens.ad.kop.model.LeftPowerRailBlock;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.AnalogContactBlock;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.InternMarkerBlock;
import DE.siemens.ad.kop.model.block.NegativCoilBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.AndNode;
import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.Compiler;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerException;
import DE.siemens.ad.kop.model.kopfupcompiler.HighNode;
import DE.siemens.ad.kop.model.kopfupcompiler.InputNode;
import DE.siemens.ad.kop.model.kopfupcompiler.LowNode;
import DE.siemens.ad.kop.model.kopfupcompiler.NandPatternMatcher;
import DE.siemens.ad.kop.model.kopfupcompiler.NodePatternMatcher;
import DE.siemens.ad.kop.model.kopfupcompiler.NorPatternMatcher;
import DE.siemens.ad.kop.model.kopfupcompiler.NotConnectedNode;
import DE.siemens.ad.kop.model.kopfupcompiler.NotNode;
import DE.siemens.ad.kop.model.kopfupcompiler.OrNode;
import DE.siemens.ad.kop.model.kopfupcompiler.OutputNode;
import DE.siemens.ad.kop.model.kopfupcompiler.SpecialFunctionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.XorPatternMatcher;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.HighBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.LowBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.VirtualOutputBlock;
import DE.siemens.ad.logo.util.MessageLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class CompilerKopToFup
extends Compiler {
    private List fOptimizablePatterns = new ArrayList(3);
    private Hashtable fKopFupBlockDict;
    private boolean fUseHardwareDependendOptimization = false;
    private int fBaseBlockInConnectorCount;
    private transient WiringDiagramKop fWdKop = null;
    private transient WiringDiagram fWdFup = null;
    private Hashtable outConnectorToNodeDict;
    private Hashtable fInputBlocksToNodeDict;
    private Hashtable negativeInputBlocksToNodeDict;
    private transient boolean fCompilerActivated = true;
    private Hashtable fOrNodeDict;

    public CompilerKopToFup() {
        this.fOptimizablePatterns.add(new XorPatternMatcher());
        this.fOptimizablePatterns.add(new NandPatternMatcher());
        this.fOptimizablePatterns.add(new NorPatternMatcher());
    }

    public CompilerKopToFup(WiringDiagramKop wdKop) {
        this();
        this.fWdKop = wdKop;
        Hardware hw = wdKop.getHardware();
        if (hw != null) {
            this.setUseHardwareDependendOptimization(hw.supports("negatableInputs"));
        }
    }

    private BooleanExpressionNode createAndNode(ContactBlock contactBlock) {
        AndNode andNode = null;
        BooleanExpressionNode inputNode = this.getInputNodeForContact(contactBlock);
        BooleanExpressionNode previousNode = null;
        if (contactBlock.getInConnectorCount() > 0) {
            previousNode = this.getBooleanExpressionNode(contactBlock.getInConnector(0));
        }
        if (!(contactBlock instanceof AnalogContactBlock) && previousNode == null) {
            ConvertToFupAction.notifyLowBlockCreated();
            return new LowNode();
        }
        if (contactBlock instanceof AnalogContactBlock || previousNode instanceof HighNode) {
            return inputNode;
        }
        if (previousNode instanceof AndNode && !previousNode.isIntermediateResult() && previousNode.getChildCount() < this.fBaseBlockInConnectorCount) {
            andNode = (AndNode)previousNode;
        } else {
            andNode = new AndNode();
            andNode.addChildNode(previousNode);
        }
        if (contactBlock.getOutConnector(0).getLinkedConnectorsCount() > 1) {
            andNode.setIntermediateResult(true);
        }
        andNode.addChildNode(inputNode);
        return andNode;
    }

    private OutputNode createOutputNode(CoilBlock coilBlock) {
        OutputNode outputNode = new OutputNode(coilBlock);
        this.outConnectorToNodeDict.put(coilBlock.getOutConnector(0), outputNode);
        BooleanExpressionNode previousExpression = this.getBooleanExpressionNode(coilBlock.getInConnector(0));
        if (previousExpression != null) {
            outputNode.addChildNode(previousExpression);
        }
        return outputNode;
    }

    private SpecialFunctionNode createSpecialFunctionNode(Block specialBlock) {
        SpecialFunctionNode specialNode = new SpecialFunctionNode(specialBlock);
        Block fupBlock = specialBlock.deepCopy();
        this.fWdFup.insert(fupBlock);
        this.outConnectorToNodeDict.put(specialBlock.getOutConnector(0), specialNode);
        for (int i = 0; i < specialBlock.getInConnectorCount(); ++i) {
            if (specialBlock.getInConnector(i) instanceof ParameterInBlockConnector) continue;
            BooleanExpressionNode previousExpression = this.getBooleanExpressionNode(specialBlock.getInConnector(i));
            if (previousExpression != null) {
                specialNode.addChildNode(previousExpression);
                continue;
            }
            specialNode.addChildNode(new NotConnectedNode());
        }
        return specialNode;
    }

    private BooleanExpressionNode getBooleanExpressionNode(InBlockConnector ibc) {
        if (ibc.getLinkedConnectorCount() == 0) {
            return null;
        }
        OutBlockConnector firstPreviousConnector = ibc.getLinkedConnectors().nextElement();
        if (this.fOrNodeDict.containsKey(firstPreviousConnector)) {
            return (OrNode)this.fOrNodeDict.get(firstPreviousConnector);
        }
        List allPreviousConnectors = firstPreviousConnector.findParallelOutBlockConnectors();
        allPreviousConnectors.add(0, firstPreviousConnector);
        allPreviousConnectors = this.optimizeOutConnectorList(allPreviousConnectors);
        if (allPreviousConnectors.size() == 1) {
            return this.getBooleanExpressionNode((OutBlockConnector)allPreviousConnectors.get(0));
        }
        OrNode orNode = new OrNode();
        Iterator obce = allPreviousConnectors.iterator();
        int operandCount = 0;
        while (obce.hasNext()) {
            if (operandCount + 1 > this.fBaseBlockInConnectorCount) {
                OrNode newOrNode = new OrNode();
                ((BooleanExpressionNode)newOrNode).addChildNode(orNode);
                orNode = newOrNode;
                operandCount = 1;
            }
            ++operandCount;
            OutBlockConnector previousOutBlockConnector = (OutBlockConnector)obce.next();
            ((BooleanExpressionNode)orNode).addChildNode(this.getBooleanExpressionNode(previousOutBlockConnector));
        }
        obce = allPreviousConnectors.iterator();
        Object key = null;
        while (obce.hasNext()) {
            key = obce.next();
            this.fOrNodeDict.put(key, orNode);
        }
        return orNode;
    }

    private List optimizeOutConnectorList(List outConnectors) {
        ArrayList optimizedConnectors = new ArrayList(outConnectors);
        for (OutBlockConnector toTest : outConnectors) {
            for (OutBlockConnector startPoint : outConnectors) {
                if (startPoint == toTest || !this.isPredecessor(toTest, startPoint)) continue;
                optimizedConnectors.remove(startPoint);
            }
        }
        return optimizedConnectors;
    }

    private boolean isPredecessor(OutBlockConnector toTest, OutBlockConnector startPoint) {
        boolean isPredecessor = false;
        if (toTest == startPoint) {
            isPredecessor = true;
        } else {
            Block block = startPoint.getOwner();
            int inConnectorCount = block.getInConnectorCount();
            for (int i = 0; i < inConnectorCount && !isPredecessor; ++i) {
                OutBlockConnectorEnumeration outBlockConnectors = block.getInConnector(i).getLinkedConnectors();
                while (outBlockConnectors.hasMoreElements() && !isPredecessor) {
                    OutBlockConnector outBlockConnector = outBlockConnectors.nextElement();
                    isPredecessor = this.isPredecessor(toTest, outBlockConnector);
                }
            }
        }
        return isPredecessor;
    }

    private BooleanExpressionNode getBooleanExpressionNode(OutBlockConnector obc) {
        Block block = obc.getOwner();
        if (!this.outConnectorToNodeDict.containsKey(obc)) {
            BooleanExpressionNode andNode;
            if (obc.getOwner() instanceof ContactBlock && (andNode = this.createAndNode((ContactBlock)block)) != null) {
                this.outConnectorToNodeDict.put(obc, andNode);
            }
            if (this.fWdKop.isRightTerminal(block) && !(block instanceof CoilBlock)) {
                SpecialFunctionNode specialNode = this.createSpecialFunctionNode(block);
                this.outConnectorToNodeDict.put(obc, specialNode);
            }
            if (obc.getOwner() instanceof CoilBlock || obc.getOwner() instanceof NegativCoilBlock) {
                OutputNode outputNode = this.createOutputNode((CoilBlock)block);
                this.outConnectorToNodeDict.put(obc, outputNode);
            }
            if (obc.getOwner() instanceof LeftPowerRailBlock) {
                HighNode highNode = new HighNode(obc.getOwner());
                return highNode;
            }
        }
        return (BooleanExpressionNode)this.outConnectorToNodeDict.get(obc);
    }

    public boolean isCompilerActivated() {
        return this.fCompilerActivated;
    }

    private void updateMessageLineReferences() {
        Enumeration kopBlocks = this.getBlockTranslationDict().keys();
        Block kopBlock = null;
        Block fupBlock = null;
        MessageParameter kopBlockMessageParameter = null;
        MessageParameter fupBlockMessageParameter = null;
        while (kopBlocks.hasMoreElements()) {
            kopBlock = (Block)kopBlocks.nextElement();
            fupBlock = (Block)this.getBlockTranslationDict().get(kopBlock);
            if (!(kopBlock instanceof MessageBlock)) continue;
            kopBlockMessageParameter = (MessageParameter)kopBlock.getParameter();
            fupBlockMessageParameter = (MessageParameter)fupBlock.getParameter();
            MessageLine[] kopMessageLine = kopBlockMessageParameter.getMessage();
            for (int i = 0; i < kopMessageLine.length; ++i) {
                if (!kopMessageLine[i].hasParameter()) continue;
                Block referencedKopBlock = kopMessageLine[i].getBlockParameter().getBlock();
                Block referencedFupBlock = (Block)this.getBlockTranslationDict().get(referencedKopBlock);
                fupBlockMessageParameter.getMessage()[i].removeAsParameterListener();
                fupBlockMessageParameter.getMessage()[i].setBlockParameter(referencedFupBlock.getParameter());
                fupBlockMessageParameter.getMessage()[i].addAsParameterListener();
            }
        }
    }

    private void optimize(BooleanExpressionNode node, Collection nodes) {
        Iterator patterns = this.fOptimizablePatterns.iterator();
        NodePatternMatcher patternMatcher = null;
        while (patterns.hasNext()) {
            patternMatcher = (NodePatternMatcher)patterns.next();
            if (!patternMatcher.matchesPattern(node)) continue;
            patternMatcher.replacePattern(nodes);
        }
    }

    public WiringDiagram getFup() throws CompilerException {
        if (!this.fWdKop.isModified() && this.fWdFup != null) {
            this.fWdFup.setDrawingProperties(this.getKop().getDrawingProperties().getCopy());
            return this.fWdFup;
        }
        if (!this.isCompilerActivated()) {
            if (this.fWdFup == null) {
                this.fWdFup = new WiringDiagram(this.getKop().getHardware());
            }
            return this.fWdFup;
        }
        this.fWdKop.setModified(false);
        this.compile();
        return this.fWdFup;
    }

    private BooleanExpressionNode getInputNodeForContact(ContactBlock contact) {
        BooleanExpressionNode returnValue = null;
        Block contactSourceBlock = contact.getReferencedOutConnector().getOwner();
        if (!(contactSourceBlock instanceof InputBlock || contactSourceBlock instanceof HighBlock || contactSourceBlock instanceof LowBlock)) {
            returnValue = this.getBooleanExpressionNode(contact.getReferencedOutConnector());
        } else {
            if (!this.fInputBlocksToNodeDict.containsKey(contact.getReferencedOutConnector().getOwner())) {
                this.fInputBlocksToNodeDict.put(contact.getReferencedOutConnector().getOwner(), new InputNode(contact));
            }
            returnValue = (BooleanExpressionNode)this.fInputBlocksToNodeDict.get(contact.getReferencedOutConnector().getOwner());
        }
        if (contact.isNegativ()) {
            if (!this.negativeInputBlocksToNodeDict.containsKey(contact.getReferencedOutConnector())) {
                this.negativeInputBlocksToNodeDict.put(contact.getReferencedOutConnector(), new NotNode(returnValue));
            }
            returnValue = (BooleanExpressionNode)this.negativeInputBlocksToNodeDict.get(contact.getReferencedOutConnector());
        }
        return returnValue;
    }

    public WiringDiagramKop getKop() {
        return this.fWdKop;
    }

    private void compile() throws CompilerException {
        this.fWdFup = new WiringDiagram(this.getKop().getHardware());
        this.fWdFup.setDrawingProperties(this.getKop().getDrawingProperties().getCopy());
        this.fWdFup.setMessageGlobalInfo(this.getKop().getMessageGlobalInfo().deepCopy());
        this.fInputBlocksToNodeDict = new Hashtable();
        this.negativeInputBlocksToNodeDict = new Hashtable();
        this.outConnectorToNodeDict = new Hashtable();
        this.fOrNodeDict = new Hashtable();
        LinkedHashSet nodes = new LinkedHashSet();
        this.fBaseBlockInConnectorCount = this.fUseHardwareDependendOptimization && this.fWdFup.getHardware().supports("4BaseBlockInputs") ? 4 : 3;
        Enumeration kopBlocks = this.getKop().getBlocks().elements();
        Iterator nodesIterator = null;
        BooleanExpressionNode node2 = null;
        try {
            Block block = null;
            while (kopBlocks.hasMoreElements()) {
                block = (Block)kopBlocks.nextElement();
                node2 = null;
                int outConnectorCount = block.getOutConnectorCount();
                if (outConnectorCount > 0) {
                    if ((this.getKop().isRightTerminal(block) || block.getOutConnector(0).getLinkedConnectorsCount() == 0) && !(block instanceof InternMarkerBlock)) {
                        node2 = this.getBooleanExpressionNode(block.getOutConnector(0));
                    }
                } else if (block instanceof CoilBlock) {
                    CoilBlock coilBlock = (CoilBlock)block;
                    if (((CoilBlock)block).getReferencedOutputBlock() instanceof VirtualOutputBlock) {
                        BinaryOutBlockConnector virtualOutBlockConnector = new BinaryOutBlockConnector(coilBlock);
                        node2 = this.getBooleanExpressionNode(virtualOutBlockConnector);
                    }
                }
                if (node2 == null) continue;
                ArrayList subnodes = new ArrayList();
                node2.collectNodes(subnodes);
                nodes.addAll(subnodes);
            }
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Kop-->Fup: Error while creating boolean expression node representation.", e);
        }
        try {
            for (BooleanExpressionNode node2 : new ArrayList(nodes)) {
                this.optimize(node2, nodes);
            }
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Kop-->Fup: Error while optimizing boolean expression node representation.", e);
        }
        try {
            for (BooleanExpressionNode node2 : nodes) {
                node2.compileToFup(this.fWdFup, this);
            }
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Kop-->Fup: Error while creating fup wiring diagram from boolean expression node representation.", e);
        }
        try {
            this.updateMessageLineReferences();
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Kop-->Fup: Error while updating message references.", e);
        }
        this.transferParameterReferences(this.fWdKop, this.fWdFup);
        if (this.fUseHardwareDependendOptimization && this.fWdFup.getHardware().supports("negatableInputs")) {
            this.optimizeNots();
        }
        this.validateBlockNumbers(this.fWdFup);
    }

    private void validateBlockNumbers(WiringDiagram wdFup) {
        for (Block block : wdFup.getBlocks()) {
            if (block.getNumberType() == -1 || block.getNumber() != 0) continue;
            block.setNumber(this.fWdFup.getFreeNumber(block.getNumberType()));
        }
    }

    private void optimizeNots() {
        for (Block block : new ArrayList(this.fWdFup.getBlocks())) {
            if (!(block instanceof NotBlock)) continue;
            OutBlockConnector notOutBlockConnector = block.getOutConnector(0);
            InBlockConnector notInBlockConnector = block.getInConnector(0);
            int notBlockPredecessors = notOutBlockConnector.getLinkedConnectorsCount();
            ArrayList<InBlockConnector> negatableInConnectors = new ArrayList<InBlockConnector>(notOutBlockConnector.getLinkedConnectorsCount());
            InBlockConnectorEnumeration nextInConnectors = notOutBlockConnector.getLinkedConnectors();
            while (nextInConnectors.hasMoreElements()) {
                InBlockConnector nextInBlockConnector = nextInConnectors.nextElement();
                if (!nextInBlockConnector.isNegatable()) continue;
                negatableInConnectors.add(nextInBlockConnector);
            }
            for (InBlockConnector inBlockConnector : negatableInConnectors) {
                inBlockConnector.disconnect(notOutBlockConnector);
                if (!notInBlockConnector.isNegated()) {
                    inBlockConnector.setNegated(!inBlockConnector.isNegated());
                }
                if (notInBlockConnector.getLinkedConnectorCount() != 1) continue;
                OutBlockConnector prevOutConnector = (OutBlockConnector)notInBlockConnector.getLinkedConnectorsList().get(0);
                inBlockConnector.connect(prevOutConnector);
            }
            if (negatableInConnectors.size() != notBlockPredecessors) continue;
            if (notInBlockConnector.getLinkedConnectorCount() == 1) {
                OutBlockConnector prevOutConnector = (OutBlockConnector)notInBlockConnector.getLinkedConnectorsList().get(0);
                notInBlockConnector.disconnect(prevOutConnector);
            }
            this.fWdFup.deleteBlock(block);
        }
    }

    public void setCompilerActivated(boolean newCompilerActivated) {
        this.fCompilerActivated = newCompilerActivated;
        this.fWdKop.setModified(true);
    }

    public void setWdKop(WiringDiagramKop newWdKop) {
        this.fWdKop = newWdKop;
    }

    public Hashtable getBlockTranslationDict() {
        if (this.fKopFupBlockDict == null) {
            this.fKopFupBlockDict = new Hashtable();
        }
        return this.fKopFupBlockDict;
    }

    public boolean isUseHardwareDependendOptimization() {
        return this.fUseHardwareDependendOptimization;
    }

    public void setUseHardwareDependendOptimization(boolean useHardwareDependenOptimization) {
        this.fUseHardwareDependendOptimization = useHardwareDependenOptimization;
        this.fWdFup = null;
    }
}

