/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.InternMarkerBlock;
import DE.siemens.ad.kop.model.block.NegativCoilBlock;
import DE.siemens.ad.kop.model.block.NegativInternMarkerBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.BooleanExpressionNode;
import DE.siemens.ad.kop.model.kopfupcompiler.Compiler;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerException;
import DE.siemens.ad.kop.model.kopfupcompiler.NodeCreationVisitor;
import DE.siemens.ad.kop.model.kopfupcompiler.NotConnectedNode;
import DE.siemens.ad.kop.model.kopfupcompiler.NotNode;
import DE.siemens.ad.kop.model.kopfupcompiler.OutputNode;
import DE.siemens.ad.kop.model.kopfupcompiler.RootNode;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.MessageLine;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CompilerFupToKop
extends Compiler {
    private NodeCreationVisitor fNodeCreationVisitor = new NodeCreationVisitor();
    private Hashtable fFupKopBlockDict;
    private Hashtable fBlockToNodeDict;
    private BooleanExpressionNode fRoot;

    private BooleanExpressionNode addBlock(BooleanExpressionNode parentNode, Block block) {
        BooleanExpressionNode newNode = null;
        if (block == null) {
            NotConnectedNode ncn = new NotConnectedNode();
            parentNode.addChildNode(ncn);
            return ncn;
        }
        BooleanExpressionNode oldNode = (BooleanExpressionNode)this.fBlockToNodeDict.get(block);
        if (oldNode != null) {
            if (!(oldNode instanceof OutputNode) || !(parentNode instanceof RootNode)) {
                parentNode.addChildNode(oldNode);
                return oldNode;
            }
        } else {
            newNode = (BooleanExpressionNode)block.acceptVisitor(this.fNodeCreationVisitor);
            this.fBlockToNodeDict.put(block, newNode);
            parentNode.addChildNode(newNode);
            InBlockConnector[] arr = block.getInConnectors();
            if (arr != null) {
                for (int i = 0; i < arr.length; ++i) {
                    Block prevBlock = arr[i].getLinkedBlock();
                    this.addBlock(newNode, prevBlock);
                }
            }
        }
        return newNode;
    }

    private void insertNotNodes() {
        for (BooleanExpressionNode node : this.fBlockToNodeDict.values()) {
            Block fupBlock = node.getFupBlock();
            if (fupBlock == null) continue;
            for (int j = 0; j < fupBlock.getInConnectorCount(); ++j) {
                if (!fupBlock.getInConnector(j).isNegated()) continue;
                BooleanExpressionNode child = node.getChildAt(j);
                NotNode notNode = new NotNode();
                node.replaceChildNode(child, notNode, j);
                notNode.addChildNode(child);
            }
        }
    }

    public WiringDiagramKop compile(WiringDiagram source) throws CompilerException {
        this.fRoot = new RootNode();
        this.fBlockToNodeDict = new Hashtable();
        this.fFupKopBlockDict = null;
        BooleanExpressionNode tree = null;
        try {
            tree = this.createTree(source);
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Fup-->Kop: Error while creation BooleanExpressionNode representation of the wiring diagram.", e);
        }
        this.insertNotNodes();
        WiringDiagramKop result = new WiringDiagramKop(source.getHardware());
        result.setDrawingProperties(source.getDrawingProperties().getCopy());
        result.setMessageGlobalInfo(source.getMessageGlobalInfo().deepCopy());
        try {
            ((RootNode)tree).getKop(this, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CompilerException("Compiler Fup-->Kop: Error while compiling the BooleanExpressionNode represantation to ladder wiring diagram.", e);
        }
        try {
            this.optimize(result);
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Fup-->Kop: Error while optimizing the ladder wiring diagram.", e);
        }
        try {
            this.connectContactsWithPowerRail(result);
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Fup-->Kop: Error while connecting contacts with power rail.", e);
        }
        try {
            this.updateMessageLineReferences();
        }
        catch (Exception e) {
            throw new CompilerException("Compiler Fup-->Kop: Error while updating messageline references.", e);
        }
        this.transferParameterReferences(source, result);
        WiringDiagram newFup = result.getFup();
        Vector blocksInNewFup = newFup.getBlocks();
        WiringDiagram testFup = new WiringDiagram(newFup.getHardware());
        HashMap resultDict = new HashMap();
        Object[] blocksInNewFupArray = new Block[blocksInNewFup.size()];
        blocksInNewFup.copyInto(blocksInNewFupArray);
        for (int i = 0; i < blocksInNewFupArray.length; ++i) {
            if (!(blocksInNewFupArray[i] instanceof MessageBlock)) continue;
            blocksInNewFupArray[i] = ((Block)blocksInNewFupArray[i]).deepCopy();
        }
        testFup.insert((Block[])blocksInNewFupArray, resultDict);
        if (resultDict.get("err") != null) {
            throw new CompilerException(Language.getString("msg.noresources", "Not enough resource available."));
        }
        return result;
    }

    private BooleanExpressionNode createTree(WiringDiagram source) {
        BooleanExpressionNode result = this.getRoot();
        HashSet rightTerminalBlocks = new HashSet(source.getBlocksWithOpenOutConnectors());
        rightTerminalBlocks.addAll(source.getAnchorsHardware());
        Iterator it = rightTerminalBlocks.iterator();
        while (it.hasNext()) {
            this.addBlock(this.getRoot(), (Block)it.next());
        }
        return result;
    }

    private BooleanExpressionNode getRoot() {
        return this.fRoot;
    }

    private void updateMessageLineReferences() {
        Enumeration fupBlocks = this.getBlockTranslationDict().keys();
        Block fupBlock = null;
        Block kopBlock = null;
        MessageParameter fupBlockMessageParameter = null;
        MessageParameter kopBlockMessageParameter = null;
        while (fupBlocks.hasMoreElements()) {
            fupBlock = (Block)fupBlocks.nextElement();
            kopBlock = (Block)this.getBlockTranslationDict().get(fupBlock);
            if (!(fupBlock instanceof MessageBlock)) continue;
            fupBlockMessageParameter = (MessageParameter)fupBlock.getParameter();
            kopBlockMessageParameter = (MessageParameter)kopBlock.getParameter();
            MessageLine[] fupMessageLine = fupBlockMessageParameter.getMessage();
            for (int i = 0; i < fupMessageLine.length; ++i) {
                if (!fupMessageLine[i].hasParameter()) continue;
                Block referencedFupBlock = fupMessageLine[i].getBlockParameter().getBlock();
                Block referencedKopBlock = (Block)this.getBlockTranslationDict().get(referencedFupBlock);
                kopBlockMessageParameter.getMessage()[i].removeAsParameterListener();
                kopBlockMessageParameter.getMessage()[i].setBlockParameter(referencedKopBlock.getParameter());
                kopBlockMessageParameter.getMessage()[i].addAsParameterListener();
            }
        }
    }

    private void connectContactsWithPowerRail(WiringDiagramKop wiringDiagramKop) {
        Iterator blocks = wiringDiagramKop.getNotConnectedContacts().iterator();
        Block contact = null;
        while (blocks.hasNext()) {
            contact = (Block)blocks.next();
            contact.getInConnector(0).connect(wiringDiagramKop.getLeftPowerRailBlock().getOutConnector(0));
        }
    }

    public Hashtable getBlockTranslationDict() {
        if (this.fFupKopBlockDict == null) {
            this.fFupKopBlockDict = new Hashtable();
        }
        return this.fFupKopBlockDict;
    }

    NegativCoilBlock setNegativInternMarkerCoil(WiringDiagram wd, List prevBlocks) {
        NegativCoilBlock coil = new NegativCoilBlock();
        coil.setReferencedOutputBlock(new NegativInternMarkerBlock());
        wd.insert(coil);
        this.connect(coil.getInConnector(0), prevBlocks);
        return coil;
    }

    void connect(InBlockConnector inConnector, List blocks) {
        Iterator enumeration = blocks.iterator();
        inConnector.disconnectAll();
        while (enumeration.hasNext()) {
            ((Block)enumeration.next()).getOutConnector(0).connect(inConnector);
        }
    }

    CoilBlock setInternMarkerCoil(WiringDiagram wd, List prevBlocks) {
        CoilBlock coil = new CoilBlock();
        coil.setReferencedOutputBlock(new InternMarkerBlock());
        wd.insert(coil);
        if (prevBlocks.size() > 0) {
            this.connect(coil.getInConnector(0), prevBlocks);
        } else if (wd instanceof WiringDiagramKop) {
            System.err.println("Internal Marker get no previous block.");
        }
        return coil;
    }

    private void optimize(WiringDiagram wd) {
        Iterator i = new ArrayList(wd.getBlocks()).iterator();
        Block block = null;
        Block previousBlock = null;
        while (i.hasNext()) {
            Vector connectedBlocks;
            block = (Block)i.next();
            if (!block.getClassName().equals("DE.siemens.ad.kop.model.block.CoilBlock") || !(((CoilBlock)block).getReferencedOutputBlock() instanceof InternMarkerBlock) || block.getInConnector(0).getLinkedConnectorCount() != 1 || !(previousBlock = block.getInConnector(0).getLinkedBlock()).getClassName().equals("DE.siemens.ad.kop.model.block.ContactBlock") || (connectedBlocks = previousBlock.getConnectedBlocks()).size() != 1) continue;
            this.deleteBlockAndReplaceReferences(block, previousBlock, wd);
        }
    }

    private void deleteBlockAndReplaceReferences(Block coilBlock, Block contactBlock, WiringDiagram wd) {
        Enumeration e = wd.getBlocks().elements();
        Block block = null;
        while (e.hasMoreElements()) {
            block = (Block)e.nextElement();
            if (!(block instanceof ContactBlock) || !((ContactBlock)block).getReferencedOutConnector().equals(coilBlock.getOutConnector(0))) continue;
            ((ContactBlock)block).connectToValueSource(((ContactBlock)contactBlock).getReferencedOutConnector());
        }
        wd.deleteBlock(coilBlock);
        wd.deleteBlock(contactBlock);
    }
}

