/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Compiler {
    public abstract Hashtable getBlockTranslationDict();

    public void transferComments(LogoDrawing oldDrawing, LogoDrawing newDrawing) {
        CommentManager oldCommentManager = oldDrawing.getCommentManager();
        CommentManager newCommentManager = newDrawing.getCommentManager();
        Hashtable blockTranslationDict = this.getBlockTranslationDict();
        Enumeration blocksInOldDrawing = blockTranslationDict.keys();
        Block blockInOldDrawing = null;
        Block blockInNewDrawing = null;
        while (blocksInOldDrawing.hasMoreElements()) {
            blockInOldDrawing = (Block)blocksInOldDrawing.nextElement();
            blockInNewDrawing = (Block)blockTranslationDict.get(blockInOldDrawing);
            CommentParameter oldCommentParameter = oldCommentManager.getCommentParameter(blockInOldDrawing);
            if (oldCommentParameter == null || oldCommentParameter.getText() == null || oldCommentParameter.getText().equals("")) continue;
            BlockFigure figureInNewDrawing = newDrawing.getBlockFigure(blockInNewDrawing);
            CommentParameter newCommentParameter = newCommentManager.getCommentParameter(blockInNewDrawing);
            newCommentParameter.setText(oldCommentParameter.getText());
            Enumeration figures = newDrawing.getBlockFigures(blockInNewDrawing.getNumberString()).elements();
            while (figures.hasMoreElements()) {
                ((BlockFigure)figures.nextElement()).setComment(newCommentParameter);
            }
        }
    }

    public void transferParameterReferences(WiringDiagram originalWiringDiagram, WiringDiagram newWiringDiagram) {
        for (Block originalBlock : originalWiringDiagram.getBlocks()) {
            BlockParameter originalBlockParameter = originalBlock.getParameter();
            if (originalBlockParameter == null) continue;
            for (ParameterItem originalReferencingItem : originalBlockParameter.getParameterItems().getValueOrReferenceItems()) {
                ValueOrItemReference originalReference = (ValueOrItemReference)(originalReferencingItem = originalReferencingItem.getInstanceForParameter(originalBlockParameter)).getValue();
                if (originalReference == null || !originalReference.isReference()) continue;
                Block originalReferencedBlock = originalReference.getReference().getParameter().getBlock();
                Block newReferencdedBlock = (Block)this.getBlockTranslationDict().get(originalReferencedBlock);
                Block referencingBlockInNewDrawing = (Block)this.getBlockTranslationDict().get(originalBlock);
                ValueOrItemReference newReference = (ValueOrItemReference)referencingBlockInNewDrawing.getParameter().getParameterItem(originalReferencingItem.getIdentifier()).getValue();
                newReference.setParameter(newReferencdedBlock.getParameter());
                String parameterItemIdentifier = originalReference.getReference().getIdentifier();
                newReference.setReference(newReferencdedBlock.getParameter().getParameterItem(parameterItemIdentifier));
            }
        }
    }
}

