/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.kopfupcompiler;

import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.NegativCoilBlock;
import DE.siemens.ad.kop.model.block.NegativInternMarkerBlock;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerFupToKop;
import DE.siemens.ad.kop.model.kopfupcompiler.CompilerKopToFup;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public abstract class BooleanExpressionNode
implements Comparable {
    protected CoilBlock fCoilBlock = null;
    protected boolean fInternMarkerForced = false;
    protected List fChildren = new ArrayList(5);
    protected List fParents = new ArrayList(5);
    protected boolean fInverted;
    protected boolean fIntermediateResult;
    protected Block fFupBlock;
    protected Block fKopBlock;

    public ContactBlock getContactBlock(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        if (this.fCoilBlock == null) {
            List internPrevBlocks = this.compileToKop(new ArrayList(), this, wd, compiler);
            this.fCoilBlock = compiler.setInternMarkerCoil(wd, internPrevBlocks);
        }
        ContactBlock contact = new ContactBlock(wd, this.fCoilBlock);
        wd.insert(contact);
        compiler.connect(contact.getInConnector(0), prevBlocks);
        return contact;
    }

    public boolean replaceChildNode(BooleanExpressionNode oldNode, BooleanExpressionNode newNode, int index) {
        if (index == -1 && (index = this.fChildren.indexOf(oldNode)) == -1) {
            return false;
        }
        this.fChildren.remove(oldNode);
        oldNode.removeParentNode(this);
        this.fChildren.add(index, newNode);
        newNode.addParentNode(this);
        return true;
    }

    public void addChildNode(BooleanExpressionNode child) {
        if (child == null) {
            return;
        }
        this.fChildren.add(child);
        child.addParentNode(this);
    }

    public Collection getChildren() {
        return this.fChildren;
    }

    public void addParentNode(BooleanExpressionNode parent) {
        if (parent == null) {
            return;
        }
        this.fParents.add(parent);
    }

    public void removeParentNode(BooleanExpressionNode parent) {
        if (parent == null) {
            return;
        }
        this.fParents.remove(parent);
    }

    public int getParentCount() {
        return this.fParents.size();
    }

    public BooleanExpressionNode getParentAt(int index) {
        return (BooleanExpressionNode)this.fParents.get(index);
    }

    public Iterator children() {
        return this.fChildren.iterator();
    }

    protected Block getFupBlock() {
        return this.fFupBlock;
    }

    public BooleanExpressionNode getChildAt(int index) {
        return (BooleanExpressionNode)this.fChildren.get(index);
    }

    public int getChildCount() {
        return this.fChildren.size();
    }

    public boolean isSameType(BooleanExpressionNode toCompare) {
        return this.getClass().getName().equals(toCompare.getClass().getName()) && toCompare.isInverted() == this.isInverted();
    }

    public abstract Block compileToFup(WiringDiagram var1, CompilerKopToFup var2);

    protected List compileToKop(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        throw new UnsupportedOperationException();
    }

    public List getCompiledKopBlock(List prevBlocks, BooleanExpressionNode callingNode, WiringDiagramKop wd, CompilerFupToKop compiler) {
        if (this.fInternMarkerForced && this.getParentCount() > 1) {
            ArrayList<ContactBlock> returnList = new ArrayList<ContactBlock>(1);
            returnList.add(this.getContactBlock(prevBlocks, callingNode, wd, compiler));
            return returnList;
        }
        return this.compileToKop(prevBlocks, callingNode, wd, compiler);
    }

    public List handleNegation(List prevBlocks, WiringDiagram wd, CompilerFupToKop compiler) {
        ArrayList<ContactBlock> result = null;
        if (this.isInverted()) {
            this.setInverted(false);
            NegativCoilBlock coil = new NegativCoilBlock();
            coil.setReferencedOutputBlock(new NegativInternMarkerBlock());
            wd.insert(coil);
            compiler.connect(coil.getInConnector(0), prevBlocks);
            ContactBlock contactBlock = new ContactBlock(wd, coil);
            wd.insert(contactBlock);
            result = new ArrayList<ContactBlock>(1);
            result.add(contactBlock);
        } else {
            result = prevBlocks;
        }
        return result;
    }

    public boolean isIntermediateResult() {
        return this.fIntermediateResult;
    }

    public boolean isInverted() {
        return this.fInverted;
    }

    public void removeChildNode(BooleanExpressionNode child) {
        this.fChildren.remove(child);
        child.removeParentNode(this);
    }

    protected void connectFupBlockWithChildren(Block fupBlock, WiringDiagram wd, CompilerKopToFup compiler) {
        if (fupBlock == null) {
            return;
        }
        Iterator childrenEnum = this.children();
        InBlockConnector[] inBlockConnectors = fupBlock.getInConnectors();
        int connectorIndex = 0;
        BooleanExpressionNode child = null;
        while (childrenEnum.hasNext()) {
            child = (BooleanExpressionNode)childrenEnum.next();
            Block childFupBlock = child.compileToFup(wd, compiler);
            if (childFupBlock != null) {
                inBlockConnectors[connectorIndex].connect(childFupBlock.getOutConnector(0));
            }
            ++connectorIndex;
        }
    }

    public void setFupBlock(Block fupBlock) {
        this.fFupBlock = fupBlock;
    }

    protected void setIntermediateResult(boolean newIntermediateResult) {
        this.fIntermediateResult = newIntermediateResult;
    }

    protected void setInverted(boolean newNegative) {
        this.fInverted = newNegative;
    }

    public String toString() {
        String name = "";
        try {
            String className = this.getClass().getName();
            StringTokenizer st = new StringTokenizer(className, ".");
            while (st.hasMoreTokens()) {
                name = st.nextToken();
            }
            if (this.fFupBlock != null) {
                name = name + " " + this.getFupBlock().getNumberString();
            } else if (this.fKopBlock != null) {
                name = name + " " + this.getKopBlock().getNumberString();
            }
        }
        catch (Exception e) {
            name = "Exception caught";
        }
        return name;
    }

    public String getPreviousBlocksString(List previousBlocks) {
        StringBuffer returnString = new StringBuffer();
        Iterator e = previousBlocks.iterator();
        while (e.hasNext()) {
            returnString.append(e.next().hashCode());
        }
        return returnString.toString();
    }

    public Block getKopBlock() {
        return this.fKopBlock;
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public void collectNodes(List nodes) {
        nodes.add(this);
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (nodes.contains(this.getChildAt(i))) continue;
            this.getChildAt(i).collectNodes(nodes);
        }
    }

    public boolean getInternMarkerForced() {
        return this.fInternMarkerForced;
    }

    public void setInternMarkerForced(boolean fInternMarkerForced) {
        this.fInternMarkerForced = fInternMarkerForced;
    }
}

