/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.block;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.kop.model.ContactParameter;
import DE.siemens.ad.kop.model.LadderDiagramBlock;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockNameChangedListener;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ContactBlock
extends LadderDiagramBlock
implements BlockNameChangedListener {
    static final long serialVersionUID = 102L;
    private int serializedDataVersion = 1;
    protected ContactParameter fLadderDiagramContactParameter = null;
    protected String lastNumberString = "?";
    protected InBlockConnector fValueSourceInConnector;

    public ContactBlock() {
    }

    public ContactBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public ContactBlock(WiringDiagram wiringDiagram, Block block) {
        super(wiringDiagram);
        this.connectToValueSource(block.getOutConnector(0));
    }

    public void blockNameChanged(Block block) {
        this.fireBlockNameChangedEvent();
    }

    public void connectToValueSource(OutBlockConnector outConnector) {
        if (this.fValueSourceInConnector.getLinkedConnector() != null) {
            this.disconnectFromValueSource();
        }
        this.fValueSourceInConnector.connect(outConnector);
        this.fValueSourceInConnector.getLinkedConnector().getOwner().addBlockNameChangedListener(this);
        this.fireBlockNameChangedEvent();
    }

    public void disconnectFromValueSource() {
        this.getReferencedOutConnector().getOwner().removeBlockNameChangedListener(this);
        this.fValueSourceInConnector.disconnect(this.fValueSourceInConnector.getLinkedConnector());
    }

    public double calculateAnalogValue() {
        return this.getReferencedOutConnector().calculateAnalogValue();
    }

    protected boolean calculateBinaryContactValue() {
        boolean binaryValue = ((BinaryOutBlockConnector)this.getReferencedOutConnector()).calculateBinaryValue();
        return binaryValue;
    }

    public boolean getBinaryContactValue() {
        boolean binaryValue = ((BinaryOutBlockConnector)this.getReferencedOutConnector()).getBinaryValue();
        return binaryValue;
    }

    public boolean calculateBinaryValue() {
        boolean inputValue = ((BinaryInBlockConnector)this.getInConnector(0)).calculateBinaryValue();
        return this.calculateBinaryContactValue() && inputValue;
    }

    public int getOutConnectorValueType() {
        return this.getReferencedOutConnector().getValueTyp();
    }

    protected int getDefaultOrder() {
        return 10100;
    }

    public int getNumber() {
        if (this.getReferencedOutConnector() == null) {
            return 0;
        }
        return this.getReferencedOutConnector().getOwner().getNumber();
    }

    public String getNumberString() {
        String numberString = "?";
        if (this.getReferencedOutConnector() != null) {
            numberString = this.getReferencedOutConnector().getOwner().getNumberString();
        }
        return numberString;
    }

    public String getNumberPrefix() {
        String numberString = "?";
        if (this.getReferencedOutConnector() != null) {
            numberString = this.getReferencedOutConnector().getOwner().getNumberPrefix();
        }
        return numberString;
    }

    public String getNumberPostfix() {
        String numberString = "";
        if (this.getReferencedOutConnector() != null) {
            numberString = this.getReferencedOutConnector().getOwner().getNumberPostfix();
        }
        return numberString;
    }

    public BlockParameter getParameter() {
        if (this.fLadderDiagramContactParameter == null) {
            this.fLadderDiagramContactParameter = new ContactParameter(this);
        }
        return this.fLadderDiagramContactParameter;
    }

    public OutBlockConnector getReferencedOutConnector() {
        if (this.fValueSourceInConnector != null) {
            return this.fValueSourceInConnector.getLinkedConnector();
        }
        return null;
    }

    public void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "1");
        this.fValueSourceInConnector = new BinaryInBlockConnector(this, false, "value");
    }

    public boolean isNegativ() {
        return false;
    }

    public String preInsert(WiringDiagram wd) {
        String inputBlockName = "I1";
        OutBlockConnector referencedOutConnector = this.getReferencedOutConnector();
        if (referencedOutConnector == null) {
            this.connectToValueSource(((WiringDiagramKop)wd).getContactSourceBlock(inputBlockName).getOutConnector(0));
            this.getParameter().setBlockNumberString(this.getNumberString());
        } else {
            inputBlockName = referencedOutConnector.getOwner().getNumberString();
            Block contactInputBlock = ((WiringDiagramKop)wd).getContactSourceBlock(inputBlockName);
            if (contactInputBlock != null) {
                this.connectToValueSource(contactInputBlock.getOutConnector(0));
            }
        }
        return null;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fValueSourceInConnector = (InBlockConnector)dr.readStorable();
        this.fValueSourceInConnector.connect((OutBlockConnector)dr.readStorable());
        this.fLadderDiagramContactParameter = (ContactParameter)dr.readStorable();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fValueSourceInConnector);
        dw.writeStorable(this.fValueSourceInConnector.getLinkedConnector());
        dw.writeStorable(this.fLadderDiagramContactParameter);
    }

    public SimulationParameter getSimulationParameter() {
        if (this.getReferencedOutConnector() != null) {
            return this.getReferencedOutConnector().getOwner().getSimulationParameter();
        }
        return null;
    }

    public String getToolTipText() {
        String tooltip = super.getToolTipText();
        return tooltip;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.getReferencedOutConnector().getOwner().init(interpreter, forceReset);
    }

    public List getAllInConnectors() {
        ArrayList<InBlockConnector> allInConnectors = new ArrayList<InBlockConnector>(super.getAllInConnectors());
        allInConnectors.add(this.fValueSourceInConnector);
        return allInConnectors;
    }
}

