/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model.block;

import DE.siemens.ad.kop.model.AnalogCoilParameter;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.AnalogContactBlock;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.model.AnalogBlock;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.BlockEnumeration;
import java.util.List;

public class AnalogCoilBlock
extends CoilBlock
implements AnalogBlock {
    private static final long serialVersionUID = 1018744220766250860L;
    private transient double fAnalogValue;
    private transient double fAnalogProcessImageValue;

    public AnalogCoilBlock() {
    }

    public AnalogCoilBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    public BlockParameter getParameter() {
        if (this.fLadderDiagramCoilParameter == null) {
            this.fLadderDiagramCoilParameter = new AnalogCoilParameter(this);
        }
        return this.fLadderDiagramCoilParameter;
    }

    public String preInsert(WiringDiagram wd) {
        WiringDiagramKop wiringDiagramKOP = (WiringDiagramKop)wd;
        OutputBlock freeOutputBlock = wiringDiagramKOP.getFreeAnalogOutputBlock(this.getReferencedOutputBlock());
        this.setReferencedOutputBlock(freeOutputBlock);
        return null;
    }

    protected void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new AnalogInBlockConnector(this, 0.0, "1");
    }

    protected void initOutConnectors() {
        this.fOutConnectors = new OutBlockConnector[1];
        this.fOutConnectors[0] = new AnalogOutBlockConnector(this);
        this.fOutConnectors[0].setVisible(false);
    }

    public void collectSensors(List sensorContainer) {
        BlockEnumeration nextAnalogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (nextAnalogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)nextAnalogBlocks.nextBlock());
            analogBlock.collectSensors(sensorContainer);
        }
    }

    public void addMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.addMeasurementBoundsChangedListener(listener);
        }
    }

    public void removeMeasurementBoundsChangedListener(ParameterSetListener listener) {
        BlockEnumeration analogBlocks = this.getOutConnector(0).getLinkedBlocks();
        while (analogBlocks.hasMoreElements()) {
            AnalogBlock analogBlock = (AnalogBlock)((Object)analogBlocks.nextBlock());
            analogBlock.removeMeasurementBoundsChangedListener(listener);
        }
    }

    public double calculateAnalogValue() {
        this.fAnalogValue = this.fInConnectors[0].calculateAnalogValue();
        return this.fAnalogProcessImageValue;
    }

    public ContactBlock getContactBlock() {
        AnalogContactBlock result = new AnalogContactBlock();
        result.connectToValueSource(this.getOutConnector(0));
        return result;
    }

    public void endCalculation() {
        this.fAnalogProcessImageValue = this.fAnalogValue;
    }

    public double getAnalogValue() {
        return this.fAnalogValue;
    }

    public void setAnalogValue(double analogValue) {
        this.fAnalogValue = analogValue;
    }

    public void reset() {
        this.fAnalogValue = 0.0;
        this.fAnalogProcessImageValue = 0.0;
    }
}

