/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.model;

import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.WiringDiagram;

public class LadderDiagramBlock
extends Block {
    static final long serialVersionUID = 100L;
    private int serializedDataVersion = 1;
    private String fNumberPrefix = "?";

    public LadderDiagramBlock() {
    }

    public LadderDiagramBlock(WiringDiagram wiringDiagram) {
        super(wiringDiagram);
    }

    protected int getDefaultOrder() {
        return 100;
    }

    public String getNumberString(int blockNumber) {
        String string;
        String blockName = this.getNumberPrefix();
        if (blockNumber > 0) {
            if ((blockName.equals("SF") || blockName.equals("T") || blockName.equals("C")) && blockNumber < 10) {
                string = "0" + Integer.toString(blockNumber);
                string = this.getNumberPrefix() + string.substring(string.length() - 2);
            } else {
                string = this.getNumberPrefix() + Integer.toString(blockNumber);
            }
        } else {
            string = this.getNumberPrefix();
        }
        return string;
    }

    public int getOutConnectorCount() {
        if (this.fOutConnectors == null) {
            return 0;
        }
        return this.fOutConnectors.length;
    }

    public String getType() {
        return "LadderDiagram";
    }

    public void initBlockNumber() {
    }

    public void initInConnectors() {
        this.fInConnectors = new InBlockConnector[1];
        this.fInConnectors[0] = new BinaryInBlockConnector(this, false, "1");
    }

    public boolean isLeftTerminal() {
        return false;
    }

    public void setNumberPrefix(String numberPrefix) {
        String oldName = this.getNumberString();
        this.fNumberPrefix = numberPrefix;
    }

    public void setNumberString(String newName) {
        String oldName = this.getNumberString();
        int i = 0;
        if (!newName.equals("Low") && !newName.equals("High")) {
            while (!Character.isDigit(newName.charAt(i))) {
                ++i;
            }
            this.fBlockNumber = Integer.parseInt(newName.substring(i));
            this.fNumberPrefix = newName.substring(0, i);
        } else {
            this.fNumberPrefix = newName;
        }
    }
}

