/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.app;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import DE.siemens.ad.kop.figures.LeftPowerRailFigure;
import DE.siemens.ad.kop.model.LeftPowerRailBlock;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.util.LayoutProducer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class LayoutProducerKop
extends LayoutProducer {
    protected List blocks;
    protected int fMaxRow;
    protected Hashtable blockFigures;
    private int fHorizontalDistance = 70;
    private int fVerticalDistance = 50;
    private Hashtable fBlockFigureColumnDict = new Hashtable();
    private int fHorizontalLineDistance;
    public static final int HORIZONTAL_LINE_DISTANCE = 10;

    public LayoutProducerKop(DrawingView view, List blocks) {
        super(view, blocks);
        this.fView = view;
        this.blocks = blocks;
    }

    private void calculateDistances() {
        int distance;
        int grid;
        for (distance = grid = ((LogoDrawingView)this.fView).getGridInfo().getDistance(); distance < 60; distance += grid) {
        }
        this.fHorizontalDistance = this.fVerticalDistance = distance;
        this.fHorizontalLineDistance = grid;
    }

    public Figure createBlockFigure(Block block, int column, int row) {
        if (block instanceof LeftPowerRailBlock) {
            return this.getLeftPowerRail();
        }
        if (this.blockFigures.containsKey(block)) {
            return (BlockFigure)this.blockFigures.get(block);
        }
        this.fMaxRow = Math.max(this.fMaxRow, row);
        int xPosition = (Integer)this.fBlockFigureColumnDict.get(block);
        Point destinationPoint = new Point(xPosition * this.fHorizontalDistance, this.fMaxRow * this.fVerticalDistance);
        BlockFigure thisFigure = new BlockFigure(block, destinationPoint);
        thisFigure.moveAlignmentAnchorTo(destinationPoint);
        this.fView.drawing().add(thisFigure);
        this.blockFigures.put(block, thisFigure);
        int rowIncrement = 0;
        for (int i = 0; i < block.getInConnectorCount(); ++i) {
            OutBlockConnectorEnumeration outConnectors = block.getInConnector(i).getLinkedConnectors();
            OutBlockConnector outConnector = null;
            Figure previousFigure = null;
            while (outConnectors.hasMoreElements()) {
                outConnector = outConnectors.nextElement();
                if (outConnector == null) continue;
                previousFigure = this.createBlockFigure(outConnector.getOwner(), column - 1, this.fMaxRow + rowIncrement);
                if (previousFigure instanceof LeftPowerRailFigure) {
                    this.createConnection(previousFigure.connectorAt(0, 0), thisFigure.getInputIfcFigure(block.getInConnector(i)).connectorAt(0, 0), i);
                    continue;
                }
                this.createConnection(((BlockFigure)previousFigure).getOutputIfcFigure(outConnector).connectorAt(0, 0), thisFigure.getInputIfcFigure(block.getInConnector(i)).connectorAt(0, 0), i);
                rowIncrement = 1;
            }
        }
        return thisFigure;
    }

    protected void createConnection(Connector start, Connector end, int offset) {
        FixedElbowConnection fec = new FixedElbowConnection();
        fec.connectStart(start);
        fec.connectEnd(end);
        fec.layoutConnection();
        this.fView.drawing().add(fec);
        fec.moveBy((offset - 1) * 10, 0);
    }

    protected LeftPowerRailFigure getLeftPowerRail() {
        FigureEnumeration figures = this.fView.drawing().figures();
        Figure figure = null;
        while (figures.hasMoreElements()) {
            figure = figures.nextFigure();
            if (!(figure instanceof LeftPowerRailFigure)) continue;
            return (LeftPowerRailFigure)figure;
        }
        return null;
    }

    public void layout() {
        List blocks = this.findRightTerminalBlocks(this.blocks);
        this.sortRightTerminals(blocks);
        int columns = this.breitensuche(blocks);
        this.calculateDistances();
        int row = 1;
        int column = 0;
        this.fMaxRow = 0;
        this.blockFigures = new Hashtable();
        Block block2 = null;
        for (Block block2 : blocks) {
            if (block2 instanceof OutputBlock || block2.getOutConnectorCount() == 0 || block2.getOutConnector(0).getLinkedConnectorsCount() == 0 || block2.getWiringDiagram().isRightTerminal(block2)) {
                this.createBlockFigure(block2, column, row);
            }
            row = this.fMaxRow + 1;
        }
        ((LogoDrawing)this.fView.drawing()).updateConnections();
        this.adaptPages(columns * this.fHorizontalDistance + this.fHorizontalDistance, this.fMaxRow * this.fVerticalDistance + this.fVerticalDistance);
    }

    public void layout2() {
        this.layout();
    }

    private List findRightTerminalBlocks(List blocks) {
        ArrayList<Block> rightTerminals = new ArrayList<Block>();
        Iterator blockEnumeration = blocks.iterator();
        Block block = null;
        while (blockEnumeration.hasNext()) {
            block = (Block)blockEnumeration.next();
            if (!(block instanceof OutputBlock) && block.getOutConnectorCount() != 0 && block.getOutConnector(0).getLinkedConnectorsCount() != 0 && !block.getWiringDiagram().isRightTerminal(block)) continue;
            rightTerminals.add(block);
        }
        return rightTerminals;
    }

    private void findRightTerminals(Block block, List rightTerminals, List visitedBlocks) {
        if (visitedBlocks.contains(block) || block instanceof LeftPowerRailBlock) {
            return;
        }
        visitedBlocks.add(block);
        Vector connectedBlocks = null;
        if (block.getWiringDiagram() != null && block.getWiringDiagram().isRightTerminal(block)) {
            if (!rightTerminals.contains(block)) {
                rightTerminals.add(block);
            }
            connectedBlocks = block.getViaInConnectorConnectedBlocks();
        } else {
            connectedBlocks = block.getConnectedBlocks();
        }
        Iterator e = connectedBlocks.iterator();
        while (e.hasNext()) {
            this.findRightTerminals((Block)e.next(), rightTerminals, visitedBlocks);
        }
    }

    private int breitensuche(List toVisit) {
        ArrayList newToVisit = new ArrayList();
        Iterator blocks = toVisit.iterator();
        Block block2 = null;
        while (blocks.hasNext()) {
            block2 = (Block)blocks.next();
            newToVisit.addAll(block2.getViaInConnectorConnectedBlocks());
        }
        int column = -1;
        if (!toVisit.isEmpty()) {
            column = this.breitensuche(newToVisit) + 1;
        }
        for (Block block2 : toVisit) {
            if (this.fBlockFigureColumnDict.containsKey(block2)) continue;
            this.fBlockFigureColumnDict.put(block2, new Integer(column));
        }
        return column;
    }

    private void sortRightTerminals(List rightTerminals) {
        ArrayList<Block> processed = new ArrayList<Block>();
        Stack notProcessed = new Stack();
        notProcessed.addAll(rightTerminals);
        Block block = null;
        while (!notProcessed.empty()) {
            block = (Block)notProcessed.pop();
            if (processed.contains(block)) continue;
            processed.add(block);
            Vector rightTerminalsForBlock = new Vector();
            Vector visited = new Vector(rightTerminals.size());
            this.findRightTerminals(block, rightTerminalsForBlock, visited);
            rightTerminalsForBlock.remove(block);
            int rightTerminalsForBlockCount = rightTerminalsForBlock.size();
            for (int i = rightTerminalsForBlockCount - 1; i >= 0; --i) {
                notProcessed.remove(rightTerminalsForBlock.elementAt(i));
                notProcessed.push(rightTerminalsForBlock.elementAt(i));
            }
        }
        rightTerminals.clear();
        rightTerminals.addAll(processed);
    }
}

