/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.kop.app;

import DE.siemens.ad.kop.model.LeftPowerRailBlock;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.kop.model.block.InternMarkerBlock;
import DE.siemens.ad.kop.model.block.NegativContactBlock;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.pdraw.simulation.ProcessImageParser;
import java.util.List;

public class KopProcessImageParser
extends ProcessImageParser {
    public KopProcessImageParser(Hardware hardware) {
        super(hardware);
    }

    public boolean getIMOutputValue(Block block) {
        if (this.isInternalMarker(block)) {
            return this.getLinkedInputValue(block);
        }
        return false;
    }

    public boolean isInternalMarker(Block block) {
        return block instanceof CoilBlock && ((CoilBlock)block).getReferencedOutputBlock() instanceof InternMarkerBlock;
    }

    protected int getOffsetInProcessImage(Block block) {
        if (block instanceof CoilBlock) {
            if (this.isInternalMarker(block)) {
                return -1;
            }
            return this.getOffsetInProcessImage(((CoilBlock)block).getReferencedOutputBlock());
        }
        if (block instanceof ContactBlock) {
            return -1;
        }
        return super.getOffsetInProcessImage(block);
    }

    protected boolean getDigitalValue(Block block) {
        boolean ret = super.getDigitalValue(block);
        List parallelConnectorsVector = block.getOutConnector(0).findParallelOutBlockConnectors();
        for (int i = 0; i < parallelConnectorsVector.size(); ++i) {
            ret = ret || super.getDigitalValue(((BinaryOutBlockConnector)parallelConnectorsVector.get(i)).getOwner());
        }
        return ret;
    }

    protected boolean getBlockValue(Block block) {
        if (block instanceof ContactBlock) {
            Block contactedBlock = ((ContactBlock)block).getReferencedOutConnector().getOwner();
            boolean contactedValue = this.isInternalMarker(contactedBlock) ? contactedBlock.getBinaryValue() : this.getDigitalValue(contactedBlock);
            ((BinaryOutBlockConnector)contactedBlock.getOutConnector(0)).setBinaryValue(contactedValue);
            boolean inputValue = this.getLinkedInputValue(block);
            if (block instanceof NegativContactBlock) {
                contactedValue = !contactedValue;
            }
            boolean ret = inputValue && contactedValue;
            return ret;
        }
        if (block instanceof LeftPowerRailBlock) {
            return true;
        }
        return super.getBlockValue(block);
    }

    private boolean getLinkedInputValue(Block block) {
        Block linkedBlock;
        boolean inputValue = false;
        OutBlockConnectorEnumeration outConnectors = block.getInConnector(0).getLinkedConnectors();
        while (outConnectors.hasMoreElements() && !(inputValue = (linkedBlock = outConnectors.nextElement().getOwner()) == null ? false : (linkedBlock instanceof LeftPowerRailBlock ? true : this.getDigitalValue(linkedBlock)))) {
        }
        return inputValue;
    }
}

