/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;

public class StandardDrawing
extends Observable
implements Drawing {
    private Vector fFigures = new Vector();
    private transient Rectangle fDamage;
    private transient Thread fDrawingLockHolder = null;
    protected String fStorePath = null;
    private static final long serialVersionUID = -2602151437447962046L;
    private int drawingSerializedDataVersion = 1;

    public synchronized Figure add(Figure figure) {
        if (this.fFigures.contains(figure)) {
            return figure;
        }
        this.fFigures.addElement(figure);
        figure.setContainer(this);
        this.setModified(true);
        return figure;
    }

    public void addAll(Vector newFigures) {
        Enumeration k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.add((Figure)k.nextElement());
        }
    }

    public synchronized Figure addFigureAt(Figure figure, int index) {
        this.fFigures.insertElementAt(figure, index);
        figure.setContainer(this);
        this.setModified(true);
        return figure;
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.addElement(figure);
            figure.changed();
        }
    }

    public void checkDamage() {
        if (this.fDamage != null) {
            this.setChanged();
            this.notifyObservers(this.fDamage);
            this.fDamage = null;
        }
    }

    public void draw(Graphics g) {
        FigureEnumeration k = this.figures();
        Rectangle r = g.getClipBounds();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (r != null && !r.intersects(f.displayBox())) continue;
            f.draw(g);
        }
    }

    public void draw(Graphics g, FigureDrawInfo fdi) {
        FigureEnumeration k = this.figures();
        Rectangle r = g.getClipBounds();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (r != null && !r.intersects(f.displayBox())) continue;
            f.draw(g, fdi);
        }
    }

    public final Drawing drawing() {
        return this;
    }

    public final FigureEnumeration figures() {
        return new FigureEnumerator(this.fFigures);
    }

    public final FigureEnumeration figuresReverse() {
        return new ReverseFigureEnumerator(this.fFigures);
    }

    public Figure findFigure(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle r, Figure without) {
        if (without == null) {
            return this.findFigure(r);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle fr = figure.displayBox();
            if (!r.intersects(fr) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInside(int x, int y) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure().findFigureInside(x, y);
            if (figure == null) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int x, int y, Figure without) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure found;
            Figure figure = k.nextFigure();
            if (figure == without || (found = figure.findFigureInside(x, y)) == null || found == without) continue;
            return found;
        }
        return null;
    }

    public Figure findFigureWithout(int x1, int y1, int x2, int y2, Figure without) {
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.intersectsLine(x1, y1, x2, y2) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int x, int y, Figure without) {
        if (without == null) {
            return this.findFigure(x, y);
        }
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.containsPoint(x, y) || figure.includes(without)) continue;
            return figure;
        }
        return null;
    }

    public Vector findMultiFigureWithout(int x1, int y1, int x2, int y2, Figure without) {
        Vector<Figure> retVector = new Vector<Figure>();
        FigureEnumeration k = this.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (!figure.intersectsLine(x1, y1, x2, y2) || figure.includes(without)) continue;
            retVector.addElement(figure);
        }
        return retVector;
    }

    public void forceUpdate() {
        this.checkDamage();
    }

    public Vector getFigures() {
        return this.fFigures;
    }

    public int getIndexOfFigure(Figure f) {
        return this.fFigures.indexOf(f);
    }

    public Dimension getMinimumSize() {
        FigureEnumeration enumeration = this.figures();
        Dimension result = new Dimension(0, 0);
        Figure f = null;
        while (enumeration.hasMoreElements()) {
            f = enumeration.nextFigure();
            if (!f.isSelectable()) continue;
            Rectangle r = f.displayBox();
            result.width = Math.max(result.width, r.x + r.width);
            result.height = Math.max(result.height, r.y + r.height);
        }
        return result;
    }

    public String getStorePath() {
        return this.fStorePath;
    }

    public void invalidate(Rectangle rect) {
        if (this.fDamage == null) {
            this.fDamage = rect;
        } else {
            this.fDamage.add(rect);
        }
    }

    public synchronized void lock() {
        Thread current = Thread.currentThread();
        if (this.fDrawingLockHolder == current) {
            return;
        }
        while (this.fDrawingLockHolder != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fDrawingLockHolder = current;
    }

    public synchronized Figure orphan(Figure figure) {
        this.fFigures.removeElement(figure);
        return figure;
    }

    public void orphanAll(Vector newFigures) {
        Enumeration k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.orphan((Figure)k.nextElement());
        }
    }

    public void read(StorableInput dr) throws IOException {
        int size = dr.readInt();
        this.fFigures = new Vector(size);
        for (int i = 0; i < size; ++i) {
            Figure figure = (Figure)dr.readStorable();
            this.fFigures.addElement(figure);
            figure.setContainer(this);
        }
        this.fDamage = null;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().setContainer(this);
        }
        this.fDamage = null;
    }

    public void release() {
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            k.nextFigure().release();
        }
    }

    public synchronized Figure remove(Figure figure) {
        if (figure.container() != null) {
            return figure.container().removeFromDrawing(figure);
        }
        return null;
    }

    public void removeAll(Vector newFigures) {
        Enumeration k = newFigures.elements();
        while (k.hasMoreElements()) {
            this.remove((Figure)k.nextElement());
        }
    }

    public Figure removeFromDrawing(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            figure.setContainer(null);
            figure.release();
            this.setModified(true);
            return figure;
        }
        return null;
    }

    public synchronized void replace(Figure figure, Figure replacement) {
        int index = this.fFigures.indexOf(figure);
        if (index != -1) {
            replacement.setContainer(this);
            figure.changed();
            this.fFigures.setElementAt(replacement, index);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.insertElementAt(figure, 0);
            figure.changed();
        }
    }

    public void setChanged() {
        super.setChanged();
    }

    public void setIndexOfFigure(Figure f, int index) {
        if (!this.fFigures.contains(f)) {
            return;
        }
        this.fFigures.remove(f);
        this.fFigures.insertElementAt(f, index);
        f.changed();
    }

    public void setStorePath(String path) {
        this.fStorePath = path;
    }

    public synchronized void unlock() {
        if (this.fDrawingLockHolder != null) {
            this.fDrawingLockHolder = null;
            this.notifyAll();
        }
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.fFigures.size());
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            dw.writeStorable(k.nextFigure());
        }
    }

    public void setModified(boolean modified) {
    }
}

