/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.MouseTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CommentParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SelectionTool
extends AbstractTool {
    private MouseTracker fInteractor = null;

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem("New");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectionTool.this.doit("new");
            }
        });
        popup.add(mi);
        popup.addSeparator();
        mi = new JMenuItem("Open...");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectionTool.this.doit("open");
            }
        });
        popup.add(mi);
        mi = new JMenuItem("Save As...");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectionTool.this.doit("save");
            }
        });
        popup.add(mi);
        return popup;
    }

    void doit(String text) {
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        if (e.getClickCount() >= 2) {
            Figure figure = view.drawing().findFigure(e.getX(), e.getY());
            if (figure instanceof BlockFigure) {
                BlockFigure bF = (BlockFigure)figure;
                Vector<Parameter> v = new Vector<Parameter>();
                Block block = bF.getBlock();
                BlockParameter par = block.getParameter();
                if (par != null) {
                    v.addElement(block.getParameter());
                }
                String oldComment = null;
                CommentParameter comPar = bF.getCommentParameter();
                if (comPar != null) {
                    v.addElement(comPar);
                    oldComment = comPar.getText();
                }
                LogoComfort logoComfort = (LogoComfort)view.editor();
                LogoAction editBlockPropertiesAction = logoComfort.getActionFactory().getAction("EditBlockPropertiesAction");
                logoComfort.getActionManager().invokeAction(editBlockPropertiesAction);
            }
            return;
        }
        if (this.fInteractor != null) {
            return;
        }
        view.freezeView();
        Handle handle = view.findHandle(e.getX(), e.getY());
        if (handle != null) {
            this.fInteractor = new HandleTracker(handle);
        } else {
            Figure figure = view.drawing().findFigure(e.getX(), e.getY());
            if (figure != null) {
                this.fInteractor = new DragTracker(figure);
            } else {
                if (!e.isControlDown()) {
                    view.clearSelection();
                }
                this.fInteractor = new SelectAreaTracker();
            }
        }
        this.fInteractor.mouseDown(e, x, y, view);
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        if (this.fInteractor != null) {
            this.fInteractor.mouseDrag(e, x, y, view);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        view.unfreezeView();
        if (this.fInteractor != null) {
            this.fInteractor.mouseUp(e, x, y, view);
        }
        this.fInteractor = null;
        if (e.isPopupTrigger()) {
            JPopupMenu popup = this.createPopupMenu();
            Container cont = (Container)e.getComponent();
            popup.show(cont, x, y);
            Container c2 = (Container)((Object)view);
        }
    }
}

