/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.standard.IconTextTooltip;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    protected Connector fOriginalTarget;
    protected Figure fTarget = null;
    protected ConnectionFigure fConnection = (ConnectionFigure)this.owner();
    protected Point fStart;
    protected IconTextTooltip fTextLabel;

    protected ChangeConnectionHandle(Figure owner) {
        super(owner);
    }

    protected abstract void connect(Connector var1, DrawingView var2);

    protected abstract void disconnect();

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.green);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    protected Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    private Connector findConnectionTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && target.canConnect() && target != this.fOriginalTarget && !target.includes(this.owner()) && this.fConnection.canConnect(this.source().owner(), target)) {
            return this.findConnector(x, y, target);
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target == null) {
            target = this.fOriginalTarget;
        }
        this.setPoint(x, y);
        this.connect(target, view);
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
            this.fTarget = null;
        }
        ((JComponent)((Object)view)).remove(this.fTextLabel);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.fOriginalTarget = this.target();
        this.fStart = new Point(x, y);
        this.disconnect();
        if (this.fTextLabel == null) {
            this.fTextLabel = new IconTextTooltip();
            this.fTextLabel.setBackground(new Color(255, 255, 204));
        }
        ((JComponent)((Object)view)).add(this.fTextLabel);
        this.fTextLabel.setVisible(false);
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = this.findConnectableFigure(x, y, view.drawing());
        if (f != this.fTarget) {
            this.showTooltip(f, x, y, view);
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = f;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        }
        this.setPoint(p.x, p.y);
    }

    protected abstract void setPoint(int var1, int var2);

    private void showTooltip(Figure fTarget, int x, int y, DrawingView view) {
        if (fTarget instanceof InputIfcFigure) {
            String fText = ((InBlockConnector)((InputIfcFigure)fTarget).getBlockConnector()).getName();
            if (fText.length() > 0) {
                double zoomFactor = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
                x = (int)(zoomFactor * (double)x);
                y = (int)(zoomFactor * (double)y);
                this.fTextLabel.setText(fText);
                this.fTextLabel.setLocation(x + 10, y - 5);
                this.fTextLabel.pack();
                this.fTextLabel.setVisible(true);
            }
        } else {
            this.fTextLabel.setVisible(false);
        }
    }

    protected Connector source() {
        if (this.target() == this.fConnection.start()) {
            return this.fConnection.end();
        }
        return this.fConnection.start();
    }

    protected abstract Connector target();
}

