/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChangedFigureEvent;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DeletedFigureEvent;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureContainer;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Observable;
import java.util.Vector;

public abstract class AbstractFigure
extends Observable
implements Figure {
    private transient FigureContainer fContainer;
    private static final long serialVersionUID = -10857585979273442L;
    private int abstractFigureSerializedDataVersion = 1;
    protected transient boolean fConnectorVisibility = false;
    protected transient FigureConstraint figureConstraint;

    protected AbstractFigure() {
    }

    public abstract void basicDisplayBox(Point var1, Point var2);

    protected abstract void basicMoveBy(int var1, int var2);

    public boolean canConnect() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public Point center() {
        return Geom.center(this.displayBox());
    }

    public void changed() {
        this.invalidate();
        this.setChanged();
        this.notifyObservers(new ChangedFigureEvent());
    }

    public void basicDisplayBox(Rectangle newDisplayBox) {
        Point lowerRightPoint = new Point(newDisplayBox.getLocation());
        lowerRightPoint.translate(newDisplayBox.width, newDisplayBox.height);
        this.basicDisplayBox(newDisplayBox.getLocation(), lowerRightPoint);
    }

    public Object clone() {
        Object clone = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream writer = new ObjectOutputStream(output);
            writer.writeObject(this);
            writer.close();
        }
        catch (IOException e) {
            Log.error(e, "Class not found");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        try {
            ObjectInputStream reader = new ObjectInputStream(input);
            clone = reader.readObject();
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return clone;
    }

    public Locator connectedTextLocator(Figure text) {
        return RelativeLocator.north();
    }

    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopBoxConnector(this);
    }

    public void connectorVisibility(boolean isVisible) {
        if (this.fConnectorVisibility != isVisible) {
            this.fConnectorVisibility = isVisible;
            this.changed();
        }
    }

    public FigureContainer container() {
        return this.fContainer;
    }

    public boolean containsPoint(int x, int y) {
        return this.displayBox().contains(x, y);
    }

    public FigureConstraint createConstraint() {
        return new FigureConstraint(this);
    }

    public FigureEnumeration decompose() {
        Vector<AbstractFigure> figures = new Vector<AbstractFigure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    public abstract Rectangle displayBox();

    public Rectangle selectionBox() {
        return this.displayBox();
    }

    public void displayBox(Point origin, Point corner) {
        this.willChange();
        this.basicDisplayBox(origin, corner);
        this.changed();
    }

    public void displayBox(Rectangle r) {
        this.displayBox(new Point(r.x, r.y), new Point(r.x + r.width, r.y + r.height));
    }

    public void draw(Graphics g, FigureDrawInfo gdi) {
        this.draw(g);
    }

    public Drawing drawing() {
        if (this.container() != null) {
            return this.container().drawing();
        }
        return null;
    }

    public void drawSimulation1(Graphics g) {
    }

    public Point getSnatchPoint(Point cursorPosition) {
        return Geom.center(this.displayBox());
    }

    public void drawSimulation2(Graphics g) {
    }

    public void drawSimulation3(Graphics g) {
    }

    public FigureEnumeration figures() {
        Vector<AbstractFigure> figures = new Vector<AbstractFigure>(1);
        figures.addElement(this);
        return new FigureEnumerator(figures);
    }

    public boolean isSelectable() {
        return true;
    }

    public void finalize() {
    }

    public Figure findFigureInside(int x, int y) {
        if (this.containsPoint(x, y)) {
            return this;
        }
        return null;
    }

    public Object getAttribute(String name) {
        return null;
    }

    public FigureConstraint getConstraint() {
        if (this.figureConstraint == null) {
            this.figureConstraint = this.createConstraint();
        }
        return this.figureConstraint;
    }

    public Point getAlignmentAnchor() {
        return new Point(this.displayBox().getLocation());
    }

    public int getPageNumber() {
        LogoDrawing drawing = (LogoDrawing)this.drawing();
        Rectangle rect = this.displayBox();
        if (drawing == null) {
            return 0;
        }
        return drawing.getPageNumber(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    public abstract Vector handles();

    public boolean includes(Figure figure) {
        return figure == this;
    }

    public boolean intersectsLine(int x1, int y1, int x2, int y2) {
        return false;
    }

    public boolean intersectsRectangle(Rectangle r) {
        return r.intersects(this.displayBox());
    }

    public void invalidate() {
        if (this.fContainer != null) {
            Rectangle r = this.displayBox();
            r.grow(8, 8);
            this.fContainer.invalidate(r);
        }
    }

    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    public void moveBy(int dx, int dy) {
        this.willChange();
        this.basicMoveBy(dx, dy);
        this.changed();
    }

    public void read(StorableInput dr) throws IOException {
        this.figureConstraint = (FigureConstraint)dr.readStorable();
        if (this.figureConstraint == null) {
            this.figureConstraint.setFigure(this);
        }
    }

    public void release() {
        this.setChanged();
        this.notifyObservers(new DeletedFigureEvent());
    }

    public void setAttribute(String name, Object value) {
    }

    public void setConstraint(FigureConstraint constraint) {
        this.figureConstraint = constraint;
    }

    public void setContainer(FigureContainer c) {
        this.willChange();
        this.fContainer = c;
        this.changed();
    }

    public Dimension size() {
        return new Dimension(this.displayBox().width, this.displayBox().height);
    }

    public void willChange() {
        this.invalidate();
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.getConstraint());
    }

    public void moveTo(Point destinationPoint) {
        Point location = this.displayBox().getLocation();
        this.moveBy(destinationPoint.x - location.x, destinationPoint.y - location.y);
    }

    public void moveAlignmentAnchorTo(Point destinationPoint) {
        Point anchorLocation = this.getAlignmentAnchor();
        this.moveBy(destinationPoint.x - anchorLocation.x, destinationPoint.y - anchorLocation.y);
    }
}

