/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.FloatingTextField;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.pdraw.action.DeleteFigureAction;
import DE.siemens.ad.pdraw.action.InsertCommentAction;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class TextTool
extends CreationTool {
    private FloatingTextField fTextField;
    private TextHolder fTypingTarget;

    public TextTool(Figure prototype) {
        super(prototype);
    }

    public void activate(DrawingView view) {
        super.activate(view);
        view.clearSelection();
    }

    protected void beginEdit(TextHolder figure, DrawingView view) {
        if (this.fTextField == null) {
            this.fTextField = new FloatingTextField();
        }
        if (figure != this.fTypingTarget && this.fTypingTarget != null) {
            this.endEdit(view);
        }
        this.fTextField.createOverlay((Container)((Object)view), figure.getFont());
        this.fTextField.setBounds(this.fieldBounds(figure, view), figure.getText());
        this.fTypingTarget = figure;
    }

    protected void createAndInvokeDeleteAction(TextFigure commentFigure, ActionManager actionManager) {
        DeleteFigureAction deleteFigureAction = (DeleteFigureAction)actionManager.getActionFactory().getAction("DeleteFigureAction");
        deleteFigureAction.setConstraint(commentFigure.getConstraint());
        actionManager.invokeAction(deleteFigureAction);
    }

    protected void createAndInvokeInsertCommentAction(TextFigure commentFigure, ActionManager actionManager) {
        InsertCommentAction insertCommentAction = (InsertCommentAction)actionManager.getActionFactory().getAction("InsertCommentAction");
        insertCommentAction.setCommentFigure(commentFigure);
        actionManager.invokeAction(insertCommentAction);
    }

    public void deactivate(DrawingView view) {
        super.deactivate(view);
        this.endEdit(view);
    }

    protected void endEdit(DrawingView view) {
        if (this.fTypingTarget != null) {
            this.fTypingTarget.setText(this.fTextField.getText());
            ActionManager actionManager = ((Editor)((Object)view.editor())).getActionManager();
            String commentText = this.fTypingTarget.getText();
            if (commentText == null || commentText.equals("")) {
                this.createAndInvokeDeleteAction((TextFigure)this.fTypingTarget, actionManager);
            } else {
                this.createAndInvokeInsertCommentAction((TextFigure)this.fTypingTarget, actionManager);
            }
            ((TextFigure)this.fTypingTarget).updateLocation();
            this.fTypingTarget = null;
            this.fTextField.endOverlay();
            view.checkDamage();
        }
    }

    private Rectangle fieldBounds(TextHolder figure, DrawingView view) {
        double zoomFactor = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
        Rectangle box = figure.textDisplayBox();
        int nChars = figure.overlayColumns();
        Dimension d = this.fTextField.getPreferredSize(nChars);
        return new Rectangle((int)((double)box.x * zoomFactor), (int)((double)box.y * zoomFactor), d.width, d.height);
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        TextHolder textHolder = null;
        Figure pressedFigure = view.drawing().findFigureInside(x, y);
        if (pressedFigure instanceof TextHolder && !(textHolder = (TextHolder)((Object)pressedFigure)).acceptsTyping()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.beginEdit(textHolder, view);
            return;
        }
        if (this.fTypingTarget != null) {
            this.endEdit(view);
        } else {
            super.mouseDown(e, x, y, view);
            textHolder = (TextHolder)((Object)this.createdFigure());
            this.beginEdit(textHolder, view);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
    }
}

