/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.framework.DeletedFigureEvent;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class TextFigure
extends AttributeFigure
implements Observer,
TextHolder {
    protected int fOriginX = 0;
    protected int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private String fWholeText;
    private String fLineText;
    private Font fFont = this.createCurrentFont();
    private boolean fIsReadOnly;
    protected Figure fObservedFigure = null;
    protected OffsetLocator fLocator = null;
    private static String fgCurrentFontName = "Dialog";
    private static int fgCurrentFontSize = 12;
    private static int fgCurrentFontStyle = 0;
    private static Color fgCurrentFontColor = Color.black;
    private static final long serialVersionUID = 4599820785949456124L;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this.setAttribute("FillColor", ColorMap.color("color.none"));
        this.setAttribute("TextColor", fgCurrentFontColor);
        this.fWholeText = new String("");
        this.fSizeIsDirty = true;
    }

    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    public void basicDisplayBox(Point newOrigin, Point newCorner) {
        this.fOriginX = newOrigin.x;
        this.fOriginY = newOrigin.y;
    }

    protected void basicMoveBy(int x, int y) {
        this.fOriginX += x;
        this.fOriginY += y;
    }

    public void changed() {
        super.changed();
    }

    public Object clone() {
        TextFigure figure = (TextFigure)super.clone();
        figure.fFont = this.createCurrentFont();
        figure.setAttribute("TextColor", fgCurrentFontColor);
        return figure;
    }

    public void connect(Figure figure) {
        if (this.fObservedFigure != null) {
            this.fObservedFigure.getConstraint().removeBirectionalLink(this.getConstraint());
        }
        figure.getConstraint().addBidirectionalLink(this.getConstraint());
        this.fObservedFigure = figure;
        this.fLocator = new OffsetLocator(figure.connectedTextLocator(this));
    }

    public Font createCurrentFont() {
        return new Font(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public void disconnect() {
        this.fObservedFigure.getConstraint().removeBirectionalLink(this.getConstraint());
        this.fObservedFigure = null;
        this.fLocator = null;
    }

    public Rectangle displayBox() {
        Dimension extent = this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, extent.width, extent.height);
    }

    public void drawBackground(Graphics g) {
        Rectangle r = this.displayBox();
        g.fillRect(r.x, r.y, r.width, r.height);
    }

    public void drawFrame(Graphics g) {
        g.setFont(this.fFont);
        g.setColor((Color)this.getAttribute("TextColor"));
        FontMetrics metrics = g.getFontMetrics(this.fFont);
        int index = 0;
        int offset = 0;
        while (index != -1) {
            index = this.getNextLine(index);
            if (!this.fLineText.equalsIgnoreCase("")) {
                g.drawString(this.fLineText, this.fOriginX, this.fOriginY + metrics.getAscent() + metrics.getHeight() * offset);
                ++offset;
                continue;
            }
            g.drawString(" ", this.fOriginX, this.fOriginY + metrics.getAscent() + metrics.getHeight() * offset);
            ++offset;
        }
    }

    public Object getAttribute(String name) {
        Font font = this.getFont();
        if (name.equals("FontSize")) {
            return new Integer(font.getSize());
        }
        if (name.equals("FontStyle")) {
            return new Integer(font.getStyle());
        }
        if (name.equals("FontName")) {
            return font.getName();
        }
        return super.getAttribute(name);
    }

    public static Color getCurrentFontColor() {
        return fgCurrentFontColor;
    }

    public static String getCurrentFontName() {
        return fgCurrentFontName;
    }

    public static int getCurrentFontSize() {
        return fgCurrentFontSize;
    }

    public static int getCurrentFontStyle() {
        return fgCurrentFontStyle;
    }

    public Font getFont() {
        return this.fFont;
    }

    int getNextLine(int startingIndex) {
        try {
            int linefeedIndex = this.fWholeText.indexOf(10, startingIndex);
            if (linefeedIndex != -1) {
                this.fLineText = this.fWholeText.substring(startingIndex, linefeedIndex);
                startingIndex = linefeedIndex + 1;
            } else {
                this.fLineText = this.fWholeText.substring(startingIndex);
                startingIndex = -1;
            }
            return startingIndex;
        }
        catch (StringIndexOutOfBoundsException e) {
            this.fLineText = "";
            startingIndex = -1;
            return startingIndex;
        }
    }

    public Figure getObservedFigure() {
        return this.fObservedFigure;
    }

    public String getText() {
        return this.fWholeText;
    }

    public Vector handles() {
        Vector<LocatorHandle> handles = new Vector<LocatorHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        handles.addElement(new FontSizeHandle(this, RelativeLocator.southWest()));
        return handles;
    }

    int lineCount() {
        if (this.fWholeText == null || this.fWholeText.equals("")) {
            return 0;
        }
        int lines = 0;
        int startIndex = 0;
        int index = 0;
        while (index != -1) {
            index = this.fWholeText.indexOf(10, startIndex);
            startIndex = index + 1;
            ++lines;
        }
        return lines;
    }

    protected void markDirty() {
        this.fSizeIsDirty = true;
    }

    public void moveBy(int x, int y) {
        this.willChange();
        this.basicMoveBy(x, y);
        if (this.fLocator != null) {
            this.fLocator.moveBy(x, y);
        }
        this.changed();
    }

    public int overlayColumns() {
        int columns = 20;
        int index = 0;
        while (index != -1) {
            index = this.getNextLine(index);
            int tmpColumns = this.fLineText.length() + 1;
            if (tmpColumns <= columns) continue;
            columns = tmpColumns;
        }
        return columns;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.markDirty();
        this.fOriginX = dr.readInt();
        this.fOriginY = dr.readInt();
        this.fWholeText = dr.readString();
        this.fFont = new Font(dr.readString(), dr.readInt(), dr.readInt());
        this.fIsReadOnly = dr.readBoolean();
        this.fObservedFigure = (Figure)dr.readStorable();
        this.fLocator = (OffsetLocator)dr.readStorable();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.getConstraint().addBidirectionalLink(this.getConstraint());
        }
        this.markDirty();
        if (System.getProperty("os.name", "unknown").equals("Mac OS X")) {
            int style = this.fFont.getStyle();
            String name = this.fFont.getName();
            int size = this.fFont.getSize();
            this.fFont = new Font(name, style, size);
        }
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    public void release() {
        super.release();
        if (this.fObservedFigure != null) {
            this.fObservedFigure.deleteObserver(this);
        }
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        Font font = this.getFont();
        if (name.equals("FontSize")) {
            Integer s = (Integer)value;
            this.setFont(new Font(font.getName(), font.getStyle(), s));
        } else if (name.equals("FontStyle")) {
            Integer s = (Integer)value;
            int style = font.getStyle();
            style = s;
            this.setFont(new Font(font.getName(), style, font.getSize()));
        } else if (name.equals("FontName")) {
            String n = (String)value;
            this.setFont(new Font(n, font.getStyle(), font.getSize()));
        }
    }

    public static void setCurrentFontColor(Color color) {
        fgCurrentFontColor = color;
    }

    public static void setCurrentFontName(String name) {
        fgCurrentFontName = name;
    }

    public static void setCurrentFontSize(int size) {
        fgCurrentFontSize = size;
    }

    public static void setCurrentFontStyle(int style) {
        fgCurrentFontStyle = style;
    }

    public void setFont(Font newFont) {
        this.willChange();
        this.fFont = newFont;
        this.markDirty();
        this.changed();
    }

    public void setReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public void setText(String newText) {
        if (!newText.equals(this.fWholeText)) {
            this.willChange();
            this.fWholeText = new String(newText);
            this.markDirty();
            this.changed();
        }
    }

    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    protected Dimension textExtent() {
        if (!this.fSizeIsDirty) {
            return new Dimension(this.fWidth, this.fHeight);
        }
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fFont);
        this.fWidth = 0;
        int index = 0;
        while (index != -1) {
            index = this.getNextLine(index);
            int tmpWidth = metrics.stringWidth(this.fLineText);
            if (tmpWidth <= this.fWidth) continue;
            this.fWidth = tmpWidth;
        }
        this.fHeight = metrics.getHeight() * this.lineCount();
        this.fSizeIsDirty = false;
        this.fWidth += 3;
        return new Dimension(this.fWidth, this.fHeight);
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof DeletedFigureEvent && this.container() != null) {
            this.container().removeFromDrawing(this);
        }
        this.updateLocation();
    }

    protected void updateLocation() {
        if (this.fLocator != null) {
            Point p = this.fLocator.locate(this.fObservedFigure);
            p.x -= this.size().width / 2 + this.fOriginX;
            p.y -= this.size().height / 2 + this.fOriginY;
            if (p.x != 0 || p.y != 0) {
                this.willChange();
                this.basicMoveBy(p.x, p.y);
                this.changed();
            }
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fOriginX);
        dw.writeInt(this.fOriginY);
        dw.writeString(this.fWholeText);
        dw.writeString(this.fFont.getName());
        dw.writeInt(this.fFont.getStyle());
        dw.writeInt(this.fFont.getSize());
        dw.writeBoolean(this.fIsReadOnly);
        dw.writeStorable(this.fObservedFigure);
        dw.writeStorable(this.fLocator);
    }
}

