/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.PolyLineHandle;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DeletedFigureEvent;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Observable;
import java.util.Vector;

public class LineConnection
extends PolyLineFigure
implements ConnectionFigure {
    protected Connector fStart = null;
    protected Connector fEnd = null;
    private static final long serialVersionUID = 6883731614578414801L;
    private int lineConnectionSerializedDataVersion = 1;

    public LineConnection() {
        super(4);
        this.setStartDecoration(new ArrowTip());
        this.setEndDecoration(new ArrowTip());
    }

    protected void basicMoveBy(int dx, int dy) {
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            ((Point)this.fPoints.elementAt(i)).translate(dx, dy);
        }
    }

    public boolean canConnect() {
        return false;
    }

    public boolean canConnect(Figure start, Figure end) {
        return true;
    }

    public void connectEnd(Connector end) {
        this.fEnd = end;
    }

    public boolean connectsSame(ConnectionFigure other) {
        return other.start() == this.start() && other.end() == this.end();
    }

    public void connectStart(Connector start) {
        this.fStart = start;
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.endFigure().deleteObserver(this);
        this.fEnd = null;
    }

    public void disconnectStart() {
        this.startFigure().deleteObserver(this);
        this.fStart = null;
    }

    public Connector end() {
        return this.fEnd;
    }

    public Figure endFigure() {
        if (this.end() != null) {
            return this.end().owner();
        }
        return null;
    }

    public Point endPoint() {
        Point p = (Point)this.fPoints.lastElement();
        return new Point(p.x, p.y);
    }

    public void endPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() < 2) {
            this.fPoints.addElement(new Point(x, y));
        } else {
            this.fPoints.setElementAt(new Point(x, y), this.fPoints.size() - 1);
        }
        this.changed();
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    protected void handleDisconnect(Figure start, Figure end) {
    }

    public Vector handles() {
        Vector<AbstractHandle> handles = new Vector<AbstractHandle>(this.fPoints.size());
        handles.addElement(new ChangeConnectionStartHandle(this));
        for (int i = 1; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new PolyLineHandle(this, LineConnection.locator(i), i));
        }
        handles.addElement(new ChangeConnectionEndHandle(this));
        return handles;
    }

    public void insertPointAt(Point p, int i) {
        super.insertPointAt(p, i);
        this.layoutConnection();
    }

    public void layoutConnection() {
        this.updateConnection();
    }

    public void read(StorableInput dr) throws IOException {
        Connector end;
        super.read(dr);
        Connector start = (Connector)dr.readStorable();
        if (start != null) {
            this.connectStart(start);
        }
        if ((end = (Connector)dr.readStorable()) != null) {
            this.connectEnd(end);
        }
        if (start != null && end != null) {
            this.updateConnection();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.fStart != null) {
            this.connectStart(this.fStart);
        }
        if (this.fEnd != null) {
            this.connectEnd(this.fEnd);
        }
    }

    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        if (this.fStart != null) {
            this.startFigure().deleteObserver(this);
        }
        if (this.fEnd != null) {
            this.endFigure().deleteObserver(this);
        }
    }

    public void removePointAt(int i) {
        super.removePointAt(i);
        this.layoutConnection();
    }

    public void setPointAt(Point p, int i) {
        super.setPointAt(p, i);
        this.layoutConnection();
    }

    public Connector start() {
        return this.fStart;
    }

    public Figure startFigure() {
        if (this.start() != null) {
            return this.start().owner();
        }
        return null;
    }

    public Point startPoint() {
        Point p = (Point)this.fPoints.firstElement();
        return new Point(p.x, p.y);
    }

    public void startPoint(int x, int y) {
        this.willChange();
        if (this.fPoints.size() == 0) {
            this.fPoints.addElement(new Point(x, y));
        } else {
            this.fPoints.setElementAt(new Point(x, y), 0);
        }
        this.changed();
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof DeletedFigureEvent) {
            if (this.container() != null) {
                this.container().removeFromDrawing(this);
            }
        } else {
            this.updateConnection();
        }
    }

    public void updateConnection() {
        if (this.fStart != null) {
            Point start = this.fStart.findStart(this);
            this.startPoint(start.x, start.y);
        }
        if (this.fEnd != null) {
            Point end = this.fEnd.findEnd(this);
            this.endPoint(end.x, end.y);
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fStart);
        dw.writeStorable(this.fEnd);
    }
}

